/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerInterface;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;

public interface CoMTrajectoryProvider
extends CoMTrajectoryPlannerInterface {
    public List<? extends Polynomial3DReadOnly> getVRPTrajectories();

    public MultipleSegmentPositionTrajectoryGenerator<?> getCoMTrajectory();

    @Override
    default public int getSegmentNumber(double time) {
        double startTime = 0.0;
        for (int i = 0; i < this.getVRPTrajectories().size(); ++i) {
            if (this.getVRPTrajectories().get(i).timeIntervalContains(time - startTime)) {
                return i;
            }
            startTime += this.getVRPTrajectories().get(i).getDuration();
        }
        return -1;
    }

    @Override
    default public double getTimeInSegment(int segmentNumber, double time) {
        for (int i = 0; i < segmentNumber; ++i) {
            time -= this.getVRPTrajectories().get(i).getDuration();
        }
        return time;
    }
}

