/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;

public class CoMTrajectoryPlannerTools {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean SET_ZERO_VALUES = false;
    public static final double minDuration = 1.0E-5;
    public static final double sufficientlyLarge = 1.0E10;
    public static final double sufficientlyLongTime = 10.0;
    public static final CoefficientProvider comPositionCoefficientProvider = CoMTrajectoryPlannerTools::getCoMPositionCoefficientTimeFunction;
    private static final CoefficientProvider comVelocityCoefficientProvider = CoMTrajectoryPlannerTools::getCoMVelocityCoefficientTimeFunction;
    private static final CoefficientProvider comAccelerationCoefficientProvider = CoMTrajectoryPlannerTools::getCoMAccelerationCoefficientTimeFunction;
    private static final CoefficientProvider comJerkCoefficientProvider = CoMTrajectoryPlannerTools::getCoMJerkCoefficientTimeFunction;
    private static final CoefficientProvider dcmPositionCoefficientProvider = CoMTrajectoryPlannerTools::getDCMPositionCoefficientTimeFunction;
    private static final CoefficientProvider vrpPositionCoefficientProvider = CoMTrajectoryPlannerTools::getVRPPositionCoefficientTimeFunction;
    private static final CoefficientProvider vrpVelocityCoefficientProvider = CoMTrajectoryPlannerTools::getVRPVelocityCoefficientTimeFunction;
    public static final CoefficientSelectedProvider comPositionCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getCoMPositionCoefficientNonZero;
    private static final CoefficientSelectedProvider comVelocityCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getCoMVelocityCoefficientNonZero;
    private static final CoefficientSelectedProvider comAccelerationCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getCoMAccelerationCoefficientNonZero;
    private static final CoefficientSelectedProvider comJerkCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getCoMJerkCoefficientNonZero;
    private static final CoefficientSelectedProvider dcmPositionCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getDCMPositionCoefficientNonZero;
    private static final CoefficientSelectedProvider dcmVelocityCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getDCMVelocityCoefficientNonZero;
    private static final CoefficientSelectedProvider vrpPositionCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getVRPPositionCoefficientNonZero;
    private static final CoefficientSelectedProvider vrpVelocityCoefficientSelectedProvider = CoMTrajectoryPlannerTools::getVRPVelocityCoefficientNonZero;

    public static void computeVRPWaypoints(double nominalCoMHeight, double gravityZ, double omega, FrameVector3DReadOnly currentCoMVelocity, List<? extends ContactStateProvider> contactSequence, RecyclingArrayList<FramePoint3D> startVRPPositionsToPack, RecyclingArrayList<FramePoint3D> endVRPPositionsToPack) {
        CoMTrajectoryPlannerTools.computeVRPWaypoints(nominalCoMHeight, gravityZ, omega, currentCoMVelocity, contactSequence, startVRPPositionsToPack, endVRPPositionsToPack, true);
    }

    public static void computeVRPWaypoints(double nominalCoMHeight, double gravityZ, double omega, FrameVector3DReadOnly currentCoMVelocity, List<? extends ContactStateProvider> contactSequence, RecyclingArrayList<FramePoint3D> startVRPPositionsToPack, RecyclingArrayList<FramePoint3D> endVRPPositionsToPack, boolean adjustWaypointHeightForHeightChange) {
        startVRPPositionsToPack.clear();
        endVRPPositionsToPack.clear();
        double initialHeightVelocity = currentCoMVelocity.getZ();
        for (int i = 0; i < contactSequence.size() - 1; ++i) {
            double finalHeightVelocity;
            ContactStateProvider contactStateProvider = contactSequence.get(i);
            boolean finalContact = i == contactSequence.size() - 1;
            ContactStateProvider nextContactStateProvider = null;
            if (!finalContact) {
                nextContactStateProvider = contactSequence.get(i + 1);
            }
            FramePoint3D start = (FramePoint3D)startVRPPositionsToPack.add();
            FramePoint3D end = (FramePoint3D)endVRPPositionsToPack.add();
            start.set((FrameTuple3DReadOnly)contactStateProvider.getECMPStartPosition());
            start.addZ(nominalCoMHeight);
            end.set((FrameTuple3DReadOnly)contactStateProvider.getECMPEndPosition());
            end.addZ(nominalCoMHeight);
            if (!adjustWaypointHeightForHeightChange) continue;
            double duration = contactStateProvider.getTimeInterval().getDuration();
            duration = Math.signum(duration) * Math.max(Math.abs(duration), 1.0E-5);
            if (!contactStateProvider.getContactState().isLoadBearing()) {
                finalHeightVelocity = initialHeightVelocity - gravityZ * duration;
            } else if (!finalContact && !nextContactStateProvider.getContactState().isLoadBearing()) {
                ContactStateProvider nextNextContactStateProvider = contactSequence.get(i + 2);
                double heightBeforeJump = contactStateProvider.getECMPEndPosition().getZ();
                double finalHeightAfterJump = nextNextContactStateProvider.getECMPStartPosition().getZ();
                double heightChangeWhenJumping = finalHeightAfterJump - heightBeforeJump;
                double durationOfJump = nextContactStateProvider.getTimeInterval().getDuration();
                finalHeightVelocity = heightChangeWhenJumping / durationOfJump + 0.5 * gravityZ * durationOfJump;
            } else {
                finalHeightVelocity = 0.0;
            }
            double heightVelocityChange = finalHeightVelocity - initialHeightVelocity;
            double offset = heightVelocityChange / (MathTools.square((double)omega) * duration);
            start.subZ(offset);
            end.subZ(offset);
            initialHeightVelocity = finalHeightVelocity;
        }
        ContactStateProvider contactStateProvider = contactSequence.get(contactSequence.size() - 1);
        FramePoint3D start = (FramePoint3D)startVRPPositionsToPack.add();
        FramePoint3D end = (FramePoint3D)endVRPPositionsToPack.add();
        start.set((FrameTuple3DReadOnly)contactStateProvider.getECMPStartPosition());
        start.addZ(nominalCoMHeight);
        end.set((FrameTuple3DReadOnly)contactStateProvider.getECMPEndPosition());
        end.addZ(nominalCoMHeight);
    }

    public static void computeVRPVelocites(List<? extends ContactStateProvider<?>> contactSequence, RecyclingArrayList<FrameVector3D> startVRPVelocitiesToPack, RecyclingArrayList<FrameVector3D> endVRPVelocitiesToPack) {
        startVRPVelocitiesToPack.clear();
        endVRPVelocitiesToPack.clear();
        for (int i = 0; i < contactSequence.size(); ++i) {
            ContactStateProvider<?> contactStateProvider = contactSequence.get(i);
            FrameVector3D start = (FrameVector3D)startVRPVelocitiesToPack.add();
            FrameVector3D end = (FrameVector3D)endVRPVelocitiesToPack.add();
            start.set((FrameTuple3DReadOnly)contactStateProvider.getECMPStartVelocity());
            end.set((FrameTuple3DReadOnly)contactStateProvider.getECMPEndVelocity());
        }
    }

    public static void addCoMPositionConstraint(FramePoint3DReadOnly centerOfMassLocationForConstraint, double omega, double time, int sequenceId, int rowStart, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        centerOfMassLocationForConstraint.checkReferenceFrameMatch(worldFrame);
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        constraintMatrixToPack.set(rowStart, colStart, CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(rowStart, colStart + 1, CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(rowStart, colStart + 2, CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(time));
            constraintMatrixToPack.set(rowStart, colStart + 3, CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(time));
            constraintMatrixToPack.set(rowStart, colStart + 4, CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(time));
        }
        constraintMatrixToPack.set(rowStart, colStart + 5, CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction());
        xObjectiveMatrixToPack.set(rowStart, 0, centerOfMassLocationForConstraint.getX());
        yObjectiveMatrixToPack.set(rowStart, 0, centerOfMassLocationForConstraint.getY());
        zObjectiveMatrixToPack.set(rowStart, 0, centerOfMassLocationForConstraint.getZ());
    }

    public static void addCoMPositionObjective(double weight, FramePoint3DReadOnly centerOfMassLocationForConstraint, double omega, double time, int sequenceId, int rowStart, DMatrix objectiveJacobianToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        centerOfMassLocationForConstraint.checkReferenceFrameMatch(worldFrame);
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart, weight * CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 1, weight * CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 2, weight * CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(time));
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 3, weight * CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(time));
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 4, weight * CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(time));
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 5, weight * CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction());
        xObjectiveMatrixToPack.set(rowStart, 0, weight * centerOfMassLocationForConstraint.getX());
        yObjectiveMatrixToPack.set(rowStart, 0, weight * centerOfMassLocationForConstraint.getY());
        zObjectiveMatrixToPack.set(rowStart, 0, weight * centerOfMassLocationForConstraint.getZ());
    }

    public static void addCoMPositionObjective(double weight, FramePoint3DReadOnly centerOfMassLocationForConstraint, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)centerOfMassLocationForConstraint, comPositionCoefficientProvider, comPositionCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addCoMVelocityConstraint(FrameVector3DReadOnly centerOfMassVelocityForConstraint, double omega, double time, int sequenceId, int rowStart, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        centerOfMassVelocityForConstraint.checkReferenceFrameMatch(worldFrame);
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        constraintMatrixToPack.set(rowStart, colStart, CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(rowStart, colStart + 1, CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(rowStart, colStart + 2, CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(time));
            constraintMatrixToPack.set(rowStart, colStart + 3, CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(time));
        }
        constraintMatrixToPack.set(rowStart, colStart + 4, CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
        xObjectiveMatrixToPack.set(rowStart, 0, centerOfMassVelocityForConstraint.getX());
        yObjectiveMatrixToPack.set(rowStart, 0, centerOfMassVelocityForConstraint.getY());
        zObjectiveMatrixToPack.set(rowStart, 0, centerOfMassVelocityForConstraint.getZ());
    }

    public static void addCoMVelocityObjective(double weight, FrameVector3DReadOnly centerOfMassVelocityForConstraint, double omega, double time, int sequenceId, int rowStart, DMatrix objectiveJacobianToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        centerOfMassVelocityForConstraint.checkReferenceFrameMatch(worldFrame);
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart, weight * CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 1, weight * CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 2, weight * CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(time));
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 3, weight * CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(time));
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, colStart + 4, weight * CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
        CoMTrajectoryPlannerTools.addEquals(xObjectiveMatrixToPack, rowStart, 0, weight * centerOfMassVelocityForConstraint.getX());
        CoMTrajectoryPlannerTools.addEquals(yObjectiveMatrixToPack, rowStart, 0, weight * centerOfMassVelocityForConstraint.getY());
        CoMTrajectoryPlannerTools.addEquals(zObjectiveMatrixToPack, rowStart, 0, weight * centerOfMassVelocityForConstraint.getZ());
    }

    public static void addCoMVelocityObjective(double weight, FrameVector3DReadOnly centerOfMassVelocityForConstraint, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)centerOfMassVelocityForConstraint, comVelocityCoefficientProvider, comVelocityCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addCoMJerkObjective(double weight, FrameVector3DReadOnly centerOfMassJerkObjective, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)centerOfMassJerkObjective, comJerkCoefficientProvider, comJerkCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addDCMPositionObjective(double weight, FramePoint3DReadOnly dcmLocationForConstraint, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)dcmLocationForConstraint, dcmPositionCoefficientProvider, dcmPositionCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addVRPPositionObjective(double weight, FramePoint3DReadOnly vrpLocationForConstraint, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)vrpLocationForConstraint, vrpPositionCoefficientProvider, vrpPositionCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addVRPVelocityObjective(double weight, FrameVector3DReadOnly vrpVelocityForConstraint, double omega, double time, int sequenceId, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)vrpVelocityForConstraint, vrpVelocityCoefficientProvider, vrpVelocityCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addDCMPositionConstraint(int sequenceId, int rowStart, double time, double omega, FramePoint3DReadOnly desiredDCMPosition, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        desiredDCMPosition.checkReferenceFrameMatch(worldFrame);
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        constraintMatrixToPack.set(rowStart, startIndex, CoMTrajectoryPlannerTools.getDCMPositionFirstCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(rowStart, startIndex + 2, CoMTrajectoryPlannerTools.getDCMPositionThirdCoefficientTimeFunction(omega, time));
            constraintMatrixToPack.set(rowStart, startIndex + 3, CoMTrajectoryPlannerTools.getDCMPositionFourthCoefficientTimeFunction(omega, time));
        }
        constraintMatrixToPack.set(rowStart, startIndex + 4, CoMTrajectoryPlannerTools.getDCMPositionFifthCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(rowStart, startIndex + 5, CoMTrajectoryPlannerTools.getDCMPositionSixthCoefficientTimeFunction());
        xObjectiveMatrixToPack.set(rowStart, 0, desiredDCMPosition.getX());
        yObjectiveMatrixToPack.set(rowStart, 0, desiredDCMPosition.getY());
        zObjectiveMatrixToPack.set(rowStart, 0, desiredDCMPosition.getZ());
    }

    public static void addDCMPositionObjective(double weight, int sequenceId, int rowStart, double time, double omega, FramePoint3DReadOnly desiredDCMPosition, DMatrix objectiveJacobianToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        desiredDCMPosition.checkReferenceFrameMatch(worldFrame);
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, startIndex, weight * CoMTrajectoryPlannerTools.getDCMPositionFirstCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, startIndex + 2, weight * CoMTrajectoryPlannerTools.getDCMPositionThirdCoefficientTimeFunction(omega, time));
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, startIndex + 3, weight * CoMTrajectoryPlannerTools.getDCMPositionFourthCoefficientTimeFunction(omega, time));
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, startIndex + 4, weight * CoMTrajectoryPlannerTools.getDCMPositionFifthCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, rowStart, startIndex + 5, weight * CoMTrajectoryPlannerTools.getDCMPositionSixthCoefficientTimeFunction());
        CoMTrajectoryPlannerTools.addEquals(xObjectiveMatrixToPack, rowStart, 0, weight * desiredDCMPosition.getX());
        CoMTrajectoryPlannerTools.addEquals(yObjectiveMatrixToPack, rowStart, 0, weight * desiredDCMPosition.getY());
        CoMTrajectoryPlannerTools.addEquals(zObjectiveMatrixToPack, rowStart, 0, weight * desiredDCMPosition.getZ());
    }

    public static void addVRPPositionConstraint(int sequenceId, int constraintNumber, int vrpWaypointPositionIndex, double time, double omega, FramePoint3DReadOnly desiredVRPPosition, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack, DMatrix vrpWaypointJacobianToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        desiredVRPPosition.checkReferenceFrameMatch(worldFrame);
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintNumber, startIndex + 2, CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, time));
            constraintMatrixToPack.set(constraintNumber, startIndex + 4, CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(time));
        }
        constraintMatrixToPack.set(constraintNumber, startIndex + 3, CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(constraintNumber, startIndex + 5, CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction());
        vrpWaypointJacobianToPack.set(constraintNumber, vrpWaypointPositionIndex, 1.0);
        xObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, desiredVRPPosition.getX());
        yObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, desiredVRPPosition.getY());
        zObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, desiredVRPPosition.getZ());
    }

    public static void addVRPPositionObjective(double weight, int sequenceId, int constraintNumber, int vrpWaypointPositionIndex, double time, double omega, FramePoint3DReadOnly desiredVRPPosition, DMatrix objectiveJacobianToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack, DMatrix vrpWaypointJacobianToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        desiredVRPPosition.checkReferenceFrameMatch(worldFrame);
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintNumber, startIndex + 2, weight * CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, time));
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintNumber, startIndex + 4, weight * CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(time));
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintNumber, startIndex + 3, weight * CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintNumber, startIndex + 5, weight * CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction());
        vrpWaypointJacobianToPack.set(constraintNumber, vrpWaypointPositionIndex, 1.0);
        CoMTrajectoryPlannerTools.addEquals(xObjectiveMatrixToPack, vrpWaypointPositionIndex, 0, weight * desiredVRPPosition.getX());
        CoMTrajectoryPlannerTools.addEquals(yObjectiveMatrixToPack, vrpWaypointPositionIndex, 0, weight * desiredVRPPosition.getY());
        CoMTrajectoryPlannerTools.addEquals(zObjectiveMatrixToPack, vrpWaypointPositionIndex, 0, weight * desiredVRPPosition.getZ());
    }

    public static void addMinimizationObjective(double weight, int sequenceId, double time, double omega, CoefficientProvider coefficientProvider, CoefficientSelectedProvider selectedProvider, DMatrix hessianToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        for (int row = 0; row < 6; ++row) {
            boolean includeRow = selectedProvider.include(row, time);
            if (!includeRow) continue;
            double rowValue = coefficientProvider.coefficient(row, omega, time);
            CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + row, weight * rowValue * rowValue);
            for (int col = row + 1; col < 6; ++col) {
                boolean includeCol = selectedProvider.include(col, time);
                if (!includeCol) continue;
                double colValue = coefficientProvider.coefficient(col, omega, time);
                double value = weight * rowValue * colValue;
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + col, value);
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + col, startIndex + row, value);
            }
        }
    }

    public static void addValueObjective(double weight, int sequenceId, double omega, double time, FrameTuple3DReadOnly valueProvider, CoefficientProvider coefficientProvider, CoefficientSelectedProvider selectedProvider, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        double weight2 = -2.0 * weight;
        boolean addX = false;
        boolean addY = false;
        boolean addZ = false;
        if (valueProvider != null) {
            valueProvider.checkReferenceFrameMatch(worldFrame);
            addX = Double.isFinite(valueProvider.getX()) && !MathTools.epsilonEquals((double)valueProvider.getX(), (double)0.0, (double)1.0E-4);
            addY = Double.isFinite(valueProvider.getY()) && !MathTools.epsilonEquals((double)valueProvider.getY(), (double)0.0, (double)1.0E-4);
            addZ = Double.isFinite(valueProvider.getZ()) && !MathTools.epsilonEquals((double)valueProvider.getZ(), (double)0.0, (double)1.0E-4);
        }
        for (int row = 0; row < 6; ++row) {
            boolean includeRow = selectedProvider.include(row, time);
            if (!includeRow) continue;
            double rowValue = coefficientProvider.coefficient(row, omega, time);
            CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + row, weight * rowValue * rowValue);
            if (addX) {
                CoMTrajectoryPlannerTools.addEquals(xGradientToPack, startIndex + row, 0, weight2 * rowValue * valueProvider.getX());
            }
            if (addY) {
                CoMTrajectoryPlannerTools.addEquals(yGradientToPack, startIndex + row, 0, weight2 * rowValue * valueProvider.getY());
            }
            if (addZ) {
                CoMTrajectoryPlannerTools.addEquals(zGradientToPack, startIndex + row, 0, weight2 * rowValue * valueProvider.getZ());
            }
            for (int col = row + 1; col < 6; ++col) {
                boolean includeCol = selectedProvider.include(col, time);
                if (!includeCol) continue;
                double colValue = coefficientProvider.coefficient(col, omega, time);
                double value = weight * rowValue * colValue;
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + col, value);
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + col, startIndex + row, value);
            }
        }
    }

    public static void addValueObjective(double weight, int sequenceId, double omega, double time, double valueObjective, CoefficientProvider coefficientProvider, CoefficientSelectedProvider selectedProvider, DMatrix hessianToPack, DMatrix gradientToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        double weight2 = -2.0 * weight;
        for (int row = 0; row < 6; ++row) {
            boolean includeRow = selectedProvider.include(row, time);
            if (!includeRow) continue;
            double rowValue = coefficientProvider.coefficient(row, omega, time);
            CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + row, weight * rowValue * rowValue);
            CoMTrajectoryPlannerTools.addEquals(gradientToPack, startIndex + row, 0, weight2 * rowValue * valueObjective);
            for (int col = row + 1; col < 6; ++col) {
                boolean includeCol = selectedProvider.include(col, time);
                if (!includeCol) continue;
                double colValue = coefficientProvider.coefficient(col, omega, time);
                double value = weight * rowValue * colValue;
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + row, startIndex + col, value);
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, startIndex + col, startIndex + row, value);
            }
        }
    }

    public static void addContinuityObjective(double weight, int sequenceId1, int sequenceId2, double omega, double time, CoefficientProvider coefficientProvider, CoefficientSelectedProvider selectedProvider, DMatrix hessianToPack) {
        int startIndex1 = 6 * sequenceId1;
        int startIndex2 = 6 * sequenceId2;
        time = Math.min(time, 10.0);
        int maxIndex = 12;
        for (int row = 0; row < maxIndex; ++row) {
            boolean includeRow;
            double rowTime = time;
            int rowInternal = row;
            int rowStart = startIndex1;
            double rowMultiplier = 1.0;
            if (row > 5) {
                rowTime = 0.0;
                rowInternal -= 6;
                rowStart = startIndex2;
                rowMultiplier = -1.0;
            }
            if (!(includeRow = selectedProvider.include(rowInternal, rowTime))) continue;
            double rowValue = coefficientProvider.coefficient(rowInternal, omega, rowTime);
            CoMTrajectoryPlannerTools.addEquals(hessianToPack, rowStart + rowInternal, rowStart + rowInternal, weight * rowValue * rowValue);
            for (int col = row + 1; col < maxIndex; ++col) {
                boolean includeCol;
                double colTime = time;
                int colInternal = col;
                int colStart = startIndex1;
                double colMultiplier = 1.0;
                if (col > 5) {
                    colTime = 0.0;
                    colInternal -= 6;
                    colStart = startIndex2;
                    colMultiplier = -1.0;
                }
                if (!(includeCol = selectedProvider.include(colInternal, colTime))) continue;
                double colValue = coefficientProvider.coefficient(colInternal, omega, colTime);
                double value = weight * rowMultiplier * colMultiplier * rowValue * colValue;
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, rowStart + rowInternal, colStart + colInternal, value);
                CoMTrajectoryPlannerTools.addEquals(hessianToPack, colStart + colInternal, rowStart + rowInternal, value);
            }
        }
    }

    public static void addVRPVelocityConstraint(int sequenceId, int constraintRow, int vrpWaypointVelocityIndex, double omega, double time, FrameVector3DReadOnly desiredVRPVelocity, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack, DMatrix vrpWaypointJacobianToPack) {
        int startIndex = 6 * sequenceId;
        desiredVRPVelocity.checkReferenceFrameMatch(worldFrame);
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintRow, startIndex + 3, CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(time));
        }
        constraintMatrixToPack.set(constraintRow, startIndex + 2, CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(constraintRow, startIndex + 4, CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction());
        vrpWaypointJacobianToPack.set(constraintRow, vrpWaypointVelocityIndex, 1.0);
        xObjectiveMatrixToPack.set(vrpWaypointVelocityIndex, 0, desiredVRPVelocity.getX());
        yObjectiveMatrixToPack.set(vrpWaypointVelocityIndex, 0, desiredVRPVelocity.getY());
        zObjectiveMatrixToPack.set(vrpWaypointVelocityIndex, 0, desiredVRPVelocity.getZ());
    }

    public static void addVRPVelocityObjective(double weight, int sequenceId, int constraintRow, int vrpWaypointVelocityIndex, double omega, double time, FrameVector3DReadOnly desiredVRPVelocity, DMatrix objectiveJacobianToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack, DMatrix vrpWaypointJacobianToPack) {
        int startIndex = 6 * sequenceId;
        desiredVRPVelocity.checkReferenceFrameMatch(worldFrame);
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, startIndex + 3, weight * CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(time));
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, startIndex + 2, weight * CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, startIndex + 4, weight * CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction());
        vrpWaypointJacobianToPack.set(constraintRow, vrpWaypointVelocityIndex, 1.0);
        CoMTrajectoryPlannerTools.addEquals(xObjectiveMatrixToPack, vrpWaypointVelocityIndex, 0, weight * desiredVRPVelocity.getX());
        CoMTrajectoryPlannerTools.addEquals(yObjectiveMatrixToPack, vrpWaypointVelocityIndex, 0, weight * desiredVRPVelocity.getY());
        CoMTrajectoryPlannerTools.addEquals(zObjectiveMatrixToPack, vrpWaypointVelocityIndex, 0, weight * desiredVRPVelocity.getZ());
    }

    public static void addCoMPositionContinuityConstraint(int previousSequence, int nextSequence, int constraintRow, double omega, double previousDuration, DMatrix constraintMatrixToPack) {
        int previousStartIndex = 6 * previousSequence;
        int nextStartIndex = 6 * nextSequence;
        previousDuration = Math.min(previousDuration, 10.0);
        constraintMatrixToPack.set(constraintRow, previousStartIndex, CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, previousDuration));
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 1, CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, previousDuration));
        if (!MathTools.epsilonEquals((double)previousDuration, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 2, CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(previousDuration));
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 3, CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(previousDuration));
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 4, CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(previousDuration));
        }
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 5, CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction());
        constraintMatrixToPack.set(constraintRow, nextStartIndex, -CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, 0.0));
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 1, -CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, 0.0));
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 5, -CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction());
    }

    public static void addCoMPositionContinuityObjective(double weight, int previousSequence, int nextSequence, int constraintRow, double omega, double previousDuration, DMatrix objectiveJacobianToPack) {
        int previousStartIndex = 6 * previousSequence;
        int nextStartIndex = 6 * nextSequence;
        previousDuration = Math.min(previousDuration, 10.0);
        double c00 = CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, previousDuration);
        double c01 = CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, previousDuration);
        double c05 = CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction();
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex, weight * c00);
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex + 1, weight * c01);
        if (!MathTools.epsilonEquals((double)previousDuration, (double)0.0, (double)1.0E-5)) {
            double c02 = CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(previousDuration);
            double c03 = CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(previousDuration);
            double c04 = CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(previousDuration);
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex + 2, weight * c02);
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex + 3, weight * c03);
            CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex + 4, weight * c04);
        }
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, previousStartIndex + 5, weight * c05);
        double c10 = CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, 0.0);
        double c11 = CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, 0.0);
        double c15 = CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction();
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, nextStartIndex, -weight * c10);
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, nextStartIndex + 1, -weight * c11);
        CoMTrajectoryPlannerTools.addEquals(objectiveJacobianToPack, constraintRow, nextStartIndex + 5, -weight * c15);
    }

    public static void addCoMPositionContinuityObjective(double weight, int previousSequence, int nextSequence, double omega, double previousDuration, DMatrix hessianToPack) {
        CoMTrajectoryPlannerTools.addContinuityObjective(weight, previousSequence, nextSequence, omega, previousDuration, comPositionCoefficientProvider, comPositionCoefficientSelectedProvider, hessianToPack);
    }

    public static void addCoMVelocityContinuityObjective(double weight, int previousSequence, int nextSequence, double omega, double previousDuration, DMatrix hessianToPack) {
        CoMTrajectoryPlannerTools.addContinuityObjective(weight, previousSequence, nextSequence, omega, previousDuration, comVelocityCoefficientProvider, comVelocityCoefficientSelectedProvider, hessianToPack);
    }

    public static void addCoMVelocityContinuityConstraint(int previousSequence, int nextSequence, int constraintRow, double omega, double previousDuration, DMatrix constraintMatrixToPack) {
        int previousStartIndex = 6 * previousSequence;
        int nextStartIndex = 6 * nextSequence;
        previousDuration = Math.min(previousDuration, 10.0);
        constraintMatrixToPack.set(constraintRow, previousStartIndex, CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, previousDuration));
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 1, CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, previousDuration));
        if (!MathTools.epsilonEquals((double)previousDuration, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 2, CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(previousDuration));
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 3, CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(previousDuration));
        }
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 4, CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
        constraintMatrixToPack.set(constraintRow, nextStartIndex, -CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, 0.0));
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 1, -CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, 0.0));
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 4, -CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
    }

    public static void addCoMVelocityContinuityObjective(double weight, int previousSequence, int nextSequence, int row, double omega, double previousDuration, DMatrix coefficientJacobianToPack) {
        int previousStartIndex = 6 * previousSequence;
        int nextStartIndex = 6 * nextSequence;
        previousDuration = Math.min(previousDuration, 10.0);
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, previousStartIndex, weight * CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, previousDuration));
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, previousStartIndex + 1, weight * CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, previousDuration));
        if (!MathTools.epsilonEquals((double)previousDuration, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, previousStartIndex + 2, weight * CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(previousDuration));
            CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, previousStartIndex + 3, weight * CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(previousDuration));
        }
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, previousStartIndex + 4, weight * CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, nextStartIndex, -weight * CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, 0.0));
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, nextStartIndex + 1, -weight * CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, 0.0));
        CoMTrajectoryPlannerTools.addEquals(coefficientJacobianToPack, row, nextStartIndex + 4, -weight * CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction());
    }

    public static void addVRPPositionContinuityConstraint(int previousSequence, int nextSequence, int constraintRow, double omega, double previousDuration, DMatrix constraintMatrixToPack) {
        int previousStartIndex = 6 * previousSequence;
        int nextStartIndex = 6 * nextSequence;
        if (!MathTools.epsilonEquals((double)(previousDuration = Math.min(previousDuration, 10.0)), (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 2, CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, previousDuration));
            constraintMatrixToPack.set(constraintRow, previousStartIndex + 4, CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(previousDuration));
        }
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 3, CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, previousDuration));
        constraintMatrixToPack.set(constraintRow, previousStartIndex + 5, CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction());
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 3, -CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, 0.0));
        constraintMatrixToPack.set(constraintRow, nextStartIndex + 5, -CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction());
    }

    public static void addEquivalentVRPVelocityConstraint(int segmentId1, int segmentId2, int constraintNumber, double timeOfConstraint1, double timeOfConstraint2, double omega, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        int startIndex1 = 6 * segmentId1;
        int startIndex2 = 6 * segmentId2;
        timeOfConstraint1 = Math.min(timeOfConstraint1, 10.0);
        timeOfConstraint2 = Math.min(timeOfConstraint2, 10.0);
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex1 + 2, CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, timeOfConstraint1));
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex2 + 2, -CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, timeOfConstraint2));
        if (!MathTools.epsilonEquals((double)timeOfConstraint1, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex1 + 3, CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(timeOfConstraint1));
        }
        if (!MathTools.epsilonEquals((double)timeOfConstraint2, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex2 + 3, -CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(timeOfConstraint2));
        }
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex1 + 4, CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction());
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintNumber, startIndex2 + 4, -CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction());
        xObjectiveMatrixToPack.set(constraintNumber, 0, 0.0);
        yObjectiveMatrixToPack.set(constraintNumber, 0, 0.0);
        zObjectiveMatrixToPack.set(constraintNumber, 0, 0.0);
    }

    public static void addImplicitVRPVelocityConstraint(int sequenceId, int constraintNumber, int vrpWaypointPositionIndex, double timeInSegment, double timeOfRelativePosition, double omega, FramePoint3DReadOnly relativeDesiredVRPPosition, DMatrix constraintMatrixToPack, DMatrix xObjectiveMatrixToPack, DMatrix yObjectiveMatrixToPack, DMatrix zObjectiveMatrixToPack, DMatrix vrpWaypointJacobianToPack) {
        boolean durationIsNonZero;
        int startIndex = 6 * sequenceId;
        timeInSegment = Math.min(timeInSegment, 10.0);
        relativeDesiredVRPPosition.checkReferenceFrameMatch(worldFrame);
        double duration = Math.min(1.0E10, timeInSegment - timeOfRelativePosition);
        boolean timeInSegmentIsNonZero = !MathTools.epsilonEquals((double)timeInSegment, (double)0.0, (double)1.0E-5);
        boolean bl = durationIsNonZero = !MathTools.epsilonEquals((double)duration, (double)0.0, (double)1.0E-5);
        if (timeInSegmentIsNonZero || durationIsNonZero) {
            constraintMatrixToPack.set(constraintNumber, startIndex + 2, CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, timeInSegment) - duration * CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, timeOfRelativePosition));
            constraintMatrixToPack.set(constraintNumber, startIndex + 4, CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(timeInSegment) - duration * CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction());
        }
        constraintMatrixToPack.set(constraintNumber, startIndex + 3, CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, timeInSegment) - duration * CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(timeOfRelativePosition));
        constraintMatrixToPack.set(constraintNumber, startIndex + 5, CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction() - duration * CoMTrajectoryPlannerTools.getVRPVelocitySixthCoefficientTimeFunction());
        vrpWaypointJacobianToPack.set(constraintNumber, vrpWaypointPositionIndex, 1.0);
        xObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, relativeDesiredVRPPosition.getX());
        yObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, relativeDesiredVRPPosition.getY());
        zObjectiveMatrixToPack.set(vrpWaypointPositionIndex, 0, relativeDesiredVRPPosition.getZ());
    }

    public static void addEquals(DMatrix matrixToPack, int row, int col, double val) {
        if (col < 0 || col >= matrixToPack.getNumCols()) {
            throw new IllegalArgumentException("Specified col is out of bounds");
        }
        if (row < 0 || row >= matrixToPack.getNumRows()) {
            throw new IllegalArgumentException("Specified row is out of bounds");
        }
        matrixToPack.unsafe_set(row, col, val + matrixToPack.unsafe_get(row, col));
    }

    public static void constrainCoMAccelerationToGravity(int sequenceId, int constraintRow, double omega, double time, double gravityZ, DMatrix constraintMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        constraintMatrixToPack.set(constraintRow, startIndex, CoMTrajectoryPlannerTools.getCoMAccelerationFirstCoefficientTimeFunction(omega, time));
        constraintMatrixToPack.set(constraintRow, startIndex + 1, CoMTrajectoryPlannerTools.getCoMAccelerationSecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            constraintMatrixToPack.set(constraintRow, startIndex + 2, CoMTrajectoryPlannerTools.getCoMAccelerationThirdCoefficientTimeFunction(time));
        }
        constraintMatrixToPack.set(constraintRow, startIndex + 3, CoMTrajectoryPlannerTools.getCoMAccelerationFourthCoefficientTimeFunction());
        zObjectiveMatrixToPack.set(constraintRow, 0, -Math.abs(gravityZ));
    }

    public static void addCoMAccelerationIsGravityObjective(double weight, int sequenceId, int constraintRow, double omega, double time, double gravityZ, DMatrix constraintMatrixToPack, DMatrix zObjectiveMatrixToPack) {
        int startIndex = 6 * sequenceId;
        time = Math.min(time, 10.0);
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintRow, startIndex, weight * CoMTrajectoryPlannerTools.getCoMAccelerationFirstCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintRow, startIndex + 1, weight * CoMTrajectoryPlannerTools.getCoMAccelerationSecondCoefficientTimeFunction(omega, time));
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintRow, startIndex + 2, weight * CoMTrajectoryPlannerTools.getCoMAccelerationThirdCoefficientTimeFunction(time));
        }
        CoMTrajectoryPlannerTools.addEquals(constraintMatrixToPack, constraintRow, startIndex + 3, weight * CoMTrajectoryPlannerTools.getCoMAccelerationFourthCoefficientTimeFunction());
        CoMTrajectoryPlannerTools.addEquals(zObjectiveMatrixToPack, constraintRow, 0, weight * -Math.abs(gravityZ));
    }

    public static void addCoMAccelerationObjective(double weight, int sequenceId, double omega, double time, FrameVector3DReadOnly gravity, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, (FrameTuple3DReadOnly)gravity, comAccelerationCoefficientProvider, comAccelerationCoefficientSelectedProvider, hessianToPack, xGradientToPack, yGradientToPack, zGradientToPack);
    }

    public static void addCoMAccelerationIsGravityObjective(double weight, int sequenceId, double omega, double time, double gravityZ, DMatrix hessianToPack, DMatrix zGradientToPack) {
        CoMTrajectoryPlannerTools.addValueObjective(weight, sequenceId, omega, time, gravityZ, comAccelerationCoefficientProvider, comAccelerationCoefficientSelectedProvider, hessianToPack, zGradientToPack);
    }

    public static void constrainCoMJerkToZero(double time, double omega, int sequenceId, int rowStart, DMatrix matrixToPack) {
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        matrixToPack.set(rowStart, colStart, CoMTrajectoryPlannerTools.getCoMJerkFirstCoefficientTimeFunction(omega, time));
        matrixToPack.set(rowStart, colStart + 1, CoMTrajectoryPlannerTools.getCoMJerkSecondCoefficientTimeFunction(omega, time));
        matrixToPack.set(rowStart, colStart + 2, CoMTrajectoryPlannerTools.getCoMJerkThirdCoefficientTimeFunction());
    }

    public static void addZeroCoMJerkObjective(double weight, double time, double omega, int sequenceId, int rowStart, DMatrix matrixToPack) {
        time = Math.min(time, 10.0);
        int colStart = 6 * sequenceId;
        CoMTrajectoryPlannerTools.addEquals(matrixToPack, rowStart, colStart, weight * CoMTrajectoryPlannerTools.getCoMJerkFirstCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(matrixToPack, rowStart, colStart + 1, weight * CoMTrajectoryPlannerTools.getCoMJerkSecondCoefficientTimeFunction(omega, time));
        CoMTrajectoryPlannerTools.addEquals(matrixToPack, rowStart, colStart + 2, weight * CoMTrajectoryPlannerTools.getCoMJerkThirdCoefficientTimeFunction());
    }

    public static void addZeroCoMJerkObjective(double weight, double time, double omega, int sequenceId, DMatrix hessianToPack) {
        CoMTrajectoryPlannerTools.addCoMJerkObjective(weight, null, omega, time, sequenceId, hessianToPack, null, null, null);
    }

    public static void addMinimizeCoMAccelerationObjective(double weight, double startTime, double endTime, double omega, int sequenceId, DMatrix hessianToPack) {
        int start = 6 * sequenceId;
        double h00End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient00(omega, endTime);
        double h01End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient01(omega, endTime);
        double h02End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient02(omega, endTime);
        double h03End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient03(omega, endTime);
        double h11End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient11(omega, endTime);
        double h12End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient12(omega, endTime);
        double h13End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient13(omega, endTime);
        double h22End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient22(endTime);
        double h23End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient23(endTime);
        double h33End = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient33(endTime);
        double h00Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient00(omega, startTime);
        double h01Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient01(omega, startTime);
        double h02Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient02(omega, startTime);
        double h03Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient03(omega, startTime);
        double h11Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient11(omega, startTime);
        double h12Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient12(omega, startTime);
        double h13Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient13(omega, startTime);
        double h22Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient22(startTime);
        double h23Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient23(startTime);
        double h33Start = CoMTrajectoryPlannerTools.getIntegralCoMAccelerationCoefficient33(startTime);
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 0, weight * (h00End - h00Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 1, weight * (h01End - h01Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 2, weight * (h02End - h02Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 3, weight * (h03End - h03Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 0, weight * (h01End - h01Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 1, weight * (h11End - h11Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 2, weight * (h12End - h12Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 3, weight * (h13End - h13Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 0, weight * (h02End - h02Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 1, weight * (h12End - h12Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 2, weight * (h22End - h22Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 3, weight * (h23End - h23Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 3, start + 0, weight * (h03End - h03Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 3, start + 1, weight * (h13End - h13Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 3, start + 2, weight * (h23End - h23Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 3, start + 3, weight * (h33End - h33Start));
    }

    public static void addMinimizeCoMJerkObjective(double weight, double startTime, double endTime, double omega, int sequenceId, DMatrix hessianToPack) {
        int start = 6 * sequenceId;
        double h00End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient00(omega, endTime);
        double h01End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient01(omega, endTime);
        double h02End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient02(omega, endTime);
        double h11End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient11(omega, endTime);
        double h12End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient12(omega, endTime);
        double h22End = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient22(endTime);
        double h00Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient00(omega, startTime);
        double h01Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient01(omega, startTime);
        double h02Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient02(omega, startTime);
        double h11Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient11(omega, startTime);
        double h12Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient12(omega, startTime);
        double h22Start = CoMTrajectoryPlannerTools.getIntegralCoMJerkCoefficient22(startTime);
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 0, weight * (h00End - h00Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 1, weight * (h01End - h01Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 0, start + 2, weight * (h02End - h02Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 0, weight * (h01End - h01Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 1, weight * (h11End - h11Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 1, start + 2, weight * (h12End - h12Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 0, weight * (h02End - h02Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 1, weight * (h12End - h12Start));
        CoMTrajectoryPlannerTools.addEquals(hessianToPack, start + 2, start + 2, weight * (h22End - h22Start));
    }

    public static double getCoMCoefficientTimeFunction(int order, int coefficient, double omega, double time) {
        switch (order) {
            case 0: {
                return CoMTrajectoryPlannerTools.getCoMPositionCoefficientTimeFunction(coefficient, omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getCoMVelocityCoefficientTimeFunction(coefficient, omega, time);
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationCoefficientTimeFunction(coefficient, omega, time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getCoMJerkCoefficientTimeFunction(coefficient, omega, time);
            }
        }
        throw new IllegalArgumentException("The order " + order + " must be less than 3.");
    }

    public static boolean getCoMPositionCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 1: 
            case 5: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: {
                return !MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5);
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getCoMVelocityCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
            case 2: 
            case 3: {
                return !MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5);
            }
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getCoMAccelerationCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
            case 2: {
                return !MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5);
            }
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getCoMJerkCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
            case 2: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getDCMPositionCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 4: 
            case 5: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: 
            case 3: {
                return !MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5);
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getDCMVelocityCoefficientNonZero(int coefficient, double time) {
        switch (coefficient) {
            case 0: 
            case 3: 
            case 4: {
                return true;
            }
            case 1: 
            case 5: {
                return false;
            }
            case 2: {
                return !MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5);
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static boolean getVRPPositionCoefficientNonZero(int coefficient, double time) {
        return true;
    }

    public static boolean getVRPVelocityCoefficientNonZero(int coefficient, double time) {
        return true;
    }

    public static double getCoMPositionCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, time);
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(time);
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(time);
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getCoMVelocityCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, time);
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(time);
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction();
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getCoMVelocitySixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getCoMAccelerationCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationFirstCoefficientTimeFunction(omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationSecondCoefficientTimeFunction(omega, time);
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationThirdCoefficientTimeFunction(time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationFourthCoefficientTimeFunction();
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationFifthCoefficientTimeFunction();
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getCoMAccelerationSixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getCoMJerkCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getCoMJerkFirstCoefficientTimeFunction(omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getCoMJerkSecondCoefficientTimeFunction(omega, time);
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getCoMJerkThirdCoefficientTimeFunction();
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getCoMJerkFourthCoefficientTimeFunction();
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getCoMJerkFifthCoefficientTimeFunction();
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getCoMJerkSixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getDCMPositionCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getDCMPositionFirstCoefficientTimeFunction(omega, time);
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getDCMPositionSecondCoefficientTimeFunction();
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getDCMPositionThirdCoefficientTimeFunction(omega, time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getDCMPositionFourthCoefficientTimeFunction(omega, time);
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getDCMPositionFifthCoefficientTimeFunction(omega, time);
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getDCMPositionSixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getVRPPositionCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getVRPPositionFirstCoefficientTimeFunction();
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getVRPPositionSecondCoefficientTimeFunction();
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, time);
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(time);
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getVRPVelocityCoefficientTimeFunction(int coefficient, double omega, double time) {
        switch (coefficient) {
            case 0: {
                return CoMTrajectoryPlannerTools.getVRPVelocityFirstCoefficientTimeFunction();
            }
            case 1: {
                return CoMTrajectoryPlannerTools.getVRPVelocitySecondCoefficientTimeFunction();
            }
            case 2: {
                return CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, time);
            }
            case 3: {
                return CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(time);
            }
            case 4: {
                return CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction();
            }
            case 5: {
                return CoMTrajectoryPlannerTools.getVRPVelocitySixthCoefficientTimeFunction();
            }
        }
        throw new IllegalArgumentException("Coefficient number " + coefficient + " must be less than 6.");
    }

    public static double getCoMPositionFirstCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getCoMPositionSecondCoefficientTimeFunction(double omega, double time) {
        return Math.exp(-omega * time);
    }

    public static double getCoMPositionThirdCoefficientTimeFunction(double time) {
        return Math.min(1.0E10, time * time * time);
    }

    public static double getCoMPositionFourthCoefficientTimeFunction(double time) {
        return Math.min(1.0E10, time * time);
    }

    public static double getCoMPositionFifthCoefficientTimeFunction(double time) {
        return Math.min(1.0E10, time);
    }

    public static double getCoMPositionSixthCoefficientTimeFunction() {
        return 1.0;
    }

    public static double getCoMVelocityFirstCoefficientTimeFunction(double omega, double time) {
        return omega * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getCoMVelocitySecondCoefficientTimeFunction(double omega, double time) {
        return -omega * Math.exp(-omega * time);
    }

    public static double getCoMVelocityThirdCoefficientTimeFunction(double time) {
        return 3.0 * Math.min(1.0E10, time * time);
    }

    public static double getCoMVelocityFourthCoefficientTimeFunction(double time) {
        return 2.0 * Math.min(1.0E10, time);
    }

    public static double getCoMVelocityFifthCoefficientTimeFunction() {
        return 1.0;
    }

    public static double getCoMVelocitySixthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getCoMAccelerationFirstCoefficientTimeFunction(double omega, double time) {
        return omega * omega * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getCoMAccelerationSecondCoefficientTimeFunction(double omega, double time) {
        return omega * omega * Math.exp(-omega * time);
    }

    public static double getCoMAccelerationThirdCoefficientTimeFunction(double time) {
        return 6.0 * Math.min(1.0E10, time);
    }

    public static double getCoMAccelerationFourthCoefficientTimeFunction() {
        return 2.0;
    }

    public static double getCoMAccelerationFifthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getCoMAccelerationSixthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getIntegralCoMAccelerationCoefficient00(double omega, double time) {
        return 0.5 * omega * omega * omega * Math.min(1.0E10, Math.exp(2.0 * omega * time));
    }

    public static double getIntegralCoMAccelerationCoefficient01(double omega, double time) {
        return omega * omega * omega * omega * Math.min(1.0E10, time);
    }

    public static double getIntegralCoMAccelerationCoefficient02(double omega, double time) {
        return 6.0 * Math.min(1.0E10, Math.exp(omega * time)) * (omega * Math.min(1.0E10, time) - 1.0);
    }

    public static double getIntegralCoMAccelerationCoefficient03(double omega, double time) {
        return 2.0 * omega * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getIntegralCoMAccelerationCoefficient11(double omega, double time) {
        return -0.5 * omega * omega * omega * Math.min(1.0E10, Math.exp(-2.0 * omega * time));
    }

    public static double getIntegralCoMAccelerationCoefficient12(double omega, double time) {
        return -6.0 * Math.min(1.0E10, Math.exp(-omega * time)) * (omega * Math.min(1.0E10, time) + 1.0);
    }

    public static double getIntegralCoMAccelerationCoefficient13(double omega, double time) {
        return -2.0 * omega * Math.min(1.0E10, Math.exp(-omega * time));
    }

    public static double getIntegralCoMAccelerationCoefficient22(double time) {
        return 12.0 * Math.min(1.0E10, time * time * time);
    }

    public static double getIntegralCoMAccelerationCoefficient23(double time) {
        return 6.0 * Math.min(1.0E10, time * time);
    }

    public static double getIntegralCoMAccelerationCoefficient33(double time) {
        return 4.0 * Math.min(1.0E10, time);
    }

    public static double getCoMJerkFirstCoefficientTimeFunction(double omega, double time) {
        return omega * omega * omega * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getCoMJerkSecondCoefficientTimeFunction(double omega, double time) {
        return -omega * omega * omega * Math.exp(-omega * time);
    }

    public static double getCoMJerkThirdCoefficientTimeFunction() {
        return 6.0;
    }

    public static double getCoMJerkFourthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getCoMJerkFifthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getCoMJerkSixthCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getIntegralCoMJerkCoefficient00(double omega, double time) {
        double omega2 = omega * omega;
        double omega4 = omega2 * omega2;
        return 0.5 * omega2 * omega4 * Math.min(1.0E10, Math.exp(2.0 * omega * time));
    }

    public static double getIntegralCoMJerkCoefficient01(double omega, double time) {
        double omega3 = omega * omega * omega;
        return -omega3 * omega3 * Math.min(1.0E10, time);
    }

    public static double getIntegralCoMJerkCoefficient02(double omega, double time) {
        return 6.0 * omega * omega * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getIntegralCoMJerkCoefficient11(double omega, double time) {
        double omega2 = omega * omega;
        double omega4 = omega2 * omega2;
        return -0.5 * omega4 * omega2 * Math.min(1.0E10, Math.exp(-2.0 * omega * time));
    }

    public static double getIntegralCoMJerkCoefficient12(double omega, double time) {
        return -6.0 * omega * omega * Math.min(1.0E10, Math.exp(-omega * time));
    }

    public static double getIntegralCoMJerkCoefficient22(double time) {
        return 36.0 * Math.min(1.0E10, time);
    }

    public static double getDCMPositionFirstCoefficientTimeFunction(double omega, double time) {
        return 2.0 * Math.min(1.0E10, Math.exp(omega * time));
    }

    public static double getDCMPositionSecondCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getDCMPositionThirdCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, time * time * time) + 3.0 / omega * Math.min(1.0E10, time * time);
    }

    public static double getDCMPositionFourthCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, time * time) + 2.0 / omega * Math.min(1.0E10, time);
    }

    public static double getDCMPositionFifthCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, time) + 1.0 / omega;
    }

    public static double getDCMPositionSixthCoefficientTimeFunction() {
        return 1.0;
    }

    public static double getVRPPositionFirstCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getVRPPositionSecondCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getVRPPositionThirdCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, time * time * time) - 6.0 * Math.min(1.0E10, time) / (omega * omega);
    }

    public static double getVRPPositionFourthCoefficientTimeFunction(double omega, double time) {
        return Math.min(1.0E10, time * time) - 2.0 / (omega * omega);
    }

    public static double getVRPPositionFifthCoefficientTimeFunction(double time) {
        return Math.min(1.0E10, time);
    }

    public static double getVRPPositionSixthCoefficientTimeFunction() {
        return 1.0;
    }

    public static double getVRPVelocityFirstCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getVRPVelocitySecondCoefficientTimeFunction() {
        return 0.0;
    }

    public static double getVRPVelocityThirdCoefficientTimeFunction(double omega, double time) {
        return 3.0 * Math.min(1.0E10, time * time) - 6.0 / (omega * omega);
    }

    public static double getVRPVelocityFourthCoefficientTimeFunction(double time) {
        return 2.0 * Math.min(1.0E10, time);
    }

    public static double getVRPVelocityFifthCoefficientTimeFunction() {
        return 1.0;
    }

    public static double getVRPVelocitySixthCoefficientTimeFunction() {
        return 0.0;
    }

    public static void constructDesiredCoMPosition(FixedFramePoint3DBasics comPositionToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        comPositionToPack.checkReferenceFrameMatch(worldFrame);
        comPositionToPack.setToZero();
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionFirstCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionSecondCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionThirdCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionFourthCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionFifthCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
        comPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMPositionSixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)comPositionToPack);
    }

    public static void constructDesiredCoMVelocity(FixedFrameVector3DBasics comVelocityToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        comVelocityToPack.checkReferenceFrameMatch(worldFrame);
        comVelocityToPack.setToZero();
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocityFirstCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocitySecondCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocityThirdCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocityFourthCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocityFifthCoefficientTimeFunction(), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
        comVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMVelocitySixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)comVelocityToPack);
    }

    public static void constructDesiredCoMAcceleration(FixedFrameVector3DBasics comAccelerationToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        comAccelerationToPack.checkReferenceFrameMatch(worldFrame);
        comAccelerationToPack.setToZero();
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationFirstCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationSecondCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationThirdCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationFourthCoefficientTimeFunction(), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationFifthCoefficientTimeFunction(), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
        comAccelerationToPack.scaleAdd(CoMTrajectoryPlannerTools.getCoMAccelerationSixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)comAccelerationToPack);
    }

    public static void constructDesiredDCMPosition(FixedFramePoint3DBasics dcmPositionToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        dcmPositionToPack.checkReferenceFrameMatch(worldFrame);
        dcmPositionToPack.setToZero();
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionFirstCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionSecondCoefficientTimeFunction(), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionThirdCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionFourthCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionFifthCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
        dcmPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getDCMPositionSixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)dcmPositionToPack);
    }

    public static void constructDesiredVRPPosition(FixedFramePoint3DBasics vrpPositionToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        vrpPositionToPack.checkReferenceFrameMatch(worldFrame);
        vrpPositionToPack.setToZero();
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionFirstCoefficientTimeFunction(), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionSecondCoefficientTimeFunction(), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionThirdCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionFourthCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionFifthCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
        vrpPositionToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPPositionSixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)vrpPositionToPack);
    }

    public static void constructDesiredVRPVelocity(FixedFrameVector3DBasics vrpVelocityToPack, FramePoint3DReadOnly firstCoefficient, FramePoint3DReadOnly secondCoefficient, FramePoint3DReadOnly thirdCoefficient, FramePoint3DReadOnly fourthCoefficient, FramePoint3DReadOnly fifthCoefficient, FramePoint3DReadOnly sixthCoefficient, double timeInPhase, double omega) {
        vrpVelocityToPack.checkReferenceFrameMatch(worldFrame);
        vrpVelocityToPack.setToZero();
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocityFirstCoefficientTimeFunction(), (FrameTuple3DReadOnly)firstCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocitySecondCoefficientTimeFunction(), (FrameTuple3DReadOnly)secondCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocityThirdCoefficientTimeFunction(omega, timeInPhase), (FrameTuple3DReadOnly)thirdCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocityFourthCoefficientTimeFunction(timeInPhase), (FrameTuple3DReadOnly)fourthCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocityFifthCoefficientTimeFunction(), (FrameTuple3DReadOnly)fifthCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
        vrpVelocityToPack.scaleAdd(CoMTrajectoryPlannerTools.getVRPVelocitySixthCoefficientTimeFunction(), (FrameTuple3DReadOnly)sixthCoefficient, (FrameTuple3DReadOnly)vrpVelocityToPack);
    }

    private static interface CoefficientProvider {
        public double coefficient(int var1, double var2, double var4);
    }

    private static interface CoefficientSelectedProvider {
        public boolean include(int var1, double var2);
    }
}

