/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.FootTrajectoryPredictor;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.trajectories.FixedFramePolynomialEstimator3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.PositionTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class ThreePotatoAngularMomentumCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean debug = false;
    private static final boolean visualize = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble potatoMass = new YoDouble("PotatoMass", this.registry);
    private final DoubleProvider potatoMassFraction;
    private final double totalMass;
    private final BooleanProvider useHeightScaledAngularMomentum = new BooleanParameter("useHeightScaledAngularMomentum", this.registry, true);
    private final DoubleProvider idealAngularMomentumSampleDt = new DoubleParameter("idealAngularMomentumSampleDt", this.registry, 0.05);
    private final IntegerProvider maxAngularMomentumSamplesPerSegment = new IntegerParameter("maxAngularMomentumSamplesPerSegment", this.registry, 8);
    private final IntegerProvider minAngularMomentumSamplesPerSegment = new IntegerParameter("minAngularMomentumSamplesPerSegment", this.registry, 5);
    private final YoFrameVector3D desiredAngularMomentum = new YoFrameVector3D("desiredAngularMomentum", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D desiredAngularMomentumRate = new YoFrameVector3D("desiredAngularMomentumRate", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D desiredScaledAngularMomentum = new YoFrameVector3D("desiredScaledAngularMomentum", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D desiredScaledAngularMomentumRate = new YoFrameVector3D("desiredScaledAngularMomentumRate", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D predictedAngularMomentum = new YoFrameVector3D("predictedAngularMomentum", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D predictedAngularMomentumRate = new YoFrameVector3D("predictedAngularMomentumRate", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D actualModelAngularMomentum = new YoFrameVector3D("actualModelAngularMomentum", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D predictedCoMPosition = new YoFramePoint3D("predictedCoMPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D predictedCoMVelocity = new YoFrameVector3D("predictedCoMVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D predictedLeftFootPosition = new YoFramePoint3D("predictedLeftFootPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D predictedLeftFootVelocity = new YoFrameVector3D("predictedLeftFootVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D predictedRightFootPosition = new YoFramePoint3D("predictedRightFootPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D predictedRightFootVelocity = new YoFrameVector3D("predictedRightFootVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoDouble comTrajectoryCurrentTime = new YoDouble("firstPotatoCurrentTrajectoryTime", this.registry);
    private final YoInteger comTrajectoryCurrentSegment = new YoInteger("firstPotatoCurrentSegmentIndex", this.registry);
    private MultipleSegmentPositionTrajectoryGenerator<?> predictedCoMTrajectory;
    private final FrameVector3D totalAngularMomentum = new FrameVector3D();
    private final FrameVector3D totalTorque = new FrameVector3D();
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final FrameVector3D torque = new FrameVector3D();
    private final FrameVector3D relativePotatoPosition = new FrameVector3D();
    private final FrameVector3D relativePotatoVelocity = new FrameVector3D();
    private final FrameVector3D relativePotatoAcceleration = new FrameVector3D();
    private final FixedFramePolynomialEstimator3D angularMomentumEstimator = new FixedFramePolynomialEstimator3D(worldFrame);
    private final FixedFramePolynomialEstimator3D scaledAngularMomentumEstimator = new FixedFramePolynomialEstimator3D(worldFrame);
    private final MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> angularMomentumTrajectory;
    private final MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> heightScaledAngularMomentumTrajectory;
    private final FootTrajectoryPredictor footTrajectoryPredictor = new FootTrajectoryPredictor(this.registry);
    private final BagOfBalls comTrajectoryVis;
    private final BagOfBalls secondPotatoVis;
    private final BagOfBalls thirdPotatoVis;
    private final CenterOfMassJacobian centerOfMassJacobian;
    private final SideDependentList<MovingReferenceFrame> soleFrames;
    private final ExecutionTimer angularMomentumEstimationTimer = new ExecutionTimer("angularMomentumEstimation", this.registry);
    private final ExecutionTimer angularMomentumPredictionTimer = new ExecutionTimer("angularMomentumPrediction", this.registry);
    private final double gravityZ;
    private final FramePoint3D potatoPosition = new FramePoint3D();
    private final FrameVector3D potatoVelocity = new FrameVector3D();

    public ThreePotatoAngularMomentumCalculator(double totalMass, DoubleProvider potatoMassFraction, double gravityZ, CenterOfMassJacobian centerOfMassJacobian, SideDependentList<MovingReferenceFrame> soleFrames, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        this.gravityZ = Math.abs(gravityZ);
        this.centerOfMassJacobian = centerOfMassJacobian;
        this.soleFrames = soleFrames;
        this.totalMass = totalMass;
        this.potatoMassFraction = potatoMassFraction;
        this.angularMomentumTrajectory = new MultipleSegmentPositionTrajectoryGenerator("angularMomentum", 50, worldFrame, () -> new FixedFramePolynomialEstimator3D(worldFrame), this.registry);
        this.heightScaledAngularMomentumTrajectory = new MultipleSegmentPositionTrajectoryGenerator("heightScaledAngularMomentum", 50, worldFrame, () -> new FixedFramePolynomialEstimator3D(worldFrame), this.registry);
        this.comTrajectoryVis = null;
        this.secondPotatoVis = null;
        this.thirdPotatoVis = null;
        parentRegistry.addChild(this.registry);
    }

    public void setSwingTrajectory(RobotSide swingSide, MultipleWaypointsPoseTrajectoryGenerator swingTrajectory) {
        this.footTrajectoryPredictor.setSwingTrajectory(swingSide, swingTrajectory);
    }

    public void clearSwingTrajectory() {
        this.footTrajectoryPredictor.clearSwingTrajectory();
    }

    public void predictFootTrajectories(CoPTrajectoryGeneratorState state) {
        this.footTrajectoryPredictor.compute(state);
    }

    public void predictFootTrajectories(JumpingCoPTrajectoryGeneratorState state) {
        this.footTrajectoryPredictor.compute(state);
    }

    public void reset() {
        this.predictedCoMTrajectory = null;
        this.angularMomentumEstimator.reset();
        this.angularMomentumEstimator.reshape(1);
        this.totalAngularMomentum.setToZero();
        this.angularMomentumEstimator.addObjectivePosition(0.0, (FrameTuple3DReadOnly)this.totalAngularMomentum);
        this.angularMomentumEstimator.initialize();
        this.angularMomentumTrajectory.clear();
        this.heightScaledAngularMomentumTrajectory.clear();
        this.angularMomentumTrajectory.appendSegment((FixedFramePositionTrajectoryGenerator)this.angularMomentumEstimator);
        this.heightScaledAngularMomentumTrajectory.appendSegment((FixedFramePositionTrajectoryGenerator)this.angularMomentumEstimator);
        this.angularMomentumTrajectory.initialize();
        this.heightScaledAngularMomentumTrajectory.initialize();
    }

    public void computeAngularMomentum(double time) {
        this.angularMomentumPredictionTimer.startMeasurement();
        this.angularMomentumTrajectory.compute(time);
        this.heightScaledAngularMomentumTrajectory.compute(time);
        this.desiredAngularMomentum.set((FrameTuple3DReadOnly)this.angularMomentumTrajectory.getPosition());
        this.desiredAngularMomentumRate.set((FrameTuple3DReadOnly)this.angularMomentumTrajectory.getVelocity());
        this.desiredScaledAngularMomentum.set((FrameTuple3DReadOnly)this.heightScaledAngularMomentumTrajectory.getPosition());
        this.desiredScaledAngularMomentumRate.set((FrameTuple3DReadOnly)this.heightScaledAngularMomentumTrajectory.getVelocity());
        this.totalAngularMomentum.setToZero();
        if (this.centerOfMassJacobian != null && this.soleFrames != null) {
            for (RobotSide robotSide : RobotSide.values) {
                FramePoint3DReadOnly comPosition = this.centerOfMassJacobian.getCenterOfMass();
                FrameVector3DReadOnly comVelocity = this.centerOfMassJacobian.getCenterOfMassVelocity();
                this.potatoPosition.setToZero((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
                this.potatoPosition.changeFrame(ReferenceFrame.getWorldFrame());
                this.potatoVelocity.setIncludingFrame((FrameTuple3DReadOnly)((MovingReferenceFrame)this.soleFrames.get((Enum)robotSide)).getTwistOfFrame().getLinearPart());
                this.potatoVelocity.changeFrame(ReferenceFrame.getWorldFrame());
                this.computeAngularMomentumAtInstant((Point3DReadOnly)comPosition, (Vector3DReadOnly)comVelocity, (Point3DReadOnly)this.potatoPosition, (Vector3DReadOnly)this.potatoVelocity, this.potatoMass.getDoubleValue(), (Vector3DBasics)this.angularMomentum);
                this.totalAngularMomentum.add((FrameTuple3DReadOnly)this.angularMomentum);
            }
            this.actualModelAngularMomentum.set((FrameTuple3DReadOnly)this.totalAngularMomentum);
        }
        MultipleWaypointsPositionTrajectoryGenerator predictedLeftFootTrajectory = this.footTrajectoryPredictor.getPredictedLeftFootTrajectories();
        MultipleWaypointsPositionTrajectoryGenerator predictedRightFootTrajectory = this.footTrajectoryPredictor.getPredictedRightFootTrajectories();
        this.totalAngularMomentum.setToZero();
        this.totalTorque.setToZero();
        if (this.predictedCoMTrajectory == null) {
            this.angularMomentumPredictionTimer.stopMeasurement();
            return;
        }
        if (time > this.predictedCoMTrajectory.getEndTime() || time > predictedLeftFootTrajectory.getLastWaypointTime() || time > predictedRightFootTrajectory.getLastWaypointTime()) {
            this.angularMomentumPredictionTimer.stopMeasurement();
            return;
        }
        this.predictedCoMTrajectory.compute(time);
        predictedLeftFootTrajectory.compute(time);
        predictedRightFootTrajectory.compute(time);
        this.computeAngularMomentumAtInstant((PositionTrajectoryGenerator)this.predictedCoMTrajectory, (PositionTrajectoryGenerator)predictedLeftFootTrajectory, this.potatoMass.getDoubleValue(), (Vector3DBasics)this.angularMomentum, (Vector3DBasics)this.torque);
        this.totalAngularMomentum.add((FrameTuple3DReadOnly)this.angularMomentum);
        this.totalTorque.add((FrameTuple3DReadOnly)this.torque);
        this.computeAngularMomentumAtInstant((PositionTrajectoryGenerator)this.predictedCoMTrajectory, (PositionTrajectoryGenerator)predictedRightFootTrajectory, this.potatoMass.getDoubleValue(), (Vector3DBasics)this.angularMomentum, (Vector3DBasics)this.torque);
        this.totalAngularMomentum.add((FrameTuple3DReadOnly)this.angularMomentum);
        this.totalTorque.add((FrameTuple3DReadOnly)this.torque);
        this.predictedCoMPosition.set((FrameTuple3DReadOnly)this.predictedCoMTrajectory.getPosition());
        this.predictedCoMVelocity.set((FrameTuple3DReadOnly)this.predictedCoMTrajectory.getVelocity());
        this.predictedLeftFootPosition.set((FrameTuple3DReadOnly)predictedLeftFootTrajectory.getPosition());
        this.predictedLeftFootVelocity.set((FrameTuple3DReadOnly)predictedLeftFootTrajectory.getVelocity());
        this.predictedRightFootPosition.set((FrameTuple3DReadOnly)predictedRightFootTrajectory.getPosition());
        this.predictedRightFootVelocity.set((FrameTuple3DReadOnly)predictedRightFootTrajectory.getVelocity());
        this.comTrajectoryCurrentSegment.set(this.predictedCoMTrajectory.getCurrentSegmentIndex());
        this.comTrajectoryCurrentTime.set(this.predictedCoMTrajectory.getCurrentSegmentTrajectoryTime());
        this.predictedAngularMomentum.set((FrameTuple3DReadOnly)this.totalAngularMomentum);
        this.predictedAngularMomentumRate.set((FrameTuple3DReadOnly)this.totalTorque);
        this.angularMomentumPredictionTimer.stopMeasurement();
    }

    public void computeAngularMomentumTrajectories(List<? extends TimeIntervalProvider> timeIntervals, MultipleSegmentPositionTrajectoryGenerator<?> comTrajectories) {
        this.angularMomentumEstimationTimer.startMeasurement();
        this.potatoMass.set(this.potatoMassFraction.getValue() * this.totalMass);
        this.predictedCoMTrajectory = comTrajectories;
        MultipleWaypointsPositionTrajectoryGenerator predictedLeftFootTrajectory = this.footTrajectoryPredictor.getPredictedLeftFootTrajectories();
        MultipleWaypointsPositionTrajectoryGenerator predictedRightFootTrajectory = this.footTrajectoryPredictor.getPredictedRightFootTrajectories();
        this.angularMomentumTrajectory.clear();
        this.heightScaledAngularMomentumTrajectory.clear();
        for (int i = 0; i < timeIntervals.size(); ++i) {
            double time;
            TimeIntervalBasics timeInterval = timeIntervals.get(i).getTimeInterval();
            this.angularMomentumEstimator.reset();
            this.angularMomentumEstimator.reshape(5);
            this.scaledAngularMomentumEstimator.reset();
            this.scaledAngularMomentumEstimator.reshape(5);
            double duration = Math.min(timeInterval.getDuration(), 10.0);
            this.angularMomentumEstimator.getTimeInterval().setInterval(timeInterval.getStartTime(), timeInterval.getStartTime() + duration);
            this.scaledAngularMomentumEstimator.getTimeInterval().setInterval(timeInterval.getStartTime(), timeInterval.getStartTime() + duration);
            double minDt = duration / (double)this.maxAngularMomentumSamplesPerSegment.getValue();
            double maxDt = duration / (double)this.minAngularMomentumSamplesPerSegment.getValue();
            double segmentDt = duration / this.idealAngularMomentumSampleDt.getValue();
            segmentDt = MathTools.clamp((double)segmentDt, (double)minDt, (double)maxDt);
            for (double timeInInterval = 0.0; !(!(timeInInterval <= duration) || (time = timeInInterval + timeInterval.getStartTime()) > predictedLeftFootTrajectory.getLastWaypointTime() && time > predictedRightFootTrajectory.getLastWaypointTime() || time > comTrajectories.getEndTime()); timeInInterval += segmentDt) {
                comTrajectories.compute(time);
                this.totalAngularMomentum.setToZero();
                this.totalTorque.setToZero();
                if (time <= predictedLeftFootTrajectory.getLastWaypointTime()) {
                    predictedLeftFootTrajectory.compute(time);
                    this.computeAngularMomentumAtInstant((PositionTrajectoryGenerator)comTrajectories, (PositionTrajectoryGenerator)predictedLeftFootTrajectory, this.potatoMass.getDoubleValue(), (Vector3DBasics)this.angularMomentum, (Vector3DBasics)this.torque);
                    this.totalAngularMomentum.add((FrameTuple3DReadOnly)this.angularMomentum);
                    this.totalTorque.add((FrameTuple3DReadOnly)this.torque);
                }
                if (time <= predictedRightFootTrajectory.getLastWaypointTime()) {
                    predictedRightFootTrajectory.compute(time);
                    this.computeAngularMomentumAtInstant((PositionTrajectoryGenerator)comTrajectories, (PositionTrajectoryGenerator)predictedRightFootTrajectory, this.potatoMass.getDoubleValue(), (Vector3DBasics)this.angularMomentum, (Vector3DBasics)this.torque);
                    this.totalAngularMomentum.add((FrameTuple3DReadOnly)this.angularMomentum);
                    this.totalTorque.add((FrameTuple3DReadOnly)this.torque);
                }
                if (Double.isInfinite(this.totalAngularMomentum.length())) {
                    throw new RuntimeException("Error.");
                }
                this.angularMomentumEstimator.addObjectivePosition(timeInInterval, (FrameTuple3DReadOnly)this.totalAngularMomentum);
                if (!MathTools.isLessThanOrEqualToWithPrecision((double)comTrajectories.getAcceleration().getZ(), (double)this.gravityZ, (double)0.001)) {
                    this.totalAngularMomentum.scale(this.gravityZ / (this.gravityZ + comTrajectories.getAcceleration().getZ()));
                }
                this.scaledAngularMomentumEstimator.addObjectivePosition(timeInInterval, (FrameTuple3DReadOnly)this.totalAngularMomentum);
                if (!Double.isInfinite(this.totalAngularMomentum.length())) continue;
                throw new RuntimeException("Error.");
            }
            this.angularMomentumEstimator.initialize();
            this.scaledAngularMomentumEstimator.initialize();
            this.angularMomentumTrajectory.appendSegment((FixedFramePositionTrajectoryGenerator)this.angularMomentumEstimator);
            this.heightScaledAngularMomentumTrajectory.appendSegment((FixedFramePositionTrajectoryGenerator)this.scaledAngularMomentumEstimator);
        }
        this.angularMomentumTrajectory.initialize();
        this.heightScaledAngularMomentumTrajectory.initialize();
        this.visualize(comTrajectories, predictedLeftFootTrajectory, predictedRightFootTrajectory);
        this.angularMomentumEstimationTimer.stopMeasurement();
    }

    private void visualize(MultipleSegmentPositionTrajectoryGenerator<?> comTrajectories, MultipleWaypointsPositionTrajectoryGenerator secondPotatoTrajectories, MultipleWaypointsPositionTrajectoryGenerator thirdPotatoTrajectories) {
    }

    public boolean useHeightScaledAngularMomentum() {
        return this.useHeightScaledAngularMomentum.getValue();
    }

    public FrameVector3DReadOnly getDesiredAngularMomentum() {
        return this.desiredAngularMomentum;
    }

    public FrameVector3DReadOnly getDesiredHeightScaledAngularMomentum() {
        return this.desiredScaledAngularMomentum;
    }

    public FrameVector3DReadOnly getDesiredAngularMomentumRate() {
        return this.desiredAngularMomentumRate;
    }

    public FrameVector3DReadOnly getDesiredHeightScaledAngularMomentumRate() {
        return this.desiredScaledAngularMomentumRate;
    }

    public MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> getAngularMomentumTrajectories() {
        return this.angularMomentumTrajectory;
    }

    public MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> getHeightScaledAngularMomentumTrajectories() {
        return this.heightScaledAngularMomentumTrajectory;
    }

    private void computeAngularMomentumAtInstant(PositionTrajectoryGenerator comTrajectory, PositionTrajectoryGenerator potatoTrajectory, double potatoMass, Vector3DBasics angularMomentumToPack, Vector3DBasics torqueToPack) {
        this.computeAngularMomentumAtInstant(comTrajectory, potatoTrajectory, potatoMass, angularMomentumToPack);
        this.relativePotatoPosition.sub((Tuple3DReadOnly)potatoTrajectory.getPosition(), (Tuple3DReadOnly)comTrajectory.getPosition());
        this.relativePotatoAcceleration.sub((Tuple3DReadOnly)potatoTrajectory.getAcceleration(), (Tuple3DReadOnly)comTrajectory.getAcceleration());
        torqueToPack.cross((Tuple3DReadOnly)this.relativePotatoPosition, (Tuple3DReadOnly)this.relativePotatoAcceleration);
        torqueToPack.scale(potatoMass);
        if (Double.isInfinite(this.totalAngularMomentum.length())) {
            throw new RuntimeException("Error.");
        }
    }

    private void computeAngularMomentumAtInstant(PositionTrajectoryGenerator comTrajectory, PositionTrajectoryGenerator potatoTrajectory, double potatoMass, Vector3DBasics angularMomentumToPack) {
        this.computeAngularMomentumAtInstant(comTrajectory.getPosition(), comTrajectory.getVelocity(), potatoTrajectory.getPosition(), potatoTrajectory.getVelocity(), potatoMass, angularMomentumToPack);
    }

    private void computeAngularMomentumAtInstant(Point3DReadOnly centerOfMassPosition, Vector3DReadOnly centerOfMassVelocity, Point3DReadOnly potatoPosition, Vector3DReadOnly potatoVelocity, double potatoMass, Vector3DBasics angularMomentumToPack) {
        this.relativePotatoPosition.sub((Tuple3DReadOnly)potatoPosition, (Tuple3DReadOnly)centerOfMassPosition);
        this.relativePotatoVelocity.sub((Tuple3DReadOnly)potatoVelocity, (Tuple3DReadOnly)centerOfMassVelocity);
        angularMomentumToPack.cross((Tuple3DReadOnly)this.relativePotatoPosition, (Tuple3DReadOnly)this.relativePotatoVelocity);
        angularMomentumToPack.scale(potatoMass);
    }
}

