/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class SimpleBipedContactPhase
implements ContactStateProvider<SimpleBipedContactPhase> {
    private final TimeInterval timeInterval = new TimeInterval();
    private final List<RobotSide> feetInContact = new ArrayList<RobotSide>();
    private final List<String> feetNamesInContact = new ArrayList<String>();
    private ContactState contactState = ContactState.IN_CONTACT;
    private final List<RobotSide> startFeet = new ArrayList<RobotSide>();
    private final List<RobotSide> endFeet = new ArrayList<RobotSide>();
    private final SideDependentList<FramePose3D> startFootPoses = new SideDependentList();
    private final SideDependentList<FramePose3D> endFootPoses = new SideDependentList();
    private final FramePoint3D startCopPosition = new FramePoint3D();
    private final FramePoint3D endCopPosition = new FramePoint3D();
    private final FrameVector3D copVelocity = new FrameVector3D();
    private boolean isUpToDate = false;
    private final FramePoint3D tempPoint = new FramePoint3D();

    public SimpleBipedContactPhase() {
        for (RobotSide robotSide : RobotSide.values) {
            this.startFootPoses.put((Enum)robotSide, (Object)new FramePose3D());
            this.endFootPoses.put((Enum)robotSide, (Object)new FramePose3D());
        }
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public FramePoint3DReadOnly getECMPStartPosition() {
        if (!this.isUpToDate) {
            throw new RuntimeException("The CoP positions are not up to date.");
        }
        return this.startCopPosition;
    }

    @Override
    public FramePoint3DReadOnly getECMPEndPosition() {
        if (!this.isUpToDate) {
            throw new RuntimeException("The CoP positions are not up to date.");
        }
        return this.endCopPosition;
    }

    @Override
    public FrameVector3DReadOnly getECMPStartVelocity() {
        if (!this.isUpToDate) {
            throw new RuntimeException("The CoP positions are not up to date.");
        }
        return this.copVelocity;
    }

    @Override
    public FrameVector3DReadOnly getECMPEndVelocity() {
        if (!this.isUpToDate) {
            throw new RuntimeException("The CoP positions are not up to date.");
        }
        return this.copVelocity;
    }

    @Override
    public ContactState getContactState() {
        return this.contactState;
    }

    public List<RobotSide> getFeetInContact() {
        return this.feetInContact;
    }

    public List<String> getFeetNameInContact() {
        return this.feetNamesInContact;
    }

    public void reset() {
        this.feetInContact.clear();
        this.feetNamesInContact.clear();
        this.startFeet.clear();
        this.endFeet.clear();
        this.startCopPosition.setToNaN();
        this.endCopPosition.setToNaN();
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePose3D)this.startFootPoses.get((Enum)robotSide)).setToNaN();
            ((FramePose3D)this.endFootPoses.get((Enum)robotSide)).setToNaN();
        }
        this.isUpToDate = false;
    }

    public void resetEnd() {
        this.endFeet.clear();
        this.endCopPosition.setToNaN();
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePose3D)this.endFootPoses.get((Enum)robotSide)).setToNaN();
        }
        this.isUpToDate = false;
    }

    public void set(SimpleBipedContactPhase other) {
        int i;
        this.reset();
        this.setFeetInContact(other.feetInContact);
        this.getTimeInterval().set((TimeIntervalReadOnly)other.timeInterval);
        for (i = 0; i < other.startFeet.size(); ++i) {
            this.addStartFoot(other.startFeet.get(i), (FramePose3DReadOnly)other.startFootPoses.get((Enum)other.startFeet.get(i)));
        }
        for (i = 0; i < other.endFeet.size(); ++i) {
            this.addEndFoot(other.endFeet.get(i), (FramePose3DReadOnly)other.endFootPoses.get((Enum)other.endFeet.get(i)));
        }
        this.isUpToDate = false;
        this.update();
    }

    public void setFeetInContact(List<RobotSide> feetInContact) {
        if (feetInContact.size() > 2) {
            throw new IllegalArgumentException("There can't be more than 2 feet in contact for a biped.");
        }
        this.feetInContact.clear();
        this.feetNamesInContact.clear();
        for (int i = 0; i < feetInContact.size(); ++i) {
            this.feetInContact.add(feetInContact.get(i));
            this.feetNamesInContact.add(feetInContact.get(i).getLowerCaseName());
        }
        this.isUpToDate = false;
    }

    public void addStartFoot(RobotSide robotSide, FramePose3DReadOnly pose) {
        if (this.startFeet.contains(robotSide)) {
            throw new RuntimeException("Already contains this.");
        }
        this.startFeet.add(robotSide);
        ((FramePose3D)this.startFootPoses.get((Enum)robotSide)).setMatchingFrame(pose);
        this.isUpToDate = false;
    }

    public void addEndFoot(RobotSide robotSide, FramePose3DReadOnly pose) {
        if (this.endFeet.contains(robotSide)) {
            throw new RuntimeException("Already contains this.");
        }
        this.endFeet.add(robotSide);
        ((FramePose3D)this.endFootPoses.get((Enum)robotSide)).setMatchingFrame(pose);
        this.isUpToDate = false;
    }

    public void setStartFootPoses(SideDependentList<? extends FramePose3DReadOnly> poses) {
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePose3D)this.startFootPoses.get((Enum)robotSide)).setMatchingFrame((FramePose3DReadOnly)poses.get((Enum)robotSide));
        }
        this.isUpToDate = false;
    }

    public void update() {
        if (this.feetInContact.isEmpty()) {
            this.contactState = ContactState.FLIGHT;
        } else {
            int i;
            this.contactState = ContactState.IN_CONTACT;
            this.startCopPosition.setToZero();
            for (i = 0; i < this.startFeet.size(); ++i) {
                this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)((FramePose3D)this.startFootPoses.get((Enum)this.startFeet.get(i))).getPosition());
                this.tempPoint.changeFrame(ReferenceFrame.getWorldFrame());
                this.startCopPosition.add((FrameTuple3DReadOnly)this.tempPoint);
            }
            this.startCopPosition.scale(1.0 / (double)this.startFeet.size());
            this.endCopPosition.setToZero();
            for (i = 0; i < this.endFeet.size(); ++i) {
                this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)((FramePose3D)this.endFootPoses.get((Enum)this.endFeet.get(i))).getPosition());
                this.tempPoint.changeFrame(ReferenceFrame.getWorldFrame());
                this.endCopPosition.add((FrameTuple3DReadOnly)this.tempPoint);
            }
            this.endCopPosition.scale(1.0 / (double)this.endFeet.size());
        }
        this.copVelocity.sub((FrameTuple3DReadOnly)this.endCopPosition, (FrameTuple3DReadOnly)this.startCopPosition);
        this.copVelocity.scale(1.0 / this.getTimeInterval().getDuration());
        this.isUpToDate = true;
    }
}

