/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class PlanningTiming
extends YoSaveableModuleState {
    private final YoDouble swingTime;
    private final YoDouble transferTime;

    public PlanningTiming(String suffix, YoRegistry registry) {
        this.swingTime = new YoDouble("swingTime" + suffix, registry);
        this.transferTime = new YoDouble("transferTime" + suffix, registry);
        this.registerVariableToSave((YoVariable)this.swingTime);
        this.registerVariableToSave((YoVariable)this.transferTime);
        this.clear();
    }

    public double getSwingTime() {
        return this.swingTime.getDoubleValue();
    }

    public double getTransferTime() {
        return this.transferTime.getDoubleValue();
    }

    public void clear() {
        this.swingTime.setToNaN();
        this.transferTime.setToNaN();
    }

    public void set(FootstepTiming timing) {
        this.setSwingTime(timing.getSwingTime());
        this.setTransferTime(timing.getTransferTime());
    }

    public void set(double swingTime, double transferTime) {
        this.setSwingTime(swingTime);
        this.setTransferTime(transferTime);
    }

    public void setSwingTime(double swingTime) {
        this.swingTime.set(swingTime);
    }

    public void setTransferTime(double transferTime) {
        this.transferTime.set(transferTime);
    }
}

