/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPPointViewer;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.DynamicPlanningFootstep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PlanningTiming;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FlamingoCoPTrajectoryGenerator
extends CoPTrajectoryGenerator {
    private final CoPTrajectoryParameters parameters;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final SideDependentList<FrameConvexPolygon2D> movingPolygonsInSole = new SideDependentList((Object)new FrameConvexPolygon2D(), (Object)new FrameConvexPolygon2D());
    private final SideDependentList<PoseReferenceFrame> stepFrames = new SideDependentList();
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(SettableContactStateProvider::new);
    private final FramePose3D tempPose = new FramePose3D();
    private final FrameConvexPolygon2D tempPolygon = new FrameConvexPolygon2D();
    private final ConvexPolygonScaler polygonScaler = new ConvexPolygonScaler();
    private final FramePoint3D tempPointForCoPCalculation = new FramePoint3D();
    private final FramePoint3D midfootCoP = new FramePoint3D();
    private final FramePoint2D copInFootFrame = new FramePoint2D();
    private CoPPointViewer viewer = null;

    public FlamingoCoPTrajectoryGenerator(CoPTrajectoryParameters parameters, YoRegistry parentRegistry) {
        super(FlamingoCoPTrajectoryGenerator.class, parentRegistry);
        this.parameters = parameters;
        this.registry = new YoRegistry(((Object)((Object)this)).getClass().getSimpleName());
        for (RobotSide robotSide : RobotSide.values) {
            this.stepFrames.put((Enum)robotSide, (Object)new PoseReferenceFrame(robotSide.getLowerCaseName() + "StepFrame", ReferenceFrame.getWorldFrame()));
        }
        parentRegistry.addChild(this.registry);
        this.clear();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public void setWaypointViewer(CoPPointViewer viewer) {
        this.viewer = viewer;
    }

    public void clear() {
        this.contactStateProviders.clear();
    }

    public void compute(CoPTrajectoryGeneratorState state) {
        this.contactStateProviders.clear();
        for (RobotSide robotSide : RobotSide.values) {
            PoseReferenceFrame stepFrame = (PoseReferenceFrame)this.stepFrames.get((Enum)robotSide);
            this.tempPose.setIncludingFrame(state.getFootPose(robotSide));
            this.tempPose.changeFrame(stepFrame.getParent());
            stepFrame.setPoseAndUpdate((FramePose3DReadOnly)this.tempPose);
            ((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)robotSide)).setIncludingFrame((FrameVertex2DSupplier)state.getFootPolygonInSole(robotSide));
            ((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)robotSide)).changeFrameAndProjectToXYPlane((ReferenceFrame)stepFrame);
        }
        SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartTime(0.0);
        contactStateProvider.setStartECMPPosition(state.getInitialCoP());
        DynamicPlanningFootstep footstep = state.getFootstep(0);
        PlanningTiming timings = state.getTiming(0);
        RobotSide supportSide = footstep.getRobotSide().getOppositeSide();
        this.computeEntryCoPPointLocation((FramePoint3DBasics)this.tempPointForCoPCalculation, (FrameConvexPolygon2DReadOnly)this.movingPolygonsInSole.get((Enum)supportSide), supportSide);
        this.midfootCoP.interpolate((FrameTuple3DReadOnly)state.getInitialCoP(), (FrameTuple3DReadOnly)this.tempPointForCoPCalculation, this.parameters.getDefaultTransferWeightDistribution());
        contactStateProvider.setDuration(this.parameters.getDefaultTransferSplitFraction() * timings.getTransferTime());
        contactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)this.midfootCoP);
        contactStateProvider.setLinearECMPVelocity();
        SettableContactStateProvider previousContactState = contactStateProvider;
        contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartFromEnd(previousContactState);
        contactStateProvider.setDuration((1.0 - this.parameters.getDefaultTransferSplitFraction()) * timings.getTransferTime());
        contactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactStateProvider.setLinearECMPVelocity();
        previousContactState = contactStateProvider;
        contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartFromEnd(previousContactState);
        contactStateProvider.setDuration(Double.POSITIVE_INFINITY);
        this.tempPointForCoPCalculation.setIncludingFrame((FrameTuple2DReadOnly)((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)supportSide)).getCentroid(), 0.0);
        this.tempPointForCoPCalculation.changeFrame(worldFrame);
        contactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactStateProvider.setLinearECMPVelocity();
        if (this.viewer != null) {
            this.viewer.updateWaypoints((List<? extends ContactStateProvider>)this.contactStateProviders);
        }
    }

    @Override
    public RecyclingArrayList<SettableContactStateProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }

    private void computeEntryCoPPointLocation(FramePoint3DBasics copLocationToPack, FrameConvexPolygon2DReadOnly supportPolygon, RobotSide supportSide) {
        this.copInFootFrame.setIncludingFrame((FrameTuple2DReadOnly)supportPolygon.getCentroid());
        Vector2DReadOnly copOffset = this.parameters.getEntryCMPOffset();
        double copXOffset = MathTools.clamp((double)copOffset.getX(), (double)this.parameters.getEntryCMPMinX(), (double)this.parameters.getEntryCMPMaxX());
        this.copInFootFrame.add(copXOffset, supportSide.negateIfLeftSide(copOffset.getY()));
        this.constrainToPolygon((FramePoint2DBasics)this.copInFootFrame, supportPolygon, this.parameters.getMinimumDistanceInsidePolygon());
        copLocationToPack.setIncludingFrame((FrameTuple2DReadOnly)this.copInFootFrame, 0.0);
        copLocationToPack.changeFrame(worldFrame);
    }

    private void constrainToPolygon(FramePoint2DBasics copPointToConstrain, FrameConvexPolygon2DReadOnly constraintPolygon, double safeDistanceFromSupportPolygonEdges) {
        if (constraintPolygon.signedDistance((FramePoint2DReadOnly)copPointToConstrain) <= -safeDistanceFromSupportPolygonEdges) {
            return;
        }
        this.polygonScaler.scaleConvexPolygon(constraintPolygon, safeDistanceFromSupportPolygonEdges, this.tempPolygon);
        copPointToConstrain.changeFrame(constraintPolygon.getReferenceFrame());
        this.tempPolygon.orthogonalProjection(copPointToConstrain);
    }
}

