/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.lists.YoPreallocatedList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.tools.saveableModule.YoSaveableModuleStateTools;
import us.ihmc.yoVariables.euclid.YoPoint2D;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class DynamicPlanningFootstep
extends YoSaveableModuleState {
    private final YoPreallocatedList<YoPoint2D> predictedContactPoints;
    private final YoFramePose3D footstepPose;
    private final YoEnum<RobotSide> stepSide;
    private int contactPointCounter = 0;

    public DynamicPlanningFootstep(String suffix, YoRegistry registry) {
        this.footstepPose = new YoFramePose3D("footstepPose" + suffix, ReferenceFrame.getWorldFrame(), registry);
        YoSaveableModuleStateTools.registerYoFramePose3DToSave((YoFramePose3D)this.footstepPose, (YoSaveableModuleState)this);
        this.predictedContactPoints = new YoPreallocatedList(YoPoint2D.class, () -> this.createYoContactPoint(suffix, registry), "footstep" + suffix + "ContactPoint", registry, 6);
        this.registerVariableToSave((YoVariable)this.predictedContactPoints.getYoPosition());
        this.stepSide = new YoEnum("stepSide" + suffix, registry, RobotSide.class);
        this.registerVariableToSave((YoVariable)this.stepSide);
        this.clear();
    }

    private YoPoint2D createYoContactPoint(String suffix, YoRegistry registry) {
        YoPoint2D point = new YoPoint2D("footstep" + suffix + "ContactPoint" + this.contactPointCounter++, registry);
        YoSaveableModuleStateTools.registerYoTuple2DToSave((YoTuple2D)point, (YoSaveableModuleState)this);
        return point;
    }

    public FramePose3DReadOnly getFootstepPose() {
        return this.footstepPose;
    }

    public RobotSide getRobotSide() {
        return (RobotSide)this.stepSide.getEnumValue();
    }

    public boolean hasPredictedContactPoints() {
        return !this.predictedContactPoints.isEmpty();
    }

    public List<? extends Point2DReadOnly> getPredictedContactPoints() {
        return this.predictedContactPoints;
    }

    public void clear() {
        this.footstepPose.setToNaN();
        for (int i = 0; i < this.predictedContactPoints.size(); ++i) {
            ((YoPoint2D)this.predictedContactPoints.get(i)).setToNaN();
        }
        this.predictedContactPoints.clear();
    }

    public void set(Footstep footstep) {
        this.footstepPose.set((FramePose3DReadOnly)footstep.getFootstepPose());
        this.stepSide.set((Enum)footstep.getRobotSide());
        if (!footstep.hasPredictedContactPoints()) {
            return;
        }
        for (int i = 0; i < Math.min(footstep.getPredictedContactPoints().size(), this.predictedContactPoints.capacity()); ++i) {
            ((YoPoint2D)this.predictedContactPoints.add()).set((Tuple2DReadOnly)footstep.getPredictedContactPoints().get(i));
        }
    }

    public void set(RobotSide robotSide, FramePose3DReadOnly footstepPose, List<YoPoint2D> predictedContactPoints) {
        this.footstepPose.set(footstepPose);
        this.stepSide.set((Enum)robotSide);
        if (predictedContactPoints == null) {
            return;
        }
        for (int i = 0; i < Math.min(predictedContactPoints.size(), this.predictedContactPoints.capacity()); ++i) {
            ((YoPoint2D)this.predictedContactPoints.add()).set((Tuple2DReadOnly)predictedContactPoints.get(i));
        }
    }
}

