/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PlanForToeOffCalculator;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector2D;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CoPTrajectoryParameters
extends YoSaveableModuleState {
    private static final double defaultMinimumDistanceInsidePolygon = 0.01;
    private static final double defaultStepLengthToPutExitCoPOnToes = 0.2;
    private static final double defaultStepHeightToPutExitCoPOnToesSteppingDown = -0.1;
    private static final double defaultDistanceFromFootEdgeToSnapToToe = 0.02;
    private static final boolean defaultPlanWithExitCMPOnToes = false;
    private static final boolean defaultPlanWithExitCMPOnToesWhenSteppingDown = true;
    private static final double defaultEntryCMPMinX = -0.04;
    private static final double defaultEntryCMPMaxX = 0.03;
    private static final double defaultBallCMPMinX = 0.0;
    private static final double defaultBallCMPMaxX = 0.055;
    private static final double defaultExitCMPMinX = 0.0;
    private static final double defaultExitCMPMaxX = 0.1;
    private static final double defaultDurationForContinuityMaintenanceSegment = 0.2;
    private static final double defaultExitCoPForwardSafetyMarginOnToes = 0.016;
    private static final double defaultTransferSplitFraction = 0.5;
    private static final double defaultSwingSplitFraction = 0.5;
    private static final double defaultSwingDurationShiftFraction = 0.85;
    private static final double defaultTransferWeightDistribution = 0.5;
    private static final Vector2DReadOnly defaultEntryCMPOffset = new Vector2D(0.0, -0.005);
    private static final Vector2DReadOnly defaultBallCMPOffset = new Vector2D(0.0, 0.01);
    private static final Vector2DReadOnly defaultExitCMPOffset = new Vector2D(0.0, 0.025);
    private static final double defaultEntryCMPLengthOffsetFactor = 0.3333333333333333;
    private static final double defaultBallCMPLengthOffsetFactor = 0.125;
    private static final double defaultExitCMPLengthOffsetFactor = 0.3333333333333333;
    private static final double defaultStepDownLengthOffsetScaleFactor = 2.0;
    private static final int defaultNumberOfStepsToConsider = 3;
    protected final DoubleParameter minimumDistanceInsidePolygon;
    protected final DoubleParameter stepLengthToPutExitCoPOnToes;
    protected final DoubleParameter stepHeightToPutExitCoPOnToesSteppingDown;
    protected final DoubleParameter distanceFromFootEdgeToSnapToToe;
    protected final BooleanParameter planWithExitCMPOnToes;
    protected final BooleanParameter planWithExitCMPOnToesWhenSteppingDown;
    protected final DoubleParameter entryCMPMinX;
    protected final DoubleParameter entryCMPMaxX;
    protected final DoubleParameter ballCMPMinX;
    protected final DoubleParameter ballCMPMaxX;
    protected final DoubleParameter exitCMPMinX;
    protected final DoubleParameter exitCMPMaxX;
    protected final ParameterVector2D entryCMPOffset;
    protected final ParameterVector2D ballCMPOffset;
    protected final ParameterVector2D exitCMPOffset;
    private final DoubleParameter stepDownLengthOffsetScaleFactor;
    protected final DoubleParameter entryCMPLengthOffsetFactor;
    protected final DoubleParameter ballCMPLengthOffsetFactor;
    protected final DoubleParameter exitCMPLengthOffsetFactor;
    private final DoubleParameter swingDurationShiftFraction;
    private final DoubleParameter swingSplitFraction;
    private final DoubleParameter transferSplitFraction;
    private final DoubleParameter transferWeightDistribution;
    private final DoubleParameter finalTransferSplitFraction;
    private final DoubleParameter finalTransferWeightDistribution;
    protected final IntegerParameter numberOfStepsToConsider;
    private final DoubleParameter durationForContinuityMaintenanceSegment;
    private final DoubleParameter exitCoPForwardSafetyMarginOnToes;
    private final YoRegistry registry = new YoRegistry("CoPTrajectoryParameters");
    private final PlanForToeOffCalculator planForToeOffCalculator = new PlanForToeOffCalculator(){

        @Override
        public boolean shouldPutCMPOnToes(double stepHeight, FramePoint3DReadOnly copPointInSoleFrame, FrameConvexPolygon2DReadOnly supportPolygon) {
            if (CoPTrajectoryParameters.this.getPlanWithExitCMPOnToes() || CoPTrajectoryParameters.this.getPlanWithExitCMPOnToesWhenSteppingDown() && MathTools.isLessThanWithPrecision((double)stepHeight, (double)CoPTrajectoryParameters.this.getStepHeightToPutExitCoPOnToesSteppingDown(), (double)0.01)) {
                return MathTools.epsilonEquals((double)copPointInSoleFrame.getX(), (double)supportPolygon.getMaxX(), (double)CoPTrajectoryParameters.this.getDistanceFromFootEdgeToSnapToToe());
            }
            return false;
        }
    };

    public CoPTrajectoryParameters() {
        this.minimumDistanceInsidePolygon = new DoubleParameter("minimumDistanceInsidePolygon", this.registry, 0.01);
        this.stepLengthToPutExitCoPOnToes = new DoubleParameter("stepLengthToPutExitCoPOnToes", this.registry, 0.2);
        this.stepHeightToPutExitCoPOnToesSteppingDown = new DoubleParameter("stepHeightToPutExitCoPOnToesSteppingDown", this.registry, -0.1);
        this.distanceFromFootEdgeToSnapToToe = new DoubleParameter("distanceFromFootEdgeToSnapToToe", this.registry, 0.02);
        this.planWithExitCMPOnToes = new BooleanParameter("planWithExitCMPOnToes", this.registry, false);
        this.planWithExitCMPOnToesWhenSteppingDown = new BooleanParameter("planWithExitCMPOnToesWhenSteppingDown", this.registry, true);
        this.entryCMPMinX = new DoubleParameter("entryCMPMinX", this.registry, -0.04);
        this.entryCMPMaxX = new DoubleParameter("entryCMPMaxX", this.registry, 0.03);
        this.ballCMPMinX = new DoubleParameter("ballCMPMinX", this.registry, 0.0);
        this.ballCMPMaxX = new DoubleParameter("ballCMPMaxX", this.registry, 0.055);
        this.exitCMPMinX = new DoubleParameter("exitCMPMinX", this.registry, 0.0);
        this.exitCMPMaxX = new DoubleParameter("exitCMPMaxX", this.registry, 0.1);
        this.entryCMPOffset = new ParameterVector2D("entryCMPOffset", defaultEntryCMPOffset, this.registry);
        this.ballCMPOffset = new ParameterVector2D("ballCMPOffset", defaultBallCMPOffset, this.registry);
        this.exitCMPOffset = new ParameterVector2D("exitCMPOffset", defaultExitCMPOffset, this.registry);
        this.entryCMPLengthOffsetFactor = new DoubleParameter("entryCMPLengthOffsetFactor", this.registry, 0.3333333333333333);
        this.ballCMPLengthOffsetFactor = new DoubleParameter("ballCMPLengthOffsetFactor", this.registry, 0.125);
        this.exitCMPLengthOffsetFactor = new DoubleParameter("exitCMPLengthOffsetFactor", this.registry, 0.3333333333333333);
        this.stepDownLengthOffsetScaleFactor = new DoubleParameter("stepDownLengthOffsetScaleFactor", this.registry, 2.0);
        this.numberOfStepsToConsider = new IntegerParameter("numberOfStepsToConsider", this.registry, 3);
        this.durationForContinuityMaintenanceSegment = new DoubleParameter("durationForContinuityMaintenanceSegment", this.registry, 0.2);
        this.exitCoPForwardSafetyMarginOnToes = new DoubleParameter("exitCoPForwardSafetyMarginOnToes", this.registry, 0.016);
        this.swingDurationShiftFraction = new DoubleParameter("defaultSwingDurationShiftFraction", this.registry, 0.85);
        this.swingSplitFraction = new DoubleParameter("defaultSwingSplitFraction", this.registry, 0.5);
        this.transferSplitFraction = new DoubleParameter("defaultTransferSplitFraction", this.registry, 0.5);
        this.transferWeightDistribution = new DoubleParameter("defaultTransferWeightDistribution", this.registry, 0.5);
        this.finalTransferSplitFraction = new DoubleParameter("defaultFinalTransferSplitFraction", this.registry, 0.5);
        this.finalTransferWeightDistribution = new DoubleParameter("defaultFinalTransferWeightDistribution", this.registry, 0.5);
        this.registerVariableToSave((YoParameter)this.minimumDistanceInsidePolygon);
        this.registerVariableToSave((YoParameter)this.stepLengthToPutExitCoPOnToes);
        this.registerVariableToSave((YoParameter)this.stepHeightToPutExitCoPOnToesSteppingDown);
        this.registerVariableToSave((YoParameter)this.entryCMPMinX);
        this.registerVariableToSave((YoParameter)this.entryCMPMaxX);
        this.registerVariableToSave((YoParameter)this.ballCMPMinX);
        this.registerVariableToSave((YoParameter)this.ballCMPMaxX);
        this.registerVariableToSave((YoParameter)this.exitCMPMinX);
        this.registerVariableToSave((YoParameter)this.exitCMPMaxX);
        this.registerVariableToSave((YoParameter)this.stepDownLengthOffsetScaleFactor);
        this.registerVariableToSave((YoParameter)this.planWithExitCMPOnToes);
        this.registerVariableToSave((YoParameter)this.planWithExitCMPOnToesWhenSteppingDown);
        this.registerVariableToSave((YoParameter)this.distanceFromFootEdgeToSnapToToe);
        this.registerVariableToSave((YoParameter)this.entryCMPOffset.getXParameter());
        this.registerVariableToSave((YoParameter)this.entryCMPOffset.getYParameter());
        this.registerVariableToSave((YoParameter)this.ballCMPOffset.getXParameter());
        this.registerVariableToSave((YoParameter)this.ballCMPOffset.getYParameter());
        this.registerVariableToSave((YoParameter)this.exitCMPOffset.getXParameter());
        this.registerVariableToSave((YoParameter)this.exitCMPOffset.getYParameter());
        this.registerVariableToSave((YoParameter)this.entryCMPLengthOffsetFactor);
        this.registerVariableToSave((YoParameter)this.ballCMPLengthOffsetFactor);
        this.registerVariableToSave((YoParameter)this.exitCMPLengthOffsetFactor);
        this.registerVariableToSave((YoParameter)this.numberOfStepsToConsider);
        this.registerVariableToSave((YoParameter)this.durationForContinuityMaintenanceSegment);
        this.registerVariableToSave((YoParameter)this.exitCoPForwardSafetyMarginOnToes);
        this.registerVariableToSave((YoParameter)this.swingDurationShiftFraction);
        this.registerVariableToSave((YoParameter)this.swingSplitFraction);
        this.registerVariableToSave((YoParameter)this.transferSplitFraction);
        this.registerVariableToSave((YoParameter)this.transferWeightDistribution);
        this.registerVariableToSave((YoParameter)this.finalTransferSplitFraction);
        this.registerVariableToSave((YoParameter)this.finalTransferWeightDistribution);
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public int getMaxNumberOfStepsToConsider() {
        return 3;
    }

    public double getMinimumDistanceInsidePolygon() {
        return this.minimumDistanceInsidePolygon.getValue();
    }

    public boolean getPlanWithExitCMPOnToes() {
        return this.planWithExitCMPOnToes.getValue();
    }

    public boolean getPlanWithExitCMPOnToesWhenSteppingDown() {
        return this.planWithExitCMPOnToesWhenSteppingDown.getValue();
    }

    public double getStepHeightToPutExitCoPOnToesSteppingDown() {
        return this.stepHeightToPutExitCoPOnToesSteppingDown.getValue();
    }

    public double getDistanceFromFootEdgeToSnapToToe() {
        return this.distanceFromFootEdgeToSnapToToe.getValue();
    }

    public double getEntryCMPMinX() {
        return this.entryCMPMinX.getValue();
    }

    public double getEntryCMPMaxX() {
        return this.entryCMPMaxX.getValue();
    }

    public double getBallCMPMinX() {
        return this.ballCMPMinX.getValue();
    }

    public double getBallCMPMaxX() {
        return this.ballCMPMaxX.getValue();
    }

    public double getExitCMPMinX() {
        return this.exitCMPMinX.getValue();
    }

    public double getExitCMPMaxX() {
        return this.exitCMPMaxX.getValue();
    }

    public Vector2DReadOnly getEntryCMPOffset() {
        return this.entryCMPOffset;
    }

    public Vector2DReadOnly getBallCMPOffset() {
        return this.ballCMPOffset;
    }

    public Vector2DReadOnly getExitCMPOffset() {
        return this.exitCMPOffset;
    }

    public double getStepDownLengthOffsetScaleFactor() {
        return this.stepDownLengthOffsetScaleFactor.getValue();
    }

    public double getEntryCMPLengthOffsetFactor() {
        return this.entryCMPLengthOffsetFactor.getValue();
    }

    public double getBallCMPLengthOffsetFactor() {
        return this.ballCMPLengthOffsetFactor.getValue();
    }

    public double getExitCMPLengthOffsetFactor() {
        return this.exitCMPLengthOffsetFactor.getValue();
    }

    public int getNumberOfStepsToConsider() {
        return this.numberOfStepsToConsider.getValue();
    }

    public double getDurationForContinuityMaintenanceSegment() {
        return this.durationForContinuityMaintenanceSegment.getValue();
    }

    public double getExitCoPForwardSafetyMarginOnToes() {
        return this.exitCoPForwardSafetyMarginOnToes.getValue();
    }

    public double getDefaultSwingDurationShiftFraction() {
        return this.swingDurationShiftFraction.getValue();
    }

    public double getDefaultSwingSplitFraction() {
        return this.swingSplitFraction.getValue();
    }

    public double getDefaultTransferSplitFraction() {
        return this.transferSplitFraction.getValue();
    }

    public double getDefaultTransferWeightDistribution() {
        return this.transferWeightDistribution.getValue();
    }

    public double getDefaultFinalTransferSplitFraction() {
        return this.finalTransferSplitFraction.getValue();
    }

    public double getDefaultFinalTransferWeightDistribution() {
        return this.finalTransferWeightDistribution.getValue();
    }

    public PlanForToeOffCalculator getPlanForToeOffCalculator() {
        return this.planForToeOffCalculator;
    }
}

