/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedStepTransitionType;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class BipedStepTransition {
    public static final double sameTimeEpsilon = 0.001;
    private final List<RobotSide> transitionSides = new ArrayList<RobotSide>();
    private final List<BipedStepTransitionType> transitionTypes = new ArrayList<BipedStepTransitionType>();
    private final SideDependentList<FramePose3D> transitionPoses = new SideDependentList();
    private double transitionTime = Double.MAX_VALUE;

    public BipedStepTransition() {
        for (RobotSide robotSide : RobotSide.values) {
            FramePose3D transitionPose = new FramePose3D();
            transitionPose.setToNaN();
            this.transitionPoses.put((Enum)robotSide, (Object)transitionPose);
        }
    }

    public void reset() {
        this.transitionTime = Double.MAX_VALUE;
        this.transitionSides.clear();
        this.transitionTypes.clear();
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePose3D)this.transitionPoses.get((Enum)robotSide)).setToNaN();
        }
    }

    public void setTransitionTime(double time) {
        this.transitionTime = time;
    }

    public void addTransition(BipedStepTransitionType transitionType, RobotSide transitionSide, FramePose3DReadOnly transitionPose) {
        this.transitionTypes.add(transitionType);
        this.transitionSides.add(transitionSide);
        ((FramePose3D)this.transitionPoses.get((Enum)transitionSide)).set(transitionPose);
    }

    public void addTransition(BipedStepTransition other) {
        if (!MathTools.epsilonEquals((double)this.transitionTime, (double)other.transitionTime, (double)0.001)) {
            throw new IllegalArgumentException("These transitions occur at different times!");
        }
        for (int i = 0; i < other.transitionSides.size(); ++i) {
            RobotSide addingSide = other.transitionSides.get(i);
            this.transitionSides.add(addingSide);
            this.transitionTypes.add(other.transitionTypes.get(i));
            ((FramePose3D)this.transitionPoses.get((Enum)addingSide)).set((FramePose3D)other.transitionPoses.get((Enum)addingSide));
        }
    }

    public double getTransitionTime() {
        return this.transitionTime;
    }

    public int getNumberOfFeetInTransition() {
        return this.transitionSides.size();
    }

    public BipedStepTransitionType getTransitionType(int transitionNumber) {
        return this.transitionTypes.get(transitionNumber);
    }

    public RobotSide getTransitionSide(int transitionNumber) {
        return this.transitionSides.get(transitionNumber);
    }

    public FramePose3DReadOnly transitionPose(RobotSide transitionSide) {
        return (FramePose3DReadOnly)this.transitionPoses.get((Enum)transitionSide);
    }
}

