/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedContactSequenceTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedStepTransition;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedStepTransitionType;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedTimedStep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.SimpleBipedContactPhase;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactSequenceProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.TimeIntervalTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BipedContactSequenceUpdater
implements ContactSequenceProvider {
    private static final boolean debug = true;
    private static final int maxCapacity = 7;
    private static final int stepsToConsider = 3;
    private final RecyclingArrayList<BipedStepTransition> stepTransitionsInAbsoluteTime = new RecyclingArrayList(BipedStepTransition::new);
    private final RecyclingArrayList<SimpleBipedContactPhase> contactSequenceInRelativeTime = new RecyclingArrayList(7, SimpleBipedContactPhase::new);
    private final RecyclingArrayList<SimpleBipedContactPhase> contactSequenceInAbsoluteTime = new RecyclingArrayList(7, SimpleBipedContactPhase::new);
    private final List<YoFramePoint2D> startCoPs = new ArrayList<YoFramePoint2D>();
    private final List<YoFramePoint2D> endCoPs = new ArrayList<YoFramePoint2D>();
    private final List<RobotSide> feetInContact = new ArrayList<RobotSide>();
    private final SideDependentList<FramePose3D> solePoses = new SideDependentList();
    private final SideDependentList<MovingReferenceFrame> soleFrames;

    public BipedContactSequenceUpdater(SideDependentList<MovingReferenceFrame> soleFrames, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.soleFrames = soleFrames;
        this.contactSequenceInAbsoluteTime.clear();
        this.contactSequenceInRelativeTime.clear();
        for (RobotSide robotSide : RobotSide.values) {
            this.feetInContact.add(robotSide);
            this.solePoses.set((Enum)robotSide, (Object)new FramePose3D());
        }
        for (int i = 0; i < 8; ++i) {
            this.startCoPs.add(new YoFramePoint2D("startCoP" + i, ReferenceFrame.getWorldFrame(), registry));
            this.endCoPs.add(new YoFramePoint2D("endCoP" + i, ReferenceFrame.getWorldFrame(), registry));
            YoGraphicPosition startCoP = new YoGraphicPosition("start cop " + i, this.startCoPs.get(i), 0.01, YoAppearance.Green(), YoGraphicPosition.GraphicType.SOLID_BALL);
            YoGraphicPosition endCoP = new YoGraphicPosition("end cop " + i, this.startCoPs.get(i), 0.01, YoAppearance.Green(), YoGraphicPosition.GraphicType.SOLID_BALL);
            if (graphicsListRegistry == null) continue;
            graphicsListRegistry.registerArtifact("Contact Sequence", (Artifact)startCoP.createArtifact());
            graphicsListRegistry.registerArtifact("Contact Sequence", (Artifact)endCoP.createArtifact());
        }
    }

    public void initialize() {
        for (int i = 0; i < this.contactSequenceInAbsoluteTime.size(); ++i) {
            ((SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.get(i)).reset();
        }
        this.contactSequenceInAbsoluteTime.clear();
    }

    public List<SimpleBipedContactPhase> getContactSequence() {
        return this.contactSequenceInRelativeTime;
    }

    public List<SimpleBipedContactPhase> getAbsoluteContactSequence() {
        return this.contactSequenceInAbsoluteTime;
    }

    public void update(List<? extends BipedTimedStep> stepSequence, List<RobotSide> currentFeetInContact, double currentTime) {
        int i;
        for (RobotSide robotSide : RobotSide.values) {
            ((FramePose3D)this.solePoses.get((Enum)robotSide)).setToZero((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        }
        this.feetInContact.clear();
        for (int footIndex = 0; footIndex < currentFeetInContact.size(); ++footIndex) {
            this.feetInContact.add(currentFeetInContact.get(footIndex));
        }
        BipedContactSequenceTools.computeStepTransitionsFromStepSequence(this.stepTransitionsInAbsoluteTime, currentTime, stepSequence, 3);
        BipedContactSequenceTools.trimPastContactSequences(this.contactSequenceInAbsoluteTime, currentTime, currentFeetInContact, this.solePoses);
        this.computeContactPhasesFromStepTransitionsOther();
        this.contactSequenceInRelativeTime.clear();
        for (i = 0; i < this.contactSequenceInAbsoluteTime.size(); ++i) {
            SimpleBipedContactPhase contactPhase = (SimpleBipedContactPhase)this.contactSequenceInRelativeTime.add();
            contactPhase.reset();
            contactPhase.set((SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.get(i));
        }
        BipedContactSequenceTools.shiftContactSequencesToRelativeTime(this.contactSequenceInRelativeTime, currentTime);
        TimeIntervalTools.removeEndTimesLessThan((double)0.0, this.contactSequenceInRelativeTime);
        for (i = 0; i < this.contactSequenceInRelativeTime.size(); ++i) {
            this.startCoPs.get(i).set((FrameTuple3DReadOnly)((SimpleBipedContactPhase)this.contactSequenceInRelativeTime.get(i)).getECMPStartPosition());
            this.endCoPs.get(i).set((FrameTuple3DReadOnly)((SimpleBipedContactPhase)this.contactSequenceInRelativeTime.get(i)).getECMPEndPosition());
        }
        while (i < 7) {
            this.startCoPs.get(i).setToNaN();
            this.endCoPs.get(i).setToNaN();
            ++i;
        }
    }

    private void computeContactPhasesFromStepTransitions() {
        int numberOfTransitions = this.stepTransitionsInAbsoluteTime.size();
        SimpleBipedContactPhase previousContactPhase = (SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.getLast();
        for (int transitionNumber = 0; transitionNumber < numberOfTransitions; ++transitionNumber) {
            boolean isLastContact;
            RobotSide previousEndSide;
            RobotSide startSide;
            BipedStepTransition stepTransition = (BipedStepTransition)this.stepTransitionsInAbsoluteTime.get(transitionNumber);
            previousContactPhase.getTimeInterval().setEndTime(stepTransition.getTransitionTime());
            SimpleBipedContactPhase contactPhase = (SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.add();
            contactPhase.reset();
            block5: for (int transitioningFootNumber = 0; transitioningFootNumber < stepTransition.getNumberOfFeetInTransition(); ++transitioningFootNumber) {
                RobotSide transitionSide = stepTransition.getTransitionSide(transitioningFootNumber);
                switch (stepTransition.getTransitionType(transitioningFootNumber)) {
                    case LIFT_OFF: {
                        this.feetInContact.remove(transitionSide);
                        continue block5;
                    }
                    case TOUCH_DOWN: {
                        this.feetInContact.add(transitionSide);
                        ((FramePose3D)this.solePoses.get((Enum)transitionSide)).setMatchingFrame(stepTransition.transitionPose(transitionSide));
                    }
                }
            }
            if (stepTransition.getNumberOfFeetInTransition() > 1 && stepTransition.getTransitionType(0) == stepTransition.getTransitionType(1)) {
                throw new RuntimeException("Not handled.");
            }
            RobotSide transitionSide = stepTransition.getTransitionSide(0);
            BipedStepTransitionType transitionType = stepTransition.getTransitionType(0);
            if (transitionType == BipedStepTransitionType.LIFT_OFF) {
                if (this.feetInContact.isEmpty()) {
                    startSide = transitionSide;
                    previousEndSide = transitionSide;
                } else {
                    startSide = transitionSide.getOppositeSide();
                    previousEndSide = transitionSide.getOppositeSide();
                }
            } else {
                startSide = transitionSide.getOppositeSide();
                previousEndSide = transitionSide.getOppositeSide();
            }
            if (this.feetInContact.size() > 0) {
                contactPhase.addStartFoot(startSide, (FramePose3DReadOnly)this.solePoses.get((Enum)startSide));
            }
            previousContactPhase.addEndFoot(previousEndSide, (FramePose3DReadOnly)this.solePoses.get((Enum)previousEndSide));
            previousContactPhase.update();
            contactPhase.setFeetInContact(this.feetInContact);
            contactPhase.getTimeInterval().setStartTime(stepTransition.getTransitionTime());
            previousContactPhase = contactPhase;
            boolean bl = isLastContact = transitionNumber == numberOfTransitions - 1 || this.contactSequenceInAbsoluteTime.size() >= 7 && this.feetInContact.size() > 0;
            if (isLastContact) break;
        }
        previousContactPhase.getTimeInterval().setEndTime(Double.POSITIVE_INFINITY);
        for (int i = 0; i < this.feetInContact.size(); ++i) {
            previousContactPhase.addEndFoot(this.feetInContact.get(i), (FramePose3DReadOnly)this.solePoses.get((Enum)this.feetInContact.get(i)));
        }
        previousContactPhase.update();
    }

    private void computeContactPhasesFromStepTransitionsOther() {
        int numberOfTransitions = this.stepTransitionsInAbsoluteTime.size();
        for (int transitionNumber = 0; transitionNumber < numberOfTransitions; ++transitionNumber) {
            boolean isLastContact;
            int i;
            BipedStepTransition stepTransition = (BipedStepTransition)this.stepTransitionsInAbsoluteTime.get(transitionNumber);
            if (!BipedContactSequenceUpdater.isValidTransition(stepTransition)) {
                throw new RuntimeException("Not a valid transition.");
            }
            block5: for (int transitioningFootNumber = 0; transitioningFootNumber < stepTransition.getNumberOfFeetInTransition(); ++transitioningFootNumber) {
                RobotSide transitionSide = stepTransition.getTransitionSide(transitioningFootNumber);
                switch (stepTransition.getTransitionType(transitioningFootNumber)) {
                    case LIFT_OFF: {
                        this.feetInContact.remove(transitionSide);
                        continue block5;
                    }
                    case TOUCH_DOWN: {
                        this.feetInContact.add(transitionSide);
                        ((FramePose3D)this.solePoses.get((Enum)transitionSide)).setMatchingFrame(stepTransition.transitionPose(transitionSide));
                    }
                }
            }
            SimpleBipedContactPhase endingContactSequence = (SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.getLast();
            SimpleBipedContactPhase newContactSequence = (SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.add();
            newContactSequence.reset();
            endingContactSequence.getTimeInterval().setEndTime(stepTransition.getTransitionTime());
            newContactSequence.getTimeInterval().setStartTime(stepTransition.getTransitionTime());
            newContactSequence.setFeetInContact(this.feetInContact);
            if (this.feetInContact.isEmpty()) {
                for (i = 0; i < stepTransition.getNumberOfFeetInTransition(); ++i) {
                    assert (stepTransition.getTransitionType(i) == BipedStepTransitionType.LIFT_OFF);
                    RobotSide liftOffSide = stepTransition.getTransitionSide(i);
                    endingContactSequence.addEndFoot(liftOffSide, (FramePose3DReadOnly)this.solePoses.get((Enum)liftOffSide));
                }
            } else if (this.feetInContact.size() == 1) {
                if (stepTransition.getNumberOfFeetInTransition() > 1) {
                    throw new RuntimeException("Currently can't handle an instant switch in support.");
                }
                if (stepTransition.getTransitionType(0) == BipedStepTransitionType.LIFT_OFF) {
                    RobotSide transitionSide = stepTransition.getTransitionSide(0);
                    RobotSide supportSide = transitionSide.getOppositeSide();
                    endingContactSequence.addEndFoot(supportSide, (FramePose3DReadOnly)this.solePoses.get((Enum)supportSide));
                    newContactSequence.addStartFoot(supportSide, (FramePose3DReadOnly)this.solePoses.get((Enum)supportSide));
                    assert (supportSide == this.feetInContact.get(0));
                } else {
                    RobotSide transitionSide = stepTransition.getTransitionSide(0);
                    newContactSequence.addStartFoot(transitionSide, (FramePose3DReadOnly)this.solePoses.get((Enum)transitionSide));
                    assert (transitionSide == this.feetInContact.get(0));
                }
            } else {
                assert (this.feetInContact.size() == 2);
                for (i = 0; i < stepTransition.getNumberOfFeetInTransition(); ++i) {
                    assert (stepTransition.getTransitionType(i) == BipedStepTransitionType.TOUCH_DOWN);
                }
                if (stepTransition.getNumberOfFeetInTransition() == 2) {
                    for (i = 0; i < stepTransition.getNumberOfFeetInTransition(); ++i) {
                        RobotSide transitionSide = stepTransition.getTransitionSide(i);
                        newContactSequence.addStartFoot(transitionSide, (FramePose3DReadOnly)this.solePoses.get((Enum)transitionSide));
                    }
                } else {
                    assert (stepTransition.getNumberOfFeetInTransition() == 1);
                    RobotSide transitionSide = stepTransition.getTransitionSide(0);
                    RobotSide oppositeSide = transitionSide.getOppositeSide();
                    endingContactSequence.addEndFoot(oppositeSide, (FramePose3DReadOnly)this.solePoses.get((Enum)oppositeSide));
                    newContactSequence.addStartFoot(oppositeSide, (FramePose3DReadOnly)this.solePoses.get((Enum)oppositeSide));
                }
            }
            boolean bl = isLastContact = transitionNumber == numberOfTransitions - 1 || this.contactSequenceInAbsoluteTime.size() >= 7 && this.feetInContact.size() > 0;
            if (isLastContact) break;
        }
        SimpleBipedContactPhase contactPhase = (SimpleBipedContactPhase)this.contactSequenceInAbsoluteTime.getLast();
        contactPhase.getTimeInterval().setEndTime(Double.POSITIVE_INFINITY);
        for (int i = 0; i < this.feetInContact.size(); ++i) {
            contactPhase.addEndFoot(this.feetInContact.get(i), (FramePose3DReadOnly)this.solePoses.get((Enum)this.feetInContact.get(i)));
        }
        contactPhase.update();
    }

    private static boolean isValidTransition(BipedStepTransition stepTransition) {
        return stepTransition.getNumberOfFeetInTransition() <= 2;
    }
}

