/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.Comparator;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedStepTransition;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedStepTransitionType;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedTimedStep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.SimpleBipedContactPhase;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.TimeIntervalTools;

public class BipedContactSequenceTools {
    public static void collapseTransitionEvents(List<BipedStepTransition> stepTransitionsToPack) {
        int transitionNumber = 0;
        while (transitionNumber < stepTransitionsToPack.size() - 1) {
            BipedStepTransition currentTransition = stepTransitionsToPack.get(transitionNumber);
            BipedStepTransition nextTransition = stepTransitionsToPack.get(transitionNumber + 1);
            if (MathTools.epsilonEquals((double)currentTransition.getTransitionTime(), (double)nextTransition.getTransitionTime(), (double)0.001)) {
                currentTransition.addTransition(nextTransition);
                stepTransitionsToPack.remove(transitionNumber + 1);
                continue;
            }
            ++transitionNumber;
        }
    }

    public static void computeStepTransitionsFromStepSequence(RecyclingArrayList<BipedStepTransition> stepTransitionsToPack, double firstSwingStartTime, double currentTime, List<Footstep> footstepList, List<FootstepTiming> footstepTimingList, int stepsToConsider) {
        double transitionTime = firstSwingStartTime;
        stepTransitionsToPack.clear();
        for (int i = 0; i < Math.min(footstepList.size(), stepsToConsider); ++i) {
            Footstep step = footstepList.get(i);
            FootstepTiming stepTiming = footstepTimingList.get(i);
            BipedStepTransition liftOffTransition = (BipedStepTransition)stepTransitionsToPack.add();
            liftOffTransition.reset();
            liftOffTransition.setTransitionTime(transitionTime);
            liftOffTransition.addTransition(BipedStepTransitionType.LIFT_OFF, step.getRobotSide(), (FramePose3DReadOnly)step.getFootstepPose());
            BipedStepTransition touchDownTransition = (BipedStepTransition)stepTransitionsToPack.add();
            touchDownTransition.reset();
            touchDownTransition.setTransitionTime(transitionTime += stepTiming.getSwingTime());
            touchDownTransition.addTransition(BipedStepTransitionType.TOUCH_DOWN, step.getRobotSide(), (FramePose3DReadOnly)step.getFootstepPose());
            transitionTime += stepTiming.getTransferTime();
        }
        stepTransitionsToPack.sort(Comparator.comparingDouble(BipedStepTransition::getTransitionTime));
        BipedContactSequenceTools.collapseTransitionEvents(stepTransitionsToPack);
        stepTransitionsToPack.removeIf(transition -> transition.getTransitionTime() <= currentTime);
    }

    public static void computeStepTransitionsFromStepSequence(RecyclingArrayList<BipedStepTransition> stepTransitionsToPack, double currentTime, List<? extends BipedTimedStep> stepSequence, int stepsToConsider) {
        stepTransitionsToPack.clear();
        for (int i = 0; i < Math.min(stepSequence.size(), stepsToConsider); ++i) {
            BipedStepTransition stepTransition;
            BipedTimedStep step = stepSequence.get(i);
            if (step.getTimeInterval().getStartTime() >= currentTime) {
                stepTransition = (BipedStepTransition)stepTransitionsToPack.add();
                stepTransition.reset();
                stepTransition.setTransitionTime(step.getTimeInterval().getStartTime());
                stepTransition.addTransition(BipedStepTransitionType.LIFT_OFF, step.getRobotSide(), step.getGoalPose());
            }
            if (!(step.getTimeInterval().getEndTime() >= currentTime)) continue;
            stepTransition = (BipedStepTransition)stepTransitionsToPack.add();
            stepTransition.reset();
            stepTransition.setTransitionTime(step.getTimeInterval().getEndTime());
            stepTransition.addTransition(BipedStepTransitionType.TOUCH_DOWN, step.getRobotSide(), step.getGoalPose());
        }
        stepTransitionsToPack.sort(Comparator.comparingDouble(BipedStepTransition::getTransitionTime));
        BipedContactSequenceTools.collapseTransitionEvents(stepTransitionsToPack);
        stepTransitionsToPack.removeIf(transition -> transition.getTransitionTime() < currentTime);
    }

    public static void trimPastContactSequences(RecyclingArrayList<SimpleBipedContactPhase> contactSequenceToPack, double currentTime, List<RobotSide> currentFeetInContact, SideDependentList<? extends FramePose3DReadOnly> currentSolePoses) {
        TimeIntervalTools.removeStartTimesGreaterThanOrEqualTo((double)currentTime, contactSequenceToPack);
        TimeIntervalTools.removeEndTimesLessThan((double)currentTime, contactSequenceToPack);
        if (contactSequenceToPack.isEmpty()) {
            BipedContactSequenceTools.addCurrentStateAsAContactPhase(contactSequenceToPack, currentFeetInContact, currentSolePoses, currentTime);
        } else {
            for (int i = 0; i < contactSequenceToPack.size(); ++i) {
                SimpleBipedContactPhase contactPhase = (SimpleBipedContactPhase)contactSequenceToPack.get(i);
                if (BipedContactSequenceTools.isEqualContactState(contactPhase.getFeetInContact(), currentFeetInContact)) {
                    contactPhase.resetEnd();
                    contactPhase.setStartFootPoses(currentSolePoses);
                    continue;
                }
                contactSequenceToPack.remove(i);
                BipedContactSequenceTools.addCurrentStateAsAContactPhase(contactSequenceToPack, currentFeetInContact, currentSolePoses, currentTime);
            }
        }
    }

    public static void addCurrentStateAsAContactPhase(RecyclingArrayList<SimpleBipedContactPhase> contactSequenceToPack, List<RobotSide> currentFeetInContact, SideDependentList<? extends FramePose3DReadOnly> solePoses, double currentTime) {
        SimpleBipedContactPhase contactPhase = (SimpleBipedContactPhase)contactSequenceToPack.add();
        contactPhase.reset();
        contactPhase.setFeetInContact(currentFeetInContact);
        for (int i = 0; i < currentFeetInContact.size(); ++i) {
            contactPhase.addStartFoot(currentFeetInContact.get(i), (FramePose3DReadOnly)solePoses.get((Enum)currentFeetInContact.get(i)));
        }
        contactPhase.getTimeInterval().setStartTime(currentTime);
        contactPhase.update();
    }

    public static boolean isEqualContactState(List<RobotSide> contactStateA, List<RobotSide> contactStateB) {
        if (contactStateA.size() != contactStateB.size()) {
            return false;
        }
        for (int i = 0; i < contactStateA.size(); ++i) {
            if (contactStateB.contains(contactStateA.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void shiftContactSequencesToRelativeTime(List<SimpleBipedContactPhase> contactSequenceToPack, double currentAbsoluteTime) {
        double shiftTime = -currentAbsoluteTime;
        for (int sequence = 0; sequence < contactSequenceToPack.size(); ++sequence) {
            contactSequenceToPack.get(sequence).getTimeInterval().shiftInterval(shiftTime);
        }
    }
}

