/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedContactSequenceUpdater;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.BipedTimedStep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanner;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerInterface;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BipedCoMTrajectoryPlanner {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BipedContactSequenceUpdater sequenceUpdater;
    private final CoMTrajectoryPlannerInterface comTrajectoryPlanner;
    private final YoDouble timeInContactPhase = new YoDouble("timeInContactPhase", this.registry);
    private final List<BipedTimedStep> stepSequence = new ArrayList<BipedTimedStep>();

    public BipedCoMTrajectoryPlanner(SideDependentList<MovingReferenceFrame> soleFrames, double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.sequenceUpdater = new BipedContactSequenceUpdater(soleFrames, this.registry, yoGraphicsListRegistry);
        this.comTrajectoryPlanner = new CoMTrajectoryPlanner(gravityZ, nominalCoMHeight, this.registry);
        ((CoMTrajectoryPlanner)this.comTrajectoryPlanner).setCornerPointViewer(new CornerPointViewer(this.registry, yoGraphicsListRegistry));
        parentRegistry.addChild(this.registry);
    }

    public void clearStepSequence() {
        this.stepSequence.clear();
    }

    public void addStepToSequence(BipedTimedStep step) {
        this.stepSequence.add(step);
    }

    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.comTrajectoryPlanner.setInitialCenterOfMassState(centerOfMassPosition, centerOfMassVelocity);
    }

    public void initialize() {
        this.sequenceUpdater.initialize();
    }

    void computeSetpoints(double currentTime, List<RobotSide> currentFeetInContact) {
        this.sequenceUpdater.update(this.stepSequence, currentFeetInContact, currentTime);
        double timeInPhase = currentTime - this.sequenceUpdater.getAbsoluteContactSequence().get(0).getTimeInterval().getStartTime();
        this.timeInContactPhase.set(timeInPhase);
        this.comTrajectoryPlanner.solveForTrajectory(this.sequenceUpdater.getContactSequence());
        this.comTrajectoryPlanner.compute(this.timeInContactPhase.getDoubleValue());
    }

    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.comTrajectoryPlanner.getDesiredDCMPosition();
    }

    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.comTrajectoryPlanner.getDesiredDCMVelocity();
    }

    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.comTrajectoryPlanner.getDesiredCoMPosition();
    }

    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.comTrajectoryPlanner.getDesiredCoMVelocity();
    }

    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.comTrajectoryPlanner.getDesiredCoMAcceleration();
    }

    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.comTrajectoryPlanner.getDesiredVRPPosition();
    }
}

