/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator;

import java.util.Arrays;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredTurningVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameVector2d;
import us.ihmc.robotics.math.filters.RateLimitedYoVariable;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class HeadingAndVelocityEvaluationScript
implements Updatable {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoFrameVector2D desiredVelocity = new YoFrameVector2D("scriptedDesiredVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final RateLimitedYoFrameVector2d desiredVelocityRateLimited;
    private final YoDouble desiredTurningVelocity = new YoDouble("scriptedDesiredTurningVelocity", this.registry);
    private final RateLimitedYoVariable desiredTurningVelocityRateLimited;
    private final YoDouble acceleration = new YoDouble("acceleration", this.registry);
    private final YoDouble maxVelocity = new YoDouble("maxVelocity", this.registry);
    private final YoDouble maxTurningVelocity = new YoDouble("maxTurningVelocity", this.registry);
    private final YoDouble turningAcceleration = new YoDouble("turningAcceleration", this.registry);
    private final YoDouble cruiseVelocity = new YoDouble("cruiseVelocity", this.registry);
    private final YoDouble sidestepVelocity = new YoDouble("sidestepVelocity", this.registry);
    private final YoEnum<EvaluationEvent> currentScriptEvent = new YoEnum("currentScriptEvent", this.registry, EvaluationEvent.class);
    private final Vector2D desiredVelocityDirection = new Vector2D(1.0, 0.0);
    private final StateExecutor taskExecutor;
    private final List<EventTask> eventList;

    public HeadingAndVelocityEvaluationScript(double controlDT, DoubleProvider timeProvider, HeadingAndVelocityEvaluationScriptParameters parameters, YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        if (parameters == null) {
            parameters = new HeadingAndVelocityEvaluationScriptParameters();
        }
        this.taskExecutor = new StateExecutor(StateMachineClock.yoClock((DoubleProvider)timeProvider, (String)"headingAndVelocity", (YoRegistry)this.registry));
        this.acceleration.set(parameters.getAcceleration());
        this.maxVelocity.set(parameters.getMaxVelocity());
        this.maxTurningVelocity.set(10.0 * parameters.getMaxHeadingDot());
        this.turningAcceleration.set(0.75);
        this.cruiseVelocity.set(parameters.getCruiseVelocity());
        this.sidestepVelocity.set(parameters.getSideStepVelocity());
        this.desiredVelocityRateLimited = RateLimitedYoFrameVector2d.createRateLimitedYoFrameVector2d((String)"scriptDesiredVelocityRateLimited", (String)"", (YoRegistry)this.registry, (DoubleProvider)this.acceleration, (double)controlDT, (YoFrameVector2D)this.desiredVelocity);
        this.desiredTurningVelocityRateLimited = new RateLimitedYoVariable("scriptDesiredTurningVelocityRateLimited", this.registry, (DoubleProvider)this.turningAcceleration, this.desiredTurningVelocity, controlDT);
        this.eventList = this.createCompleteEventList();
    }

    private List<EventTask> createCompleteEventList() {
        return Arrays.asList(this.createStepInPlace(), this.createGoToCruiseVelocity(), this.createTurn180Cruise(), this.createSpeedUpToMaxStraight(), this.createSlowDownToZero(), this.createSidestepLeft(), this.createSlowDownToZero(), this.createSidestepRight(), this.createSlowDownToZero(), this.createTurnInPlace180(), this.createDiagonallyRight45(), this.createSlowDownToZero(), this.createDiagonallyLeft45(), this.createSlowDownToZero(), this.createWaveCruise(), this.createSlowDownToZero(), this.createTurnInPlace180(), this.createChangeHeadingWalkingStraight(), this.createSlowDownToZero());
    }

    public DesiredVelocityProvider getDesiredVelocityProvider() {
        return () -> this.desiredVelocityRateLimited;
    }

    public DesiredTurningVelocityProvider getDesiredTurningVelocityProvider() {
        return () -> this.desiredTurningVelocityRateLimited.getValue();
    }

    @Override
    public void update(double time) {
        if (this.taskExecutor.isDone()) {
            this.eventList.forEach(arg_0 -> ((StateExecutor)this.taskExecutor).submit(arg_0));
        }
        this.taskExecutor.doControl();
        this.desiredVelocityRateLimited.update();
        this.desiredTurningVelocityRateLimited.update();
    }

    private EventTask createConstantVelocityEvent(EvaluationEvent evaluationEvent, final Vector2DReadOnly velocityDirection, final double velocityMagnitude, final double turningVelocity) {
        return new EventTask(evaluationEvent){

            @Override
            public void onEntry() {
                super.onEntry();
                HeadingAndVelocityEvaluationScript.this.desiredVelocityDirection.setAndNormalize(velocityDirection);
                HeadingAndVelocityEvaluationScript.this.desiredVelocity.setAndScale(velocityMagnitude, (Tuple2DReadOnly)HeadingAndVelocityEvaluationScript.this.desiredVelocityDirection);
                HeadingAndVelocityEvaluationScript.this.desiredTurningVelocity.set(turningVelocity);
            }

            public void doAction(double timeInState) {
            }
        };
    }

    private EventTask createStepInPlace() {
        return this.createConstantVelocityEvent(EvaluationEvent.STEP_IN_PLACE, (Vector2DReadOnly)new Vector2D(1.0, 0.0), 0.0, 0.0);
    }

    private EventTask createSpeedUpToMaxStraight() {
        return this.createConstantVelocityEvent(EvaluationEvent.SPEED_UP_TO_MAX_STRAIGHT, (Vector2DReadOnly)new Vector2D(1.0, 0.0), this.maxVelocity.getValue(), 0.0);
    }

    private EventTask createGoToCruiseVelocity() {
        return this.createConstantVelocityEvent(EvaluationEvent.GO_TO_CRUISE_STRAIGHT, (Vector2DReadOnly)new Vector2D(1.0, 0.0), this.cruiseVelocity.getValue(), 0.0);
    }

    private EventTask createTurn180Cruise() {
        return this.createConstantVelocityEvent(EvaluationEvent.TURN_180_CRUISE, (Vector2DReadOnly)new Vector2D(1.0, 0.0), this.cruiseVelocity.getValue(), 0.4 * this.maxTurningVelocity.getValue());
    }

    private EventTask createSlowDownToZero() {
        return new EventTask(EvaluationEvent.SLOW_DOWN_TO_ZERO){
            private double initialTurningVelocity;

            @Override
            public void onEntry() {
                super.onEntry();
                this.initialTurningVelocity = HeadingAndVelocityEvaluationScript.this.desiredTurningVelocity.getValue();
            }

            public void doAction(double timeInState) {
                HeadingAndVelocityEvaluationScript.this.desiredVelocity.setToZero();
                double alpha = MathTools.clamp((double)(timeInState / this.minEventDuration), (double)0.0, (double)1.0);
                HeadingAndVelocityEvaluationScript.this.desiredTurningVelocity.set(EuclidCoreTools.interpolate((double)this.initialTurningVelocity, (double)0.0, (double)alpha));
            }
        };
    }

    private EventTask createSidestepLeft() {
        return this.createConstantVelocityEvent(EvaluationEvent.SIDE_STEP_LEFT, (Vector2DReadOnly)new Vector2D(0.0, 1.0), this.cruiseVelocity.getValue(), 0.0);
    }

    private EventTask createSidestepRight() {
        return this.createConstantVelocityEvent(EvaluationEvent.SIDE_STEP_RIGHT, (Vector2DReadOnly)new Vector2D(0.0, -1.0), this.cruiseVelocity.getValue(), 0.0);
    }

    private EventTask createTurnInPlace180() {
        return this.createConstantVelocityEvent(EvaluationEvent.TURN_IN_PLACE180, (Vector2DReadOnly)new Vector2D(1.0, 0.0), 0.0, this.maxTurningVelocity.getValue());
    }

    private EventTask createDiagonallyLeft45() {
        return this.createConstantVelocityEvent(EvaluationEvent.DIAGONALLY_LEFT_45, (Vector2DReadOnly)new Vector2D(1.0, 1.0), this.sidestepVelocity.getValue(), 0.0);
    }

    private EventTask createDiagonallyRight45() {
        return this.createConstantVelocityEvent(EvaluationEvent.DIAGONALLY_RIGHT_45, (Vector2DReadOnly)new Vector2D(1.0, -1.0), this.sidestepVelocity.getValue(), 0.0);
    }

    private EventTask createWaveCruise() {
        return new EventTask(EvaluationEvent.WAVE_CRUISE){
            double freq;
            double amplitude;
            {
                this.freq = 0.2;
                this.amplitude = 0.7853981633974483;
            }

            public void doAction(double timeInState) {
                HeadingAndVelocityEvaluationScript.this.desiredVelocity.setAndScale(HeadingAndVelocityEvaluationScript.this.cruiseVelocity.getValue(), (Tuple2DReadOnly)new Vector2D(1.0, 0.0));
                HeadingAndVelocityEvaluationScript.this.desiredTurningVelocity.set(Math.PI * 2 * this.freq * this.amplitude * Math.cos(Math.PI * 2 * this.freq * timeInState));
            }
        };
    }

    private EventTask createChangeHeadingWalkingStraight() {
        return new EventTask(EvaluationEvent.CHANGE_HEADING_WALKING_STRAIGHT){
            double freq;
            double amplitude;
            {
                this.freq = 0.1;
                this.amplitude = 0.7853981633974483;
            }

            public void doAction(double timeInState) {
                HeadingAndVelocityEvaluationScript.this.desiredVelocity.setAndScale(HeadingAndVelocityEvaluationScript.this.cruiseVelocity.getValue(), (Tuple2DReadOnly)new Vector2D(1.0, 0.0));
                HeadingAndVelocityEvaluationScript.this.desiredTurningVelocity.set(Math.PI * 2 * this.freq * this.amplitude * Math.cos(Math.PI * 2 * this.freq * timeInState));
            }
        };
    }

    public static enum EvaluationEvent {
        STEP_IN_PLACE(5.0),
        GO_TO_CRUISE_STRAIGHT(6.0),
        TURN_180_CRUISE(8.0),
        SPEED_UP_TO_MAX_STRAIGHT(4.0),
        SLOW_DOWN_TO_ZERO(4.0),
        SIDE_STEP_LEFT(5.0),
        SIDE_STEP_RIGHT(5.0),
        TURN_IN_PLACE180(8.0),
        DIAGONALLY_RIGHT_45(6.0),
        DIAGONALLY_LEFT_45(6.0),
        WAVE_CRUISE(12.0),
        CHANGE_HEADING_WALKING_STRAIGHT(12.0);

        private final double minTime;

        private EvaluationEvent(double minTime) {
            this.minTime = minTime;
        }

        public double getMinEventDuration() {
            return this.minTime;
        }
    }

    private abstract class EventTask
    implements State {
        private final EvaluationEvent evaluationEvent;
        protected final double minEventDuration;

        public EventTask(EvaluationEvent evaluationEvent) {
            this.evaluationEvent = evaluationEvent;
            this.minEventDuration = evaluationEvent.getMinEventDuration();
        }

        public void onEntry() {
            HeadingAndVelocityEvaluationScript.this.currentScriptEvent.set((Enum)this.evaluationEvent);
        }

        public void onExit() {
        }

        public boolean isDone(double timeInState) {
            return timeInState + 1.0E-7 > this.minEventDuration;
        }
    }
}

