/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class FootstepTestHelper {
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final SideDependentList<? extends ContactablePlaneBody> contactableFeet;

    public FootstepTestHelper(SideDependentList<? extends ContactablePlaneBody> contactableFeet) {
        this.contactableFeet = contactableFeet;
    }

    public List<Footstep> createFootsteps(double stepWidth, double stepLength, int numberOfSteps) {
        ArrayList<Footstep> footsteps = new ArrayList<Footstep>();
        RobotSide currentSide = RobotSide.LEFT;
        FramePoint3D lastFootstepPosition = new FramePoint3D(((ContactablePlaneBody)this.contactableFeet.get((Enum)currentSide)).getSoleFrame());
        lastFootstepPosition.changeFrame(this.worldFrame);
        for (int i = 0; i < numberOfSteps; ++i) {
            currentSide = currentSide.getOppositeSide();
            double x = lastFootstepPosition.getX();
            if (i < numberOfSteps - 1) {
                x += stepLength;
            }
            double y = lastFootstepPosition.getY() + currentSide.negateIfRightSide(stepWidth);
            Footstep footstep = this.createFootstep(currentSide, x, y);
            footstep.getPosition(lastFootstepPosition);
            lastFootstepPosition.changeFrame(this.worldFrame);
            footsteps.add(footstep);
        }
        return footsteps;
    }

    private Footstep createFootstep(RobotSide robotSide, double x, double y) {
        return this.createFootstep(robotSide, new Point3D(x, y, 0.0), new Quaternion(0.0, 0.0, 0.0, 1.0));
    }

    public Footstep createFootstep(RobotSide robotSide, Point3D position, Quaternion orientation) {
        FramePose3D footstepPose = new FramePose3D();
        footstepPose.set((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        return this.createFootstep(robotSide, footstepPose);
    }

    public Footstep createFootstep(RobotSide robotSide, FramePose3D footstepPose) {
        RigidBodyBasics foot = ((ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide)).getRigidBody();
        Footstep ret = new Footstep(robotSide, footstepPose);
        ret.setPredictedContactPoints(((ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide)).getContactPoints2d());
        return ret;
    }

    public List<Footstep> convertToFootsteps(FootstepDataListMessage footstepDataListMessage) {
        ArrayList<Footstep> ret = new ArrayList<Footstep>();
        for (int i = 0; i < footstepDataListMessage.getFootstepDataList().size(); ++i) {
            ret.add(this.convertToFootstep((FootstepDataMessage)footstepDataListMessage.getFootstepDataList().get(i)));
        }
        return ret;
    }

    public Footstep convertToFootstep(FootstepDataMessage footstepDataMessage) {
        RobotSide robotSide = RobotSide.fromByte((byte)footstepDataMessage.getRobotSide());
        RigidBodyBasics foot = ((ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide)).getRigidBody();
        FramePose3D solePose = new FramePose3D(this.worldFrame, (Tuple3DReadOnly)footstepDataMessage.getLocation(), (Orientation3DReadOnly)footstepDataMessage.getOrientation());
        Footstep footstep = new Footstep(robotSide, solePose);
        if (footstepDataMessage.getPredictedContactPoints2d() != null && !footstepDataMessage.getPredictedContactPoints2d().isEmpty()) {
            footstep.setPredictedContactPoints(HumanoidMessageTools.unpackPredictedContactPoints((FootstepDataMessage)footstepDataMessage));
        } else {
            footstep.setPredictedContactPoints(((ContactablePlaneBody)this.contactableFeet.get((Enum)robotSide)).getContactPoints2d());
        }
        return footstep;
    }
}

