/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootstepVisualizer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int maxNumberOfContactPoints = 6;
    private final YoFramePose3D yoFootstepPose;
    private final YoFrameConvexPolygon2D yoFoothold;
    private final ConvexPolygon2D foothold = new ConvexPolygon2D();
    private final RobotSide robotSide;
    private final List<Point2D> defaultContactPointsInSoleFrame = new ArrayList<Point2D>();
    private final YoGraphicCoordinateSystem poseViz;
    private final YoGraphicPolygon footholdViz;

    public FootstepVisualizer(String name, String graphicListName, RobotSide robotSide, ContactablePlaneBody contactableFoot, AppearanceDefinition footstepColor, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        this(name, graphicListName, robotSide, contactableFoot.getContactPoints2d(), footstepColor, yoGraphicsListRegistry, registry);
    }

    public FootstepVisualizer(String name, String graphicListName, RobotSide robotSide, List<? extends Point2DReadOnly> footPolygon, AppearanceDefinition footstepColor, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        this.robotSide = robotSide;
        this.yoFootstepPose = new YoFramePose3D(name + "Pose", worldFrame, registry);
        this.yoFoothold = new YoFrameConvexPolygon2D(name + "Foothold", "", worldFrame, 6, registry);
        double coordinateSystemSize = 0.2;
        double footholdScale = 1.0;
        this.poseViz = new YoGraphicCoordinateSystem(name + "Pose", this.yoFootstepPose, coordinateSystemSize, footstepColor);
        this.footholdViz = new YoGraphicPolygon(name + "Foothold", this.yoFoothold, this.yoFootstepPose, footholdScale, footstepColor);
        yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)this.poseViz);
        yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)this.footholdViz);
        for (int i = 0; i < footPolygon.size(); ++i) {
            this.defaultContactPointsInSoleFrame.add(new Point2D((Tuple2DReadOnly)footPolygon.get(i)));
        }
    }

    public void update(Footstep footstep) {
        FramePose3D footstepPose = footstep.getFootstepPose();
        List predictedContactPoints = footstep.getPredictedContactPoints();
        this.update((FramePose3DReadOnly)footstepPose, predictedContactPoints);
    }

    public void update(FramePose3DReadOnly footstepPose) {
        this.update(footstepPose, null);
    }

    public void update(FramePose3DReadOnly footstepPose, List<? extends Point2DReadOnly> predictedContactPoints) {
        this.yoFootstepPose.setMatchingFrame((FrameTuple3DReadOnly)footstepPose.getPosition(), (FrameOrientation3DReadOnly)footstepPose.getOrientation());
        List<Object> contactPointsToVisualize = predictedContactPoints == null || predictedContactPoints.isEmpty() ? this.defaultContactPointsInSoleFrame : predictedContactPoints;
        this.foothold.clear();
        for (int i = 0; i < contactPointsToVisualize.size(); ++i) {
            this.foothold.addVertex((Point2DReadOnly)contactPointsToVisualize.get(i));
        }
        this.foothold.update();
        this.yoFoothold.set((Vertex2DSupplier)this.foothold);
        this.poseViz.update();
        this.footholdViz.update();
    }

    public void hide() {
        this.yoFootstepPose.setToNaN();
    }

    public RobotSide getRobotSide() {
        return this.robotSide;
    }

    public static List<Point2D> createRectangularFootPolygon(double footWidth, double footLength) {
        return FootstepVisualizer.createTrapezoidalFootPolygon(footWidth, footWidth, footLength);
    }

    public static List<Point2D> createTrapezoidalFootPolygon(double toeWidth, double heelWidth, double footLength) {
        ArrayList<Point2D> contactPoints = new ArrayList<Point2D>();
        contactPoints.add(new Point2D(-footLength / 2.0, -heelWidth / 2.0));
        contactPoints.add(new Point2D(-footLength / 2.0, heelWidth / 2.0));
        contactPoints.add(new Point2D(footLength / 2.0, -toeWidth / 2.0));
        contactPoints.add(new Point2D(footLength / 2.0, toeWidth / 2.0));
        return contactPoints;
    }
}

