/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.contactable.ContactablePlaneBody;

public class DesiredFootstepCalculatorTools {
    public static double computeMinZPointWithRespectToAnkleInWorldFrame(RotationMatrix footToWorldRotation, ContactablePlaneBody contactableBody) {
        List footPoints = contactableBody.getContactPointsCopy();
        double minZ = Double.POSITIVE_INFINITY;
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        Vector3D tempVector = new Vector3D();
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame((ReferenceFrame)contactableBody.getFrameAfterParentJoint());
            tempVector.set((Tuple3DReadOnly)tempFramePoint);
            footToWorldRotation.transform((Tuple3DBasics)tempVector);
            if (!(tempVector.getZ() < minZ)) continue;
            minZ = tempVector.getZ();
        }
        return minZ;
    }

    public static double computeMinZPointWithRespectToSoleInWorldFrame(RotationMatrix footToWorldRotation, ContactablePlaneBody contactableBody) {
        List footPoints = contactableBody.getContactPointsCopy();
        double minZ = Double.POSITIVE_INFINITY;
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        Vector3D tempVector = new Vector3D();
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame(contactableBody.getSoleFrame());
            tempVector.set((Tuple3DReadOnly)tempFramePoint);
            footToWorldRotation.transform((Tuple3DBasics)tempVector);
            if (!(tempVector.getZ() < minZ)) continue;
            minZ = tempVector.getZ();
        }
        return minZ;
    }

    public static FramePoint3D computeMinZWithRespectToAnkleInWorldFramePoint(RotationMatrix footToWorldRotation, ContactablePlaneBody contactableBody) {
        List footPoints = contactableBody.getContactPointsCopy();
        double minZ = Double.POSITIVE_INFINITY;
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        FramePoint3D minZPoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        Vector3D tempVector = new Vector3D();
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame((ReferenceFrame)contactableBody.getFrameAfterParentJoint());
            tempVector.set((Tuple3DReadOnly)tempFramePoint);
            footToWorldRotation.transform((Tuple3DBasics)tempVector);
            if (!(tempVector.getZ() < minZ)) continue;
            minZPoint.setIncludingFrame((FrameTuple3DReadOnly)tempFramePoint);
            minZ = tempVector.getZ();
        }
        return minZPoint;
    }

    public static double computeMaxXWithRespectToAnkleInFrame(RotationMatrix footToWorldRotation, ContactablePlaneBody contactableBody, ReferenceFrame frame) {
        RigidBodyTransform worldToDesiredHeadingFrame = frame.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        List footPoints = contactableBody.getContactPointsCopy();
        double maxX = Double.NEGATIVE_INFINITY;
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        Vector3D tempVector = new Vector3D();
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame((ReferenceFrame)contactableBody.getFrameAfterParentJoint());
            tempVector.set((Tuple3DReadOnly)tempFramePoint);
            footToWorldRotation.transform((Tuple3DBasics)tempVector);
            worldToDesiredHeadingFrame.transform((Vector3DBasics)tempVector);
            if (!(tempVector.getX() > maxX)) continue;
            maxX = tempVector.getX();
        }
        return maxX;
    }

    public static FramePoint3D computeMinZPointInFrame(RigidBodyTransform footToWorldTransform, ContactablePlaneBody contactableBody, ReferenceFrame frame) {
        List footPoints = contactableBody.getContactPointsCopy();
        MovingReferenceFrame bodyFrame = contactableBody.getFrameAfterParentJoint();
        return DesiredFootstepCalculatorTools.computeMinZPointInFrame(footToWorldTransform, footPoints, (ReferenceFrame)bodyFrame, frame);
    }

    public static FramePoint3D computeMinZPointInFrame(RigidBodyTransform footToWorldTransform, List<FramePoint3D> footPoints, ReferenceFrame bodyFrame, ReferenceFrame frame) {
        FramePoint3D minFramePoint = new FramePoint3D(frame);
        minFramePoint.setZ(Double.POSITIVE_INFINITY);
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        boolean pointFound = false;
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame(bodyFrame);
            tempFramePoint.applyTransform((Transform)footToWorldTransform);
            tempFramePoint.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)tempFramePoint);
            tempFramePoint.changeFrame(frame);
            if (!(tempFramePoint.getZ() < minFramePoint.getZ())) continue;
            minFramePoint.set(tempFramePoint);
            pointFound = true;
        }
        if (!pointFound) {
            throw new RuntimeException();
        }
        return minFramePoint;
    }

    public static FramePoint3D computeMaxXPointInFrame(RigidBodyTransform footToWorldTransform, ContactablePlaneBody contactableBody, ReferenceFrame frame) {
        List footPoints = contactableBody.getContactPointsCopy();
        FramePoint3D maxFramePoint = new FramePoint3D(frame);
        maxFramePoint.setX(Double.NEGATIVE_INFINITY);
        FramePoint3D tempFramePoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
        boolean pointFound = false;
        for (FramePoint3D footPoint : footPoints) {
            tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)footPoint);
            tempFramePoint.changeFrame((ReferenceFrame)contactableBody.getFrameAfterParentJoint());
            tempFramePoint.applyTransform((Transform)footToWorldTransform);
            tempFramePoint.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)tempFramePoint);
            tempFramePoint.changeFrame(frame);
            if (!(tempFramePoint.getX() > maxFramePoint.getX())) continue;
            maxFramePoint.set(tempFramePoint);
            pointFound = true;
        }
        if (!pointFound) {
            throw new RuntimeException();
        }
        return maxFramePoint;
    }

    public static List<FramePoint3D> computeMaximumPointsInDirection(List<FramePoint3D> framePoints, FrameVector3D searchDirection, int nPoints) {
        if (framePoints.size() < nPoints) {
            throw new RuntimeException("Not enough points");
        }
        searchDirection.changeFrame(framePoints.get(0).getReferenceFrame());
        ArrayList<FramePoint3D> ret = new ArrayList<FramePoint3D>(framePoints);
        Collections.sort(ret, new SearchDirectionFramePointComparator(searchDirection));
        while (ret.size() > nPoints) {
            ret.remove(0);
        }
        return ret;
    }

    public static List<Point2D> computeMaximumPointsInDirection(List<Point2D> framePoints, Vector2D searchDirection, int nPoints) {
        if (framePoints.size() < nPoints) {
            throw new RuntimeException("Not enough points");
        }
        ArrayList<Point2D> ret = new ArrayList<Point2D>(framePoints);
        Collections.sort(ret, new SearchDirectionPoint2dComparator(searchDirection));
        while (ret.size() > nPoints) {
            ret.remove(0);
        }
        return ret;
    }

    public static int[] findMaximumPointIndexesInDirection(List<FramePoint3D> framePoints, FrameVector3D searchDirection, int nPoints) {
        List<FramePoint3D> maximumPoints = DesiredFootstepCalculatorTools.computeMaximumPointsInDirection(framePoints, searchDirection, nPoints);
        int[] indexes = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            indexes[i] = framePoints.indexOf(maximumPoints.get(i));
        }
        return indexes;
    }

    private static class SearchDirectionFramePointComparator
    implements Comparator<FramePoint3D> {
        private final FrameVector3D searchDirection;
        private final FrameVector3D differenceVector = new FrameVector3D(ReferenceFrame.getWorldFrame());

        public SearchDirectionFramePointComparator(FrameVector3D searchDirection) {
            this.searchDirection = searchDirection;
        }

        @Override
        public int compare(FramePoint3D o1, FramePoint3D o2) {
            this.differenceVector.setIncludingFrame((FrameTuple3DReadOnly)o1);
            this.differenceVector.sub((FrameTuple3DReadOnly)o2);
            double dotProduct = this.searchDirection.dot((FrameVector3DReadOnly)this.differenceVector);
            return Double.compare(dotProduct, 0.0);
        }
    }

    private static class SearchDirectionPoint2dComparator
    implements Comparator<Point2D> {
        private final Vector2D searchDirection;
        private final Vector2D differenceVector = new Vector2D();

        public SearchDirectionPoint2dComparator(Vector2D searchDirection) {
            this.searchDirection = searchDirection;
        }

        @Override
        public int compare(Point2D o1, Point2D o2) {
            this.differenceVector.set((Tuple2DReadOnly)o1);
            this.differenceVector.sub((Tuple2DReadOnly)o2);
            double dotProduct = this.searchDirection.dot((Vector2DReadOnly)this.differenceVector);
            return Double.compare(dotProduct, 0.0);
        }
    }
}

