/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.corruptors;

import java.util.ArrayList;
import us.ihmc.commons.FormattingTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.RobotSpecificJointNames;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class FullRobotModelCorruptor {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ArrayList<YoVariableChangedListener> variableChangedListeners = new ArrayList();

    public FullRobotModelCorruptor(FullHumanoidRobotModel fullRobotModel, YoRegistry parentRegistry) {
        this("", fullRobotModel, parentRegistry);
    }

    public FullRobotModelCorruptor(String namePrefix, FullHumanoidRobotModel fullRobotModel, YoRegistry parentRegistry) {
        for (RigidBodyBasics rigidBody : fullRobotModel.getPelvis().subtreeIterable()) {
            this.createMassAndCoMOffsetCorruptors(namePrefix, rigidBody.getName(), rigidBody);
        }
        RobotSpecificJointNames robotSpecificJointNames = fullRobotModel.getRobotSpecificJointNames();
        LegJointName[] legJointNames = robotSpecificJointNames.getLegJointNames();
        ArmJointName[] armJointNames = robotSpecificJointNames.getArmJointNames();
        SpineJointName[] spineJointNames = robotSpecificJointNames.getSpineJointNames();
        for (RobotSide robotSide : RobotSide.values) {
            OneDoFJointBasics oneDoFJoint;
            for (LegJointName legJointName : legJointNames) {
                oneDoFJoint = fullRobotModel.getLegJoint((Enum)robotSide, legJointName);
                this.createJointAngleCorruptor(namePrefix, oneDoFJoint.getName(), oneDoFJoint);
            }
            for (LegJointName legJointName : armJointNames) {
                oneDoFJoint = fullRobotModel.getArmJoint(robotSide, (ArmJointName)legJointName);
                this.createJointAngleCorruptor(namePrefix, oneDoFJoint.getName(), oneDoFJoint);
            }
        }
        for (RobotSide robotSide : spineJointNames) {
            OneDoFJointBasics oneDoFJoint = fullRobotModel.getSpineJoint((SpineJointName)robotSide);
            this.createJointAngleCorruptor(namePrefix, oneDoFJoint.getName(), oneDoFJoint);
        }
        parentRegistry.addChild(this.registry);
    }

    private void createJointAngleCorruptor(String namePrefix, String name, OneDoFJointBasics oneDoFJoint) {
    }

    private void createMassAndCoMOffsetCorruptors(String namePrefix, String name, final RigidBodyBasics rigidBody) {
        if (rigidBody == null) {
            return;
        }
        name = FormattingTools.addPrefixAndKeepCamelCase((String)namePrefix, (String)name);
        final YoDouble massVariable = new YoDouble(name + "Mass", this.registry);
        final YoVector3D momentOfInertiaDiagonal = new YoVector3D(name + "MoIDiagonal", this.registry);
        Matrix3DBasics momentOfInertia = rigidBody.getInertia().getMomentOfInertia();
        momentOfInertiaDiagonal.set(momentOfInertia.getM00(), momentOfInertia.getM11(), momentOfInertia.getM22());
        massVariable.set(rigidBody.getInertia().getMass());
        YoVariableChangedListener massVariableChangedListener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                rigidBody.getInertia().setMass(massVariable.getDoubleValue());
            }
        };
        YoVariableChangedListener moiListener = new YoVariableChangedListener(){

            public void changed(YoVariable source) {
                rigidBody.getInertia().getMomentOfInertia().setM00(momentOfInertiaDiagonal.getX());
                rigidBody.getInertia().getMomentOfInertia().setM11(momentOfInertiaDiagonal.getY());
                rigidBody.getInertia().getMomentOfInertia().setM22(momentOfInertiaDiagonal.getZ());
            }
        };
        massVariable.addListener(massVariableChangedListener);
        this.variableChangedListeners.add(massVariableChangedListener);
        momentOfInertiaDiagonal.attachVariableChangedListener(moiListener);
        this.variableChangedListeners.add(moiListener);
        FramePoint3D originalCoMOffset = new FramePoint3D();
        rigidBody.getCenterOfMass((FramePoint3DBasics)originalCoMOffset);
        final YoFramePoint3D rigidBodyCoMOffset = new YoFramePoint3D(name + "CoMOffset", (ReferenceFrame)rigidBody.getParentJoint().getFrameAfterJoint(), this.registry);
        rigidBodyCoMOffset.setMatchingFrame((FrameTuple3DReadOnly)originalCoMOffset);
        YoVariableChangedListener rigidBodyCoMOffsetChangedListener = new YoVariableChangedListener(){
            private final FramePoint3D tempFramePoint = new FramePoint3D();

            public void changed(YoVariable v) {
                this.tempFramePoint.setIncludingFrame((FrameTuple3DReadOnly)rigidBodyCoMOffset);
                this.tempFramePoint.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
                rigidBody.setCenterOfMass((FramePoint3DReadOnly)this.tempFramePoint);
            }
        };
        rigidBodyCoMOffset.attachVariableChangedListener(rigidBodyCoMOffsetChangedListener);
        this.variableChangedListeners.add(rigidBodyCoMOffsetChangedListener);
    }

    public void corruptFullRobotModel() {
        for (YoVariableChangedListener variableChangedListener : this.variableChangedListeners) {
            variableChangedListener.changed(null);
        }
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }
}

