/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.parameters;

import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointVelocityIntegratorResetMode;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointAccelerationIntegrationCalculator;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.EnumParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class TunableJointAccelerationIntegrationParameters
implements JointAccelerationIntegrationParametersReadOnly {
    private static final String POSITION_BREAK_FREQUENCY_NAME = "PositionBreakFrequency";
    private static final String VELOCITY_BREAK_FREQUENCY_NAME = "VelocityBreakFrequency";
    private static final String POSITION_INTEGRATION_MAX_ERROR_NAME = "PositionIntegrationMaxError";
    private static final String VELOCITY_INTEGRATION_MAX_ERROR_NAME = "VelocityIntegrationMaxError";
    private static final String VELOCITY_REFERENCE_ALPHA_NAME = "VelocityReferenceAlpha";
    private static final String VELOCITY_RESET_MODE_NAME = "VelocityResetMode";
    private static final double SUGGESTED_MAXIMUM_POSITION_ERROR = Math.PI * 2;
    private static final double SUGGESTED_MAXIMUM_VELOCITY = 62.83185307179586;
    private static final double SUGGESTED_MAXIMUM_FREQUENCY = 5.0;
    private final DoubleParameter positionBreakFrequency;
    private final DoubleParameter velocityBreakFrequency;
    private final DoubleParameter maxPositionError;
    private final DoubleParameter maxVelocityError;
    private final DoubleParameter velocityReferenceAlpha;
    private final EnumParameter<JointVelocityIntegratorResetMode> velocityResetMode;

    public TunableJointAccelerationIntegrationParameters(String namePrefix, YoRegistry registry) {
        this(namePrefix, 0.016, 2.04, 0.2, 2.0, 0.0, JointAccelerationIntegrationCalculator.DEFAULT_VELOCITY_RESET_MODE, registry);
    }

    public TunableJointAccelerationIntegrationParameters(String namePrefix, YoRegistry registry, JointAccelerationIntegrationParametersReadOnly defaults) {
        this(namePrefix, defaults.getPositionBreakFrequency(), defaults.getVelocityBreakFrequency(), defaults.getMaxPositionError(), defaults.getMaxVelocityError(), defaults.getVelocityReferenceAlpha(), defaults.getVelocityResetMode(), registry);
    }

    public TunableJointAccelerationIntegrationParameters(String namePrefix, double positionBreakFrequency, double velocityBreakFrequency, double maxPositionError, double maxVelocityError, double velocityReferenceAlpha, JointVelocityIntegratorResetMode velocityResetMode, YoRegistry registry) {
        this.positionBreakFrequency = new DoubleParameter(namePrefix + POSITION_BREAK_FREQUENCY_NAME, registry, positionBreakFrequency, 0.0, 5.0);
        this.velocityBreakFrequency = new DoubleParameter(namePrefix + VELOCITY_BREAK_FREQUENCY_NAME, registry, velocityBreakFrequency, 0.0, 5.0);
        this.maxPositionError = new DoubleParameter(namePrefix + POSITION_INTEGRATION_MAX_ERROR_NAME, registry, maxPositionError, 0.0, Math.PI * 2);
        this.maxVelocityError = new DoubleParameter(namePrefix + VELOCITY_INTEGRATION_MAX_ERROR_NAME, registry, maxVelocityError, 0.0, 62.83185307179586);
        this.velocityReferenceAlpha = new DoubleParameter(namePrefix + VELOCITY_REFERENCE_ALPHA_NAME, registry, velocityReferenceAlpha, 0.0, 1.0);
        this.velocityResetMode = new EnumParameter(namePrefix + VELOCITY_RESET_MODE_NAME, registry, JointVelocityIntegratorResetMode.class, true, (Enum)velocityResetMode);
    }

    @Override
    public double getPositionBreakFrequency() {
        return this.positionBreakFrequency.getValue();
    }

    @Override
    public double getVelocityBreakFrequency() {
        return this.velocityBreakFrequency.getValue();
    }

    @Override
    public double getMaxPositionError() {
        return this.maxPositionError.getValue();
    }

    @Override
    public double getMaxVelocityError() {
        return this.maxVelocityError.getValue();
    }

    @Override
    public double getVelocityReferenceAlpha() {
        return this.velocityReferenceAlpha.getValue();
    }

    @Override
    public JointVelocityIntegratorResetMode getVelocityResetMode() {
        return (JointVelocityIntegratorResetMode)this.velocityResetMode.getValue();
    }
}

