/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.parameters;

import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointVelocityIntegratorResetMode;
import us.ihmc.euclid.interfaces.Settable;

public class JointAccelerationIntegrationParameters
implements JointAccelerationIntegrationParametersReadOnly,
Settable<JointAccelerationIntegrationParameters> {
    private double positionBreakFrequency;
    private double velocityBreakFrequency;
    private double maxPositionError;
    private double maxVelocityError;
    private double velocityReferenceAlpha;
    private JointVelocityIntegratorResetMode velocityResetMode;

    public JointAccelerationIntegrationParameters() {
        this.reset();
    }

    public void reset() {
        this.resetAlphas();
        this.resetMaxima();
        this.velocityResetMode = null;
    }

    public void resetAlphas() {
        this.positionBreakFrequency = Double.NaN;
        this.velocityBreakFrequency = Double.NaN;
        this.velocityReferenceAlpha = 0.0;
    }

    public void resetMaxima() {
        this.maxPositionError = Double.NaN;
        this.maxVelocityError = Double.NaN;
    }

    public void set(JointAccelerationIntegrationParameters other) {
        this.set((JointAccelerationIntegrationParametersReadOnly)other);
    }

    public void set(JointAccelerationIntegrationParametersReadOnly other) {
        this.positionBreakFrequency = other.getPositionBreakFrequency();
        this.velocityBreakFrequency = other.getVelocityBreakFrequency();
        this.maxPositionError = other.getMaxPositionError();
        this.maxVelocityError = other.getMaxVelocityError();
        this.velocityReferenceAlpha = other.getVelocityReferenceAlpha();
        this.velocityResetMode = other.getVelocityResetMode();
    }

    public void setBreakFrequencies(double positionBreakFrequency, double velocityBreakFrequency) {
        this.positionBreakFrequency = positionBreakFrequency;
        this.velocityBreakFrequency = velocityBreakFrequency;
    }

    public void setMaxima(double maxPositionError, double maxVelocityError) {
        this.maxPositionError = maxPositionError;
        this.maxVelocityError = maxVelocityError;
    }

    public void setPositionBreakFrequency(double positionBreakFrequency) {
        this.positionBreakFrequency = positionBreakFrequency;
    }

    public void setVelocityBreakFrequency(double velocityBreakFrequency) {
        this.velocityBreakFrequency = velocityBreakFrequency;
    }

    public void setVelocityResetMode(JointVelocityIntegratorResetMode velocityResetMode) {
        this.velocityResetMode = velocityResetMode;
    }

    public void setMaxPositionError(double maxPositionError) {
        this.maxPositionError = maxPositionError;
    }

    public void setMaxVelocityError(double maxVelocityError) {
        this.maxVelocityError = maxVelocityError;
    }

    public void setVelocityReferenceAlpha(double velocityReferenceAlpha) {
        this.velocityReferenceAlpha = velocityReferenceAlpha;
    }

    @Override
    public JointVelocityIntegratorResetMode getVelocityResetMode() {
        return this.velocityResetMode;
    }

    @Override
    public double getPositionBreakFrequency() {
        return this.positionBreakFrequency;
    }

    @Override
    public double getVelocityBreakFrequency() {
        return this.velocityBreakFrequency;
    }

    @Override
    public double getMaxPositionError() {
        return this.maxPositionError;
    }

    @Override
    public double getMaxVelocityError() {
        return this.maxVelocityError;
    }

    @Override
    public double getVelocityReferenceAlpha() {
        return this.velocityReferenceAlpha;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointAccelerationIntegrationParametersReadOnly) {
            JointAccelerationIntegrationParametersReadOnly other = (JointAccelerationIntegrationParametersReadOnly)object;
            if (this.positionBreakFrequency != other.getPositionBreakFrequency()) {
                return false;
            }
            if (this.velocityBreakFrequency != other.getVelocityBreakFrequency()) {
                return false;
            }
            if (this.maxPositionError != other.getMaxPositionError()) {
                return false;
            }
            if (this.maxVelocityError != other.getMaxVelocityError()) {
                return false;
            }
            if (this.velocityReferenceAlpha != other.getVelocityReferenceAlpha()) {
                return false;
            }
            return this.velocityResetMode == other.getVelocityResetMode();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": position break frequency: " + this.positionBreakFrequency + ", velocity break frequency: " + this.velocityBreakFrequency + ", max position error: " + this.maxPositionError + ", maxVelocityError: " + this.maxVelocityError + ", velocityReferenceAlpha: " + this.velocityReferenceAlpha + ", velocityResetMode: " + (Object)((Object)this.velocityResetMode);
    }
}

