/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.data;

import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FeedbackControllerData;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.robotics.dataStructures.YoMutableFrameSpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.providers.BooleanProvider;

public class FBRateLimitedVector6D
extends YoMutableFrameSpatialVector
implements FeedbackControllerData {
    private final SpaceData6D space;
    private final FBRateLimitedVector3D angularPart;
    private final FBRateLimitedVector3D linearPart;

    public FBRateLimitedVector6D(FBRateLimitedVector3D angularPart, FBRateLimitedVector3D linearPart) {
        super((YoMutableFrameVector3D)angularPart, (YoMutableFrameVector3D)linearPart);
        if (angularPart.getSpace().getSpaceData6D() != linearPart.getSpace().getSpaceData6D()) {
            throw new FeedbackControllerException("Space mismatch: angular part " + (Object)((Object)angularPart.getSpace()) + ", linear part " + (Object)((Object)linearPart.getSpace()));
        }
        if (angularPart.getType() != linearPart.getType()) {
            throw new FeedbackControllerException("Type mismatch: angular part " + (Object)((Object)angularPart.getType()) + ", linear part " + (Object)((Object)linearPart.getType()));
        }
        this.space = angularPart.getSpace().getSpaceData6D();
        this.angularPart = angularPart;
        this.linearPart = linearPart;
    }

    public void reset() {
        this.angularPart.reset();
        this.linearPart.reset();
    }

    public void update() {
        this.angularPart.update();
        this.linearPart.update();
    }

    @Override
    public void addActiveFlag(BooleanProvider activeFlag) {
        this.angularPart.addActiveFlag(activeFlag);
        this.linearPart.addActiveFlag(activeFlag);
    }

    public void setCommandId(int commandId) {
        this.angularPart.setCommandId(commandId);
        this.linearPart.setCommandId(commandId);
    }

    @Override
    public boolean isActive() {
        return this.angularPart.isActive() || this.linearPart.isActive();
    }

    @Override
    public boolean clearIfInactive() {
        if (!this.isActive()) {
            this.angularPart.clearIfInactive();
            this.linearPart.clearIfInactive();
        }
        return false;
    }

    public SpaceData6D getSpace() {
        return this.space;
    }

    public Type getType() {
        return this.angularPart.getType();
    }

    @Override
    public int getCommandId() {
        return this.angularPart.getCommandId();
    }
}

