/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;

public class VirtualModelControlCommandList
implements VirtualModelControlCommand<VirtualModelControlCommandList> {
    private int commandId;
    private final List<VirtualModelControlCommand<?>> commandList = new ArrayList();

    public void addCommand(VirtualModelControlCommand<?> command) {
        if (command != null) {
            if (command instanceof VirtualModelControlCommandList) {
                this.addCommandList((VirtualModelControlCommandList)command);
            } else {
                this.commandList.add(command);
            }
        }
    }

    public void addCommandList(VirtualModelControlCommandList commandList) {
        if (commandList == null) {
            return;
        }
        for (int i = 0; i < commandList.getNumberOfCommands(); ++i) {
            this.addCommand(commandList.getCommand(i));
        }
    }

    public void clear() {
        this.commandId = 0;
        this.commandList.clear();
    }

    public VirtualModelControlCommand<?> getCommand(int commandIndex) {
        return this.commandList.get(commandIndex);
    }

    public VirtualModelControlCommand<?> pollCommand() {
        if (this.commandList.isEmpty()) {
            return null;
        }
        return this.commandList.remove(this.getNumberOfCommands() - 1);
    }

    public int getNumberOfCommands() {
        return this.commandList.size();
    }

    public boolean isCommandEmpty() {
        return this.commandList.isEmpty();
    }

    public void set(VirtualModelControlCommandList other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfCommands(); ++i) {
            this.addCommand(other.getCommand(i));
        }
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.COMMAND_LIST;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof VirtualModelControlCommandList) {
            VirtualModelControlCommandList other = (VirtualModelControlCommandList)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfCommands() != other.getNumberOfCommands()) {
                return false;
            }
            for (int commandIndex = 0; commandIndex < this.getNumberOfCommands(); ++commandIndex) {
                if (this.getCommand(commandIndex).equals(other.getCommand(commandIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "Nb of commands: " + this.getNumberOfCommands() + "\n" + this.commandList;
    }
}

