/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.lists.DenseMatrixArrayList;

public class JointTorqueCommand
implements VirtualModelControlCommand<JointTorqueCommand> {
    private static final int initialCapacity = 15;
    private int commandId;
    private final List<JointBasics> joints = new ArrayList<JointBasics>(15);
    private final DenseMatrixArrayList desiredTorques = new DenseMatrixArrayList(15);

    public JointTorqueCommand() {
        this.clear();
    }

    public void set(JointTorqueCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJoints(); ++i) {
            this.joints.add(other.joints.get(i));
        }
        this.desiredTorques.set(other.desiredTorques);
    }

    public void clear() {
        this.commandId = 0;
        this.joints.clear();
        this.desiredTorques.clear();
    }

    public void addJoint(OneDoFJointBasics joint, double desiredTorque) {
        this.joints.add((JointBasics)joint);
        DMatrixRMaj jointDesiredTorque = (DMatrixRMaj)this.desiredTorques.add();
        jointDesiredTorque.reshape(1, 1);
        jointDesiredTorque.set(0, 0, desiredTorque);
    }

    public void addJoint(JointBasics joint, DMatrixRMaj desiredTorque) {
        this.checkConsistency(joint, desiredTorque);
        this.joints.add(joint);
        ((DMatrixRMaj)this.desiredTorques.add()).set((DMatrixD1)desiredTorque);
    }

    public void setOneDoFJointDesiredTorque(int jointIndex, double desiredTorque) {
        MathTools.checkEquals((int)this.joints.get(jointIndex).getDegreesOfFreedom(), (int)1);
        ((DMatrixRMaj)this.desiredTorques.get(jointIndex)).reshape(1, 1);
        ((DMatrixRMaj)this.desiredTorques.get(jointIndex)).set(0, 0, desiredTorque);
    }

    public void setDesiredTorque(int jointIndex, DMatrixRMaj desiredTorque) {
        this.checkConsistency(this.joints.get(jointIndex), desiredTorque);
        ((DMatrixRMaj)this.desiredTorques.get(jointIndex)).set((DMatrixD1)desiredTorque);
    }

    private void checkConsistency(JointBasics joint, DMatrixRMaj desiredTorque) {
        MathTools.checkEquals((int)joint.getDegreesOfFreedom(), (int)desiredTorque.getNumRows());
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public List<JointBasics> getJoints() {
        return this.joints;
    }

    public JointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public DMatrixRMaj getDesiredTorque(int jointIndex) {
        return (DMatrixRMaj)this.desiredTorques.get(jointIndex);
    }

    public DenseMatrixArrayList getDesiredTorques() {
        return this.desiredTorques;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINTSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointTorqueCommand) {
            JointTorqueCommand other = (JointTorqueCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) == other.joints.get(jointIndex)) continue;
                return false;
            }
            return this.desiredTorques.equals((Object)other.desiredTorques);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        for (int i = 0; i < this.joints.size(); ++i) {
            ret = ret + this.joints.get(i).getName();
            ret = i < this.joints.size() - 1 ? ret + ", " : ret + ".";
        }
        return ret;
    }
}

