/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.kinematics.JointLimitData;

public class JointLimitEnforcementCommand
implements VirtualModelControlCommand<JointLimitEnforcementCommand> {
    private int commandId;
    private final List<OneDoFJointBasics> joints;
    private final RecyclingArrayList<JointLimitData> jointLimitData;

    public JointLimitEnforcementCommand() {
        this(40);
    }

    public JointLimitEnforcementCommand(int initialCapacity) {
        this.joints = new ArrayList<OneDoFJointBasics>(initialCapacity);
        this.jointLimitData = new RecyclingArrayList(initialCapacity, JointLimitData.class);
    }

    public void clear() {
        this.commandId = 0;
        this.joints.clear();
        for (int i = 0; i < this.jointLimitData.size(); ++i) {
            ((JointLimitData)this.jointLimitData.get(i)).clear();
        }
        this.jointLimitData.clear();
    }

    public void set(JointLimitEnforcementCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJoints(); ++i) {
            this.joints.add(other.joints.get(i));
            ((JointLimitData)this.jointLimitData.add()).set((JointLimitData)other.jointLimitData.get(i));
        }
    }

    public void addJoint(OneDoFJointBasics joint, JointLimitData jointLimitData) {
        this.joints.add(joint);
        ((JointLimitData)this.jointLimitData.add()).set(jointLimitData);
    }

    public void addJoint(OneDoFJointBasics joint, double stiffness, double damping) {
        this.joints.add(joint);
        JointLimitData jointLimitData = (JointLimitData)this.jointLimitData.add();
        jointLimitData.setJointLimits(joint);
        jointLimitData.setPositionLimitStiffness(stiffness);
        jointLimitData.setPositionLimitDamping(damping);
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public OneDoFJointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public JointLimitData getJointLimitData(int jointIndex) {
        return (JointLimitData)this.jointLimitData.get(jointIndex);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINT_LIMIT_ENFORCEMENT;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointLimitEnforcementCommand) {
            JointLimitEnforcementCommand other = (JointLimitEnforcementCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) == other.joints.get(jointIndex)) continue;
                return false;
            }
            return this.jointLimitData.equals(other.jointLimitData);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ":";
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ret = ret + "\nJoint: " + this.joints.get(jointIndex).getName() + ", " + ((JointLimitData)this.jointLimitData.get(jointIndex)).toString();
        }
        return ret;
    }
}

