/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataBasics;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRootJointDesiredConfigurationData
implements RootJointDesiredConfigurationDataBasics {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoFrameQuaternion orientation;
    private final YoFramePoint3D position;
    private final YoFrameVector3D linearVelocity;
    private final YoFrameVector3D angularVelocity;
    private final YoFrameVector3D linearAcceleration;
    private final YoFrameVector3D angularAcceleration;
    private final DMatrixRMaj desiredConfiguration = new DMatrixRMaj(7, 0);
    private final DMatrixRMaj desiredVelocity = new DMatrixRMaj(6, 0);
    private final DMatrixRMaj desiredAcceleration = new DMatrixRMaj(6, 0);

    public YoRootJointDesiredConfigurationData(FloatingJointBasics rootJoint, YoRegistry parentRegistry) {
        YoRegistry registry = new YoRegistry("RootJointDesiredConfigurationData");
        parentRegistry.addChild(registry);
        MovingReferenceFrame frameAfterJoint = rootJoint.getFrameAfterJoint();
        String namePrefix = "rootJointLowLevel";
        this.orientation = new YoFrameQuaternion(namePrefix + "DesiredOrientation", worldFrame, registry);
        this.position = new YoFramePoint3D(namePrefix + "DesiredPosition", worldFrame, registry);
        this.linearVelocity = new YoFrameVector3D(namePrefix + "DesiredLinearVelocity", (ReferenceFrame)frameAfterJoint, registry);
        this.angularVelocity = new YoFrameVector3D(namePrefix + "DesiredAngularVelocity", (ReferenceFrame)frameAfterJoint, registry);
        this.linearAcceleration = new YoFrameVector3D(namePrefix + "DesiredLinearAcceleration", (ReferenceFrame)frameAfterJoint, registry);
        this.angularAcceleration = new YoFrameVector3D(namePrefix + "DesiredAngularAcceleration", (ReferenceFrame)frameAfterJoint, registry);
        this.clear();
    }

    @Override
    public void clear() {
        this.clearConfiguration();
        this.clearVelocity();
        this.clearAcceleration();
    }

    private void clearConfiguration() {
        this.orientation.setToNaN();
        this.position.setToNaN();
    }

    private void clearVelocity() {
        this.linearVelocity.setToNaN();
        this.angularVelocity.setToNaN();
    }

    private void clearAcceleration() {
        this.linearAcceleration.setToNaN();
        this.angularAcceleration.setToNaN();
    }

    @Override
    public void set(RootJointDesiredConfigurationDataReadOnly other) {
        this.setConfiguration(other);
        this.setVelocity(other);
        this.setAcceleration(other);
    }

    @Override
    public void completeWith(RootJointDesiredConfigurationDataReadOnly other) {
        if (!this.hasDesiredConfiguration()) {
            this.setConfiguration(other);
        }
        if (!this.hasDesiredVelocity()) {
            this.setVelocity(other);
        }
        if (!this.hasDesiredAcceleration()) {
            this.setAcceleration(other);
        }
    }

    private void setConfiguration(RootJointDesiredConfigurationDataReadOnly other) {
        if (!other.hasDesiredConfiguration()) {
            this.clearConfiguration();
            return;
        }
        this.setDesiredConfiguration(other.getDesiredConfiguration());
    }

    private void setVelocity(RootJointDesiredConfigurationDataReadOnly other) {
        if (!other.hasDesiredVelocity()) {
            this.clearVelocity();
            return;
        }
        this.setDesiredVelocity(other.getDesiredVelocity());
    }

    private void setAcceleration(RootJointDesiredConfigurationDataReadOnly other) {
        if (!other.hasDesiredAcceleration()) {
            this.clearAcceleration();
            return;
        }
        this.setDesiredAcceleration(other.getDesiredAcceleration());
    }

    @Override
    public void setDesiredAccelerationFromJoint(FloatingJointBasics sixDoFJoint) {
        this.desiredAcceleration.reshape(6, 1);
        sixDoFJoint.getJointAcceleration(0, (DMatrix)this.desiredAcceleration);
        this.setDesiredAcceleration(this.desiredAcceleration);
    }

    @Override
    public void setDesiredConfiguration(FrameQuaternionReadOnly orientation, FramePoint3DReadOnly position) {
        this.orientation.set(orientation);
        this.position.set((FrameTuple3DReadOnly)position);
    }

    @Override
    public void setDesiredVelocity(FrameVector3DReadOnly angularVelocity, FrameVector3DReadOnly linearVelocity) {
        this.angularVelocity.set((FrameTuple3DReadOnly)angularVelocity);
        this.linearVelocity.set((FrameTuple3DReadOnly)linearVelocity);
    }

    @Override
    public void setDesiredAcceleration(FrameVector3DReadOnly angularAcceleration, FrameVector3DReadOnly linearAcceleration) {
        this.angularAcceleration.set((FrameTuple3DReadOnly)angularAcceleration);
        this.linearAcceleration.set((FrameTuple3DReadOnly)linearAcceleration);
    }

    @Override
    public void setDesiredConfiguration(DMatrixRMaj q, int startIndex) {
        this.orientation.set(startIndex, (DMatrix)q);
        this.position.set(startIndex + 4, (DMatrix)q);
    }

    @Override
    public void setDesiredVelocity(DMatrixRMaj qd, int startIndex) {
        this.angularVelocity.set(startIndex, (DMatrix)qd);
        this.linearVelocity.set(startIndex + 3, (DMatrix)qd);
    }

    @Override
    public void setDesiredAcceleration(DMatrixRMaj qdd, int startIndex) {
        this.angularAcceleration.set(startIndex, (DMatrix)qdd);
        this.linearAcceleration.set(startIndex + 3, (DMatrix)qdd);
    }

    @Override
    public boolean hasDesiredConfiguration() {
        return !this.orientation.containsNaN() && !this.position.containsNaN();
    }

    @Override
    public boolean hasDesiredVelocity() {
        return !this.angularVelocity.containsNaN() && !this.linearVelocity.containsNaN();
    }

    @Override
    public boolean hasDesiredAcceleration() {
        return !this.angularAcceleration.containsNaN() && !this.linearAcceleration.containsNaN();
    }

    @Override
    public DMatrixRMaj getDesiredConfiguration() {
        if (!this.hasDesiredConfiguration()) {
            this.desiredConfiguration.reshape(0, 0);
            return this.desiredConfiguration;
        }
        this.desiredConfiguration.reshape(7, 1);
        this.orientation.get(0, (DMatrix)this.desiredConfiguration);
        this.position.get(4, (DMatrix)this.desiredConfiguration);
        return this.desiredConfiguration;
    }

    @Override
    public DMatrixRMaj getDesiredVelocity() {
        if (!this.hasDesiredVelocity()) {
            this.desiredVelocity.reshape(0, 0);
            return this.desiredVelocity;
        }
        this.desiredVelocity.reshape(6, 1);
        this.angularVelocity.get(0, (DMatrix)this.desiredVelocity);
        this.linearVelocity.get(3, (DMatrix)this.desiredVelocity);
        return this.desiredVelocity;
    }

    @Override
    public DMatrixRMaj getDesiredAcceleration() {
        if (!this.hasDesiredAcceleration()) {
            this.desiredAcceleration.reshape(0, 0);
            return this.desiredAcceleration;
        }
        this.desiredAcceleration.reshape(6, 1);
        this.angularAcceleration.get(0, (DMatrix)this.desiredAcceleration);
        this.linearAcceleration.get(3, (DMatrix)this.desiredAcceleration);
        return this.desiredAcceleration;
    }
}

