/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataBasics;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;

public class RootJointDesiredConfigurationData
implements RootJointDesiredConfigurationDataReadOnly,
RootJointDesiredConfigurationDataBasics {
    private final DMatrixRMaj desiredConfiguration = new DMatrixRMaj(7, 0);
    private final DMatrixRMaj desiredVelocity = new DMatrixRMaj(6, 0);
    private final DMatrixRMaj desiredAcceleration = new DMatrixRMaj(6, 0);

    public RootJointDesiredConfigurationData() {
        this.clear();
    }

    @Override
    public void clear() {
        this.desiredConfiguration.reshape(0, 0);
        this.desiredVelocity.reshape(0, 0);
        this.desiredAcceleration.reshape(0, 0);
    }

    public void set(RootJointDesiredConfigurationData other) {
        RootJointDesiredConfigurationDataBasics.super.set(other);
    }

    @Override
    public void completeWith(RootJointDesiredConfigurationDataReadOnly other) {
        if (!this.hasDesiredConfiguration()) {
            this.desiredConfiguration.set((DMatrixD1)other.getDesiredConfiguration());
        }
        if (!this.hasDesiredVelocity()) {
            this.desiredVelocity.set((DMatrixD1)other.getDesiredVelocity());
        }
        if (!this.hasDesiredAcceleration()) {
            this.desiredAcceleration.set((DMatrixD1)other.getDesiredAcceleration());
        }
    }

    @Override
    public void setDesiredAccelerationFromJoint(FloatingJointBasics sixDoFJoint) {
        this.desiredAcceleration.reshape(6, 1);
        sixDoFJoint.getJointAcceleration(0, (DMatrix)this.desiredAcceleration);
    }

    @Override
    public void setDesiredConfiguration(FrameQuaternionReadOnly orientation, FramePoint3DReadOnly position) {
        this.desiredConfiguration.reshape(7, 1);
        orientation.get(0, (DMatrix)this.desiredConfiguration);
        position.get(4, (DMatrix)this.desiredConfiguration);
    }

    @Override
    public void setDesiredVelocity(FrameVector3DReadOnly angularVelocity, FrameVector3DReadOnly linearVelocity) {
        this.desiredVelocity.reshape(6, 1);
        angularVelocity.get(0, (DMatrix)this.desiredVelocity);
        linearVelocity.get(3, (DMatrix)this.desiredVelocity);
    }

    @Override
    public void setDesiredAcceleration(FrameVector3DReadOnly angularAcceleration, FrameVector3DReadOnly linearAcceleration) {
        this.desiredAcceleration.reshape(6, 1);
        angularAcceleration.get(0, (DMatrix)this.desiredAcceleration);
        linearAcceleration.get(3, (DMatrix)this.desiredAcceleration);
    }

    @Override
    public void setDesiredConfiguration(DMatrixRMaj q, int startIndex) {
        this.desiredConfiguration.reshape(7, 1);
        CommonOps_DDRM.extract((DMatrix)q, (int)startIndex, (int)(startIndex + 7), (int)0, (int)1, (DMatrix)this.desiredConfiguration, (int)0, (int)0);
    }

    @Override
    public void setDesiredVelocity(DMatrixRMaj qd, int startIndex) {
        this.desiredVelocity.reshape(6, 1);
        CommonOps_DDRM.extract((DMatrix)qd, (int)startIndex, (int)(startIndex + 6), (int)0, (int)1, (DMatrix)this.desiredVelocity, (int)0, (int)0);
    }

    @Override
    public void setDesiredAcceleration(DMatrixRMaj qdd, int startIndex) {
        this.desiredAcceleration.reshape(6, 1);
        CommonOps_DDRM.extract((DMatrix)qdd, (int)startIndex, (int)(startIndex + 6), (int)0, (int)1, (DMatrix)this.desiredAcceleration, (int)0, (int)0);
    }

    @Override
    public boolean hasDesiredConfiguration() {
        return this.desiredConfiguration.getNumRows() != 0;
    }

    @Override
    public boolean hasDesiredVelocity() {
        return this.desiredVelocity.getNumRows() != 0;
    }

    @Override
    public boolean hasDesiredAcceleration() {
        return this.desiredAcceleration.getNumRows() != 0;
    }

    @Override
    public DMatrixRMaj getDesiredConfiguration() {
        return this.desiredConfiguration;
    }

    @Override
    public DMatrixRMaj getDesiredVelocity() {
        return this.desiredVelocity;
    }

    @Override
    public DMatrixRMaj getDesiredAcceleration() {
        return this.desiredAcceleration;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RootJointDesiredConfigurationData) {
            RootJointDesiredConfigurationData other = (RootJointDesiredConfigurationData)obj;
            if (!MatrixTools.equals((DMatrix1Row)this.desiredConfiguration, (DMatrix1Row)other.desiredConfiguration)) {
                return false;
            }
            if (!MatrixTools.equals((DMatrix1Row)this.desiredVelocity, (DMatrix1Row)other.desiredVelocity)) {
                return false;
            }
            return MatrixTools.equals((DMatrix1Row)this.desiredAcceleration, (DMatrix1Row)other.desiredAcceleration);
        }
        return false;
    }
}

