/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class SpatialVelocityCommand
implements InverseKinematicsCommand<SpatialVelocityCommand> {
    private int commandId;
    private final FramePose3D controlFramePose = new FramePose3D();
    private final Vector3D desiredLinearVelocity = new Vector3D();
    private final Vector3D desiredAngularVelocity = new Vector3D();
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private ConstraintType constraintType = ConstraintType.OBJECTIVE;
    private RigidBodyBasics base;
    private RigidBodyBasics endEffector;
    private RigidBodyBasics optionalPrimaryBase;
    private boolean scaleSecondaryTaskJointWeight = false;
    private double secondaryTaskJointWeightScale = 1.0;

    public SpatialVelocityCommand() {
        this.setAsHardEqualityConstraint();
    }

    public void set(SpatialVelocityCommand other) {
        this.commandId = other.commandId;
        this.controlFramePose.setIncludingFrame((FramePose3DReadOnly)other.controlFramePose);
        this.desiredLinearVelocity.set(other.desiredLinearVelocity);
        this.desiredAngularVelocity.set(other.desiredAngularVelocity);
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
        this.constraintType = other.constraintType;
        this.base = other.getBase();
        this.endEffector = other.getEndEffector();
        this.optionalPrimaryBase = other.optionalPrimaryBase;
        this.scaleSecondaryTaskJointWeight = other.scaleSecondaryTaskJointWeight;
        this.secondaryTaskJointWeightScale = other.secondaryTaskJointWeightScale;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public void setProperties(SpatialAccelerationCommand command) {
        this.commandId = command.getCommandId();
        this.setWeightMatrix(command.getWeightMatrix());
        command.getSelectionMatrix(this.selectionMatrix);
        this.base = command.getBase();
        this.endEffector = command.getEndEffector();
        this.optionalPrimaryBase = command.getPrimaryBase();
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.base = base;
        this.endEffector = endEffector;
    }

    public void setPrimaryBase(RigidBodyBasics primaryBase) {
        this.optionalPrimaryBase = primaryBase;
    }

    public void setScaleSecondaryTaskJointWeight(boolean scaleSecondaryTaskJointWeight, double secondaryTaskJointWeightScale) {
        this.scaleSecondaryTaskJointWeight = scaleSecondaryTaskJointWeight;
        this.secondaryTaskJointWeightScale = secondaryTaskJointWeightScale;
    }

    public void setSpatialVelocityToZero(ReferenceFrame controlFrame) {
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularVelocity.setToZero();
        this.desiredLinearVelocity.setToZero();
    }

    public void setSpatialVelocity(ReferenceFrame controlFrame, TwistReadOnly desiredSpatialVelocity) {
        desiredSpatialVelocity.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        desiredSpatialVelocity.getBaseFrame().checkReferenceFrameMatch((ReferenceFrame)this.base.getBodyFixedFrame());
        desiredSpatialVelocity.getReferenceFrame().checkReferenceFrameMatch(controlFrame);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularVelocity.set((Tuple3DReadOnly)desiredSpatialVelocity.getAngularPart());
        this.desiredLinearVelocity.set((Tuple3DReadOnly)desiredSpatialVelocity.getLinearPart());
    }

    public void setSpatialVelocity(ReferenceFrame controlFrame, FrameVector3D desiredAngularVelocity, FrameVector3D desiredLinearVelocity) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularVelocity);
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearVelocity);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularVelocity.set((Tuple3DReadOnly)desiredAngularVelocity);
        this.desiredLinearVelocity.set((Tuple3DReadOnly)desiredLinearVelocity);
    }

    public void setAngularVelocity(ReferenceFrame controlFrame, FrameVector3D desiredAngularVelocity) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularVelocity);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularVelocity.set((Tuple3DReadOnly)desiredAngularVelocity);
        this.desiredLinearVelocity.setToZero();
    }

    public void setLinearVelocity(ReferenceFrame controlFrame, FrameVector3D desiredLinearVelocity) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearVelocity);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredLinearVelocity.set((Tuple3DReadOnly)desiredLinearVelocity);
        this.desiredAngularVelocity.setToZero();
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixForLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
    }

    public void setSelectionMatrixForLinearControl(SelectionMatrix3D linearSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setLinearPart(linearSelectionMatrix);
    }

    public void setSelectionMatrixForAngularControl() {
        this.selectionMatrix.setToAngularSelectionOnly();
    }

    public void setSelectionMatrixForAngularControl(SelectionMatrix3D angularSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setAngularPart(angularSelectionMatrix);
    }

    public void setSelectionMatrixForPlanarControl() {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.selectAngularY(true);
        this.selectionMatrix.selectLinearX(true);
        this.selectionMatrix.selectLinearZ(true);
    }

    public void setSelectionMatrixForPlanarLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
        this.selectionMatrix.selectLinearY(false);
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public void setAsHardEqualityConstraint() {
        this.constraintType = ConstraintType.EQUALITY;
        this.weightMatrix.setLinearWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.weightMatrix.setAngularWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setAsLessOrEqualInequalityConstraint() {
        this.constraintType = ConstraintType.LEQ_INEQUALITY;
        this.weightMatrix.setLinearWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.weightMatrix.setAngularWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setAsGreaterOrEqualInequalityConstraint() {
        this.constraintType = ConstraintType.GEQ_INEQUALITY;
        this.weightMatrix.setLinearWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.weightMatrix.setAngularWeights(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setWeight(double weight) {
        this.setWeight(weight, weight);
    }

    public void setWeight(double angular, double linear) {
        if (angular == Double.POSITIVE_INFINITY || linear == Double.POSITIVE_INFINITY) {
            this.setAsHardEqualityConstraint();
        } else {
            this.constraintType = ConstraintType.OBJECTIVE;
            this.weightMatrix.setLinearWeights(linear, linear, linear);
            this.weightMatrix.setAngularWeights(angular, angular, angular);
        }
    }

    public void setWeightMatrix(WeightMatrix6D weightMatrix) {
        if (weightMatrix.containsHardConstraint()) {
            this.setAsHardEqualityConstraint();
        } else {
            this.constraintType = ConstraintType.OBJECTIVE;
            this.weightMatrix.set(weightMatrix);
        }
    }

    public void setAngularWeights(Tuple3DReadOnly angular) {
        this.constraintType = ConstraintType.OBJECTIVE;
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
        if (this.weightMatrix.getAngularPart().containsHardConstraint()) {
            this.setAsHardEqualityConstraint();
        }
    }

    public void setLinearWeights(Tuple3DReadOnly linear) {
        this.constraintType = ConstraintType.OBJECTIVE;
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
        if (this.weightMatrix.getLinearPart().containsHardConstraint()) {
            this.setAsHardEqualityConstraint();
        }
    }

    public void setWeights(Tuple3DReadOnly angular, Tuple3DReadOnly linear) {
        this.constraintType = ConstraintType.OBJECTIVE;
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
        if (this.weightMatrix.containsHardConstraint()) {
            this.setAsHardEqualityConstraint();
        }
    }

    public void setAngularWeightsToZero() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
    }

    public void setLinearWeightsToZero() {
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public void getWeightMatrix(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        this.weightMatrix.getFullWeightMatrixInFrame(destinationFrame, weightMatrixToPack);
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public void getWeightMatrix(WeightMatrix6D weightMatrixToPack) {
        weightMatrixToPack.set(this.weightMatrix);
    }

    public Vector3DBasics getDesiredLinearVelocity() {
        return this.desiredLinearVelocity;
    }

    public Vector3DBasics getDesiredAngularVelocity() {
        return this.desiredAngularVelocity;
    }

    public void getDesiredSpatialVelocity(PoseReferenceFrame controlFrameToPack, Twist desiredSpatialVelocityToPack) {
        this.getControlFrame(controlFrameToPack);
        desiredSpatialVelocityToPack.setIncludingFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame(), (ReferenceFrame)this.base.getBodyFixedFrame(), (ReferenceFrame)controlFrameToPack, (Vector3DReadOnly)this.desiredAngularVelocity, (Vector3DReadOnly)this.desiredLinearVelocity);
    }

    public void getDesiredSpatialVelocity(DMatrixRMaj desiredSpatialVelocityToPack) {
        desiredSpatialVelocityToPack.reshape(6, 1);
        this.desiredAngularVelocity.get(0, (DMatrix)desiredSpatialVelocityToPack);
        this.desiredLinearVelocity.get(3, (DMatrix)desiredSpatialVelocityToPack);
    }

    public FramePose3DBasics getControlFramePose() {
        return this.controlFramePose;
    }

    public void getControlFrame(PoseReferenceFrame controlFrameToPack) {
        this.controlFramePose.changeFrame(controlFrameToPack.getParent());
        controlFrameToPack.setPoseAndUpdate((FramePose3DReadOnly)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void getControlFramePoseIncludingFrame(FramePose3D controlFramePoseToPack) {
        controlFramePoseToPack.setIncludingFrame((FramePose3DReadOnly)this.controlFramePose);
    }

    public void getControlFramePoseIncludingFrame(FramePoint3D positionToPack, FrameQuaternion orientationToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.controlFramePose.getPosition());
        orientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.controlFramePose.getOrientation());
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    public RigidBodyBasics getBase() {
        return this.base;
    }

    public RigidBodyBasics getEndEffector() {
        return this.endEffector;
    }

    public RigidBodyBasics getPrimaryBase() {
        return this.optionalPrimaryBase;
    }

    public boolean scaleSecondaryTaskJointWeight() {
        return this.scaleSecondaryTaskJointWeight;
    }

    public double getSecondaryTaskJointWeightScale() {
        return this.secondaryTaskJointWeightScale;
    }

    public void resetSecondaryTaskJointWeightScale() {
        this.secondaryTaskJointWeightScale = 1.0;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.TASKSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialVelocityCommand) {
            SpatialVelocityCommand other = (SpatialVelocityCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (!this.controlFramePose.equals((FramePose3DReadOnly)other.controlFramePose)) {
                return false;
            }
            if (!this.desiredLinearVelocity.equals((Tuple3DReadOnly)other.desiredLinearVelocity)) {
                return false;
            }
            if (!this.desiredAngularVelocity.equals((Tuple3DReadOnly)other.desiredAngularVelocity)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            if (!this.selectionMatrix.equals((Object)other.selectionMatrix)) {
                return false;
            }
            if (this.base != other.base) {
                return false;
            }
            if (this.endEffector != other.endEffector) {
                return false;
            }
            if (this.optionalPrimaryBase != other.optionalPrimaryBase) {
                return false;
            }
            if (this.scaleSecondaryTaskJointWeight != other.scaleSecondaryTaskJointWeight) {
                return false;
            }
            return this.secondaryTaskJointWeightScale == other.secondaryTaskJointWeightScale;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": base = " + this.base + ", endEffector = " + this.endEffector + ", linear = " + this.desiredLinearVelocity + ", angular = " + this.desiredAngularVelocity;
    }
}

