/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.OneDoFJointPrivilegedConfigurationParameters;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class PrivilegedConfigurationCommand
implements InverseKinematicsCommand<PrivilegedConfigurationCommand>,
InverseDynamicsCommand<PrivilegedConfigurationCommand> {
    private static final int initialCapacity = 40;
    private int commandId;
    private boolean enable = false;
    private final OneDoFJointPrivilegedConfigurationParameters defaultParameters = new OneDoFJointPrivilegedConfigurationParameters();
    private final List<OneDoFJointBasics> joints = new ArrayList<OneDoFJointBasics>(40);
    private final RecyclingArrayList<OneDoFJointPrivilegedConfigurationParameters> jointSpecificParameters = new RecyclingArrayList(40, OneDoFJointPrivilegedConfigurationParameters.class);

    public PrivilegedConfigurationCommand() {
        this.clear();
    }

    public void clear() {
        this.commandId = 0;
        this.enable = false;
        this.defaultParameters.clear();
        this.joints.clear();
        this.jointSpecificParameters.clear();
    }

    public void set(PrivilegedConfigurationCommand other) {
        this.clear();
        this.commandId = other.commandId;
        this.enable = other.enable;
        this.defaultParameters.set(other.defaultParameters);
        for (int jointIndex = 0; jointIndex < other.getNumberOfJoints(); ++jointIndex) {
            this.joints.add(other.joints.get(jointIndex));
            ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.add()).set((OneDoFJointPrivilegedConfigurationParameters)other.jointSpecificParameters.get(jointIndex));
        }
    }

    public void disable() {
        this.enable = false;
    }

    public void enable() {
        this.enable = true;
    }

    public void setDefaultParameters(OneDoFJointPrivilegedConfigurationParameters defaultParameters) {
        this.defaultParameters.set(defaultParameters);
    }

    public void setPrivilegedConfigurationOption(PrivilegedConfigurationOption option) {
        this.enable();
        this.defaultParameters.setPrivilegedConfigurationOption(option);
    }

    public void setDefaultWeight(double defaultWeight) {
        this.defaultParameters.setWeight(defaultWeight);
    }

    public void setDefaultConfigurationGain(double defaultConfigurationGain) {
        this.defaultParameters.setConfigurationGain(defaultConfigurationGain);
    }

    public void setDefaultVelocityGain(double defaultVelocityGain) {
        this.defaultParameters.setVelocityGain(defaultVelocityGain);
    }

    public void setDefaultMaxVelocity(double defaultMaxVelocity) {
        this.defaultParameters.setMaxVelocity(defaultMaxVelocity);
    }

    public void setDefaultMaxAcceleration(double defaultMaxAcceleration) {
        this.defaultParameters.setMaxAcceleration(defaultMaxAcceleration);
    }

    public void addJoint(OneDoFJointBasics joint, OneDoFJointPrivilegedConfigurationParameters jointSpecificParameters) {
        this.enable();
        this.joints.add(joint);
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.add()).set(jointSpecificParameters);
    }

    public void addJoint(OneDoFJointBasics joint, double privilegedConfiguration) {
        this.enable();
        this.joints.add(joint);
        OneDoFJointPrivilegedConfigurationParameters parameters = (OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.add();
        parameters.clear();
        parameters.setPrivilegedConfiguration(privilegedConfiguration);
    }

    public void addJoint(OneDoFJointBasics joint, PrivilegedConfigurationOption privilegedConfiguration) {
        this.enable();
        this.joints.add(joint);
        OneDoFJointPrivilegedConfigurationParameters parameters = (OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.add();
        parameters.clear();
        parameters.setPrivilegedConfigurationOption(privilegedConfiguration);
    }

    public void setOneDoFJoint(int jointIndex, OneDoFJointPrivilegedConfigurationParameters jointSpecificParameters) {
        this.enable();
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).set(jointSpecificParameters);
    }

    public void setOneDoFJoint(int jointIndex, double privilegedConfiguration) {
        this.enable();
        OneDoFJointPrivilegedConfigurationParameters parameters = (OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex);
        parameters.setPrivilegedConfiguration(privilegedConfiguration);
        parameters.setPrivilegedConfigurationOption(null);
    }

    public void setOneDoFJoint(int jointIndex, PrivilegedConfigurationOption privilegedConfiguration) {
        this.enable();
        OneDoFJointPrivilegedConfigurationParameters parameters = (OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex);
        parameters.setPrivilegedConfigurationOption(privilegedConfiguration);
        parameters.setPrivilegedConfiguration(Double.NaN);
    }

    public void setWeight(int jointIndex, double weight) {
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).setWeight(weight);
    }

    public void setConfigurationGain(int jointIndex, double configurationGain) {
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).setConfigurationGain(configurationGain);
    }

    public void setVelocityGain(int jointIndex, double velocityGain) {
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).setVelocityGain(velocityGain);
    }

    public void setMaxVelocity(int jointIndex, double maxVelocity) {
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).setMaxVelocity(maxVelocity);
    }

    public void setMaxAcceleration(int jointIndex, double maxAcceleration) {
        ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).setMaxAcceleration(maxAcceleration);
    }

    public void setConfigurationGains(double configurationGain) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            this.setConfigurationGain(jointIndex, configurationGain);
        }
    }

    public void setVelocityGains(double velocityGain) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            this.setVelocityGain(jointIndex, velocityGain);
        }
    }

    public void setMaxVelocities(double maxVelocity) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            this.setMaxVelocity(jointIndex, maxVelocity);
        }
    }

    public void setMaxAccelerations(double maxAcceleration) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            this.setMaxAcceleration(jointIndex, maxAcceleration);
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public OneDoFJointPrivilegedConfigurationParameters getDefaultParameters() {
        return this.defaultParameters;
    }

    public OneDoFJointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public OneDoFJointPrivilegedConfigurationParameters getJointSpecificParameters(int jointIndex) {
        return (OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex);
    }

    public int getNumberOfJoints() {
        return this.jointSpecificParameters.size();
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.PRIVILEGED_CONFIGURATION;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PrivilegedConfigurationCommand) {
            PrivilegedConfigurationCommand other = (PrivilegedConfigurationCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.enable != other.enable) {
                return false;
            }
            if (!this.defaultParameters.equals(other.defaultParameters)) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) == other.joints.get(jointIndex)) continue;
                return false;
            }
            return this.jointSpecificParameters.equals(other.jointSpecificParameters);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": enabled: " + this.enable + ", default parameters: " + this.defaultParameters.toString();
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ret = ret + "\nJoint: " + this.joints.get(jointIndex).getName() + ", " + ((OneDoFJointPrivilegedConfigurationParameters)this.jointSpecificParameters.get(jointIndex)).toString();
        }
        return ret;
    }

    public static enum PrivilegedConfigurationOption {
        AT_CURRENT,
        AT_MID_RANGE,
        AT_ZERO;

    }
}

