/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;

public class InverseKinematicsOptimizationSettingsCommand
implements InverseKinematicsCommand<InverseKinematicsOptimizationSettingsCommand> {
    private int commandId;
    private double jointVelocityWeight = Double.NaN;
    private double jointAccelerationWeight = Double.NaN;
    public JointVelocityLimitMode jointVelocityLimitMode = null;

    public void setJointVelocityWeight(double jointVelocityWeight) {
        this.jointVelocityWeight = jointVelocityWeight;
    }

    public void setJointAccelerationWeight(double jointAccelerationWeight) {
        this.jointAccelerationWeight = jointAccelerationWeight;
    }

    public void setJointVelocityLimitMode(JointVelocityLimitMode jointVelocityLimitMode) {
        this.jointVelocityLimitMode = jointVelocityLimitMode;
    }

    public boolean hasJointVelocityWeight() {
        return !Double.isNaN(this.jointVelocityWeight);
    }

    public boolean hasJointAccelerationWeight() {
        return !Double.isNaN(this.jointAccelerationWeight);
    }

    public boolean hashJointVelocityLimitMode() {
        return this.jointVelocityLimitMode != null;
    }

    public double getJointVelocityWeight() {
        return this.jointVelocityWeight;
    }

    public double getJointAccelerationWeight() {
        return this.jointAccelerationWeight;
    }

    public JointVelocityLimitMode getJointVelocityLimitMode() {
        return this.jointVelocityLimitMode;
    }

    public void set(InverseKinematicsOptimizationSettingsCommand other) {
        this.commandId = other.commandId;
        this.jointVelocityWeight = other.jointVelocityWeight;
        this.jointAccelerationWeight = other.jointAccelerationWeight;
        this.jointVelocityLimitMode = other.jointVelocityLimitMode;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.OPTIMIZATION_SETTINGS;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InverseKinematicsOptimizationSettingsCommand) {
            InverseKinematicsOptimizationSettingsCommand other = (InverseKinematicsOptimizationSettingsCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (Double.compare(this.jointVelocityWeight, other.jointVelocityWeight) != 0) {
                return false;
            }
            if (Double.compare(this.jointAccelerationWeight, other.jointAccelerationWeight) != 0) {
                return false;
            }
            return this.jointVelocityLimitMode == other.jointVelocityLimitMode;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": qd weight: " + this.jointVelocityWeight + ", qdd weight: " + this.jointAccelerationWeight + ", qd limits: " + (Object)((Object)this.jointVelocityLimitMode);
    }

    public static enum JointVelocityLimitMode {
        ENABLED,
        DISABLED;

    }
}

