/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class MomentumRateCommand
implements InverseDynamicsCommand<MomentumRateCommand>,
VirtualModelControlCommand<MomentumRateCommand> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private int commandId;
    private final DMatrixRMaj momentumRateOfChange = new DMatrixRMaj(6, 1);
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();

    public MomentumRateCommand() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public void set(MomentumRateCommand other) {
        this.commandId = other.commandId;
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
        this.momentumRateOfChange.set((DMatrixD1)other.momentumRateOfChange);
    }

    public void setProperties(SpatialAccelerationCommand command) {
        this.commandId = command.getCommandId();
        this.weightMatrix.set(command.getWeightMatrix());
        command.getSelectionMatrix(this.selectionMatrix);
    }

    public void setMomentumRateToZero() {
        this.momentumRateOfChange.zero();
    }

    public void setMomentumRate(DMatrixRMaj momentumRateOfChange) {
        this.momentumRateOfChange.set((DMatrixD1)momentumRateOfChange);
    }

    public void setMomentumRate(FrameVector3D angularMomentumRateOfChange, FrameVector3D linearMomentumRateOfChange) {
        angularMomentumRateOfChange.checkReferenceFrameMatch(worldFrame);
        linearMomentumRateOfChange.checkReferenceFrameMatch(worldFrame);
        angularMomentumRateOfChange.get(0, (DMatrix)this.momentumRateOfChange);
        linearMomentumRateOfChange.get(3, (DMatrix)this.momentumRateOfChange);
    }

    public void setAngularMomentumRate(FrameVector3D angularMomentumRateOfChange) {
        angularMomentumRateOfChange.checkReferenceFrameMatch(worldFrame);
        this.momentumRateOfChange.zero();
        angularMomentumRateOfChange.get(0, (DMatrix)this.momentumRateOfChange);
    }

    public void setLinearMomentumRate(FrameVector3D linearMomentumRateOfChange) {
        linearMomentumRateOfChange.checkReferenceFrameMatch(worldFrame);
        this.momentumRateOfChange.zero();
        linearMomentumRateOfChange.get(3, (DMatrix)this.momentumRateOfChange);
    }

    public void setLinearMomentumXYRate(FrameVector2D linearMomentumRateOfChange) {
        linearMomentumRateOfChange.checkReferenceFrameMatch(worldFrame);
        this.momentumRateOfChange.zero();
        linearMomentumRateOfChange.get(3, (DMatrix)this.momentumRateOfChange);
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixForLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
    }

    public void setSelectionMatrixForLinearControl(SelectionMatrix3D linearSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setLinearPart(linearSelectionMatrix);
    }

    public void setSelectionMatrixForLinearXYControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
        this.selectionMatrix.selectLinearZ(false);
    }

    public void setSelectionMatrixForAngularControl() {
        this.selectionMatrix.setToAngularSelectionOnly();
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public void setAsHardConstraint() {
        this.setWeight(Double.POSITIVE_INFINITY);
    }

    public void setWeight(double weight) {
        this.weightMatrix.setAngularWeights(weight, weight, weight);
        this.weightMatrix.setLinearWeights(weight, weight, weight);
    }

    public void setWeight(double angular, double linear) {
        this.weightMatrix.setLinearWeights(linear, linear, linear);
        this.weightMatrix.setAngularWeights(angular, angular, angular);
    }

    public void setWeights(double angularX, double angularY, double angularZ, double linearX, double linearY, double linearZ) {
        this.weightMatrix.setAngularWeights(angularX, angularY, angularZ);
        this.weightMatrix.setLinearWeights(linearX, linearY, linearZ);
    }

    public void setWeights(WeightMatrix6D weightMatrix) {
        this.weightMatrix.set(weightMatrix);
    }

    public void setAngularWeights(Tuple3DReadOnly angular) {
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
    }

    public void setLinearWeights(Tuple3DReadOnly linear) {
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
    }

    public void setWeights(Tuple3DReadOnly angular, Tuple3DReadOnly linear) {
        this.setLinearWeights(linear);
        this.setAngularWeights(angular);
    }

    public void setAngularWeightsToZero() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
    }

    public void setLinearWeightsToZero() {
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public boolean isHardConstraint() {
        return this.weightMatrix.containsHardConstraint();
    }

    public void getWeightMatrix(DMatrixRMaj weightMatrixToPack) {
        weightMatrixToPack.reshape(6, 6);
        this.weightMatrix.getFullWeightMatrixInFrame(worldFrame, weightMatrixToPack);
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public DMatrixRMaj getMomentumRate() {
        return this.momentumRateOfChange;
    }

    public void getMomentumRate(FrameVector3D angularPartToPack, FrameVector3D linearPartToPack) {
        angularPartToPack.setIncludingFrame(worldFrame, 0, (DMatrix)this.momentumRateOfChange);
        linearPartToPack.setIncludingFrame(worldFrame, 3, (DMatrix)this.momentumRateOfChange);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.MOMENTUM;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MomentumRateCommand) {
            MomentumRateCommand other = (MomentumRateCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!MatrixFeatures_DDRM.isEquals((DMatrixD1)this.momentumRateOfChange, (DMatrixD1)other.momentumRateOfChange)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            return this.selectionMatrix.equals((Object)other.selectionMatrix);
        }
        return false;
    }

    public String toString() {
        String stringOfMomentumRate = EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)",", (double[])this.momentumRateOfChange.getData());
        return this.getClass().getSimpleName() + ": momentum rate: " + stringOfMomentumRate + ", selection matrix = " + this.selectionMatrix;
    }
}

