/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.lists.DenseMatrixArrayList;

public class JointspaceAccelerationCommand
implements InverseDynamicsCommand<JointspaceAccelerationCommand> {
    private static final int initialCapacity = 15;
    private int commandId;
    private final List<JointBasics> joints = new ArrayList<JointBasics>(15);
    private final DenseMatrixArrayList desiredAccelerations = new DenseMatrixArrayList(15);
    private final TDoubleArrayList weights = new TDoubleArrayList(15);

    public JointspaceAccelerationCommand() {
        this.clear();
    }

    public void set(JointspaceAccelerationCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJoints(); ++i) {
            this.joints.add(other.joints.get(i));
            this.weights.add(other.getWeight(i));
        }
        this.desiredAccelerations.set(other.desiredAccelerations);
    }

    public void clear() {
        this.commandId = 0;
        this.joints.clear();
        this.desiredAccelerations.clear();
        this.weights.reset();
    }

    public void addJoint(OneDoFJointBasics joint, double desiredAcceleration) {
        this.addJoint(joint, desiredAcceleration, Double.POSITIVE_INFINITY);
    }

    public void addJoint(OneDoFJointBasics joint, double desiredAcceleration, double weight) {
        this.joints.add((JointBasics)joint);
        this.weights.add(weight);
        DMatrixRMaj jointDesiredAcceleration = (DMatrixRMaj)this.desiredAccelerations.add();
        jointDesiredAcceleration.reshape(1, 1);
        jointDesiredAcceleration.set(0, 0, desiredAcceleration);
    }

    public void addJoint(JointBasics joint, DMatrixRMaj desiredAcceleration) {
        this.addJoint(joint, desiredAcceleration, Double.POSITIVE_INFINITY);
    }

    public void addJoint(JointBasics joint, DMatrixRMaj desiredAcceleration, double weight) {
        this.checkConsistency(joint, desiredAcceleration);
        this.joints.add(joint);
        this.weights.add(weight);
        ((DMatrixRMaj)this.desiredAccelerations.add()).set((DMatrixD1)desiredAcceleration);
    }

    public void setOneDoFJointDesiredAcceleration(int jointIndex, double desiredAcceleration) {
        MathTools.checkEquals((int)this.joints.get(jointIndex).getDegreesOfFreedom(), (int)1);
        ((DMatrixRMaj)this.desiredAccelerations.get(jointIndex)).reshape(1, 1);
        ((DMatrixRMaj)this.desiredAccelerations.get(jointIndex)).set(0, 0, desiredAcceleration);
    }

    public void setDesiredAcceleration(int jointIndex, DMatrixRMaj desiredAcceleration) {
        this.checkConsistency(this.joints.get(jointIndex), desiredAcceleration);
        ((DMatrixRMaj)this.desiredAccelerations.get(jointIndex)).set((DMatrixD1)desiredAcceleration);
    }

    public void setAsHardConstraint() {
        for (int jointIdx = 0; jointIdx < this.joints.size(); ++jointIdx) {
            this.setWeight(jointIdx, Double.POSITIVE_INFINITY);
        }
    }

    public void setWeight(int jointIndex, double weight) {
        this.weights.set(jointIndex, weight);
    }

    public void setWeight(double weight) {
        for (int jointIdx = 0; jointIdx < this.joints.size(); ++jointIdx) {
            this.weights.set(jointIdx, weight);
        }
    }

    private void checkConsistency(JointBasics joint, DMatrixRMaj desiredAcceleration) {
        MathTools.checkEquals((int)joint.getDegreesOfFreedom(), (int)desiredAcceleration.getNumRows());
    }

    public boolean isHardConstraint() {
        boolean isHardConstraint;
        if (this.getNumberOfJoints() == 0) {
            return true;
        }
        boolean bl = isHardConstraint = this.getWeight(0) == Double.POSITIVE_INFINITY;
        if (this.getNumberOfJoints() == 1) {
            return isHardConstraint;
        }
        for (int jointIdx = 1; jointIdx < this.joints.size(); ++jointIdx) {
            boolean isJointHardConstraint;
            boolean bl2 = isJointHardConstraint = this.getWeight(jointIdx) == Double.POSITIVE_INFINITY;
            if (isJointHardConstraint == isHardConstraint) continue;
            throw new RuntimeException("Inconsistent weights in " + this.getClass().getSimpleName() + ": some joint acceleration desireds have weights, others are hard constraints. This is not supported in a single message.");
        }
        return isHardConstraint;
    }

    public double getWeight(int jointIndex) {
        return this.weights.get(jointIndex);
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public List<JointBasics> getJoints() {
        return this.joints;
    }

    public JointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public DMatrixRMaj getDesiredAcceleration(int jointIndex) {
        return (DMatrixRMaj)this.desiredAccelerations.get(jointIndex);
    }

    public DenseMatrixArrayList getDesiredAccelerations() {
        return this.desiredAccelerations;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINTSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointspaceAccelerationCommand) {
            JointspaceAccelerationCommand other = (JointspaceAccelerationCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) == other.joints.get(jointIndex)) continue;
                return false;
            }
            if (!this.desiredAccelerations.equals((Object)other.desiredAccelerations)) {
                return false;
            }
            return this.weights.equals((Object)other.weights);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        for (int i = 0; i < this.joints.size(); ++i) {
            ret = ret + this.joints.get(i).getName();
            ret = i < this.joints.size() - 1 ? ret + ", " : ret + ".";
        }
        return ret;
    }
}

