/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class JointAccelerationIntegrationCommand
implements InverseDynamicsCommand<JointAccelerationIntegrationCommand>,
VirtualModelControlCommand<JointAccelerationIntegrationCommand> {
    private static final int initialCapacity = 15;
    private int commandId;
    private final List<OneDoFJointBasics> jointsToComputeDesiredPositionFor = new ArrayList<OneDoFJointBasics>(15);
    private final RecyclingArrayList<JointAccelerationIntegrationParameters> jointParameters = new RecyclingArrayList(15, JointAccelerationIntegrationParameters.class);

    public JointAccelerationIntegrationCommand() {
        this.jointParameters.clear();
    }

    public void clear() {
        this.commandId = 0;
        this.jointsToComputeDesiredPositionFor.clear();
        this.jointParameters.clear();
    }

    public void addJointToComputeDesiredPositionFor(OneDoFJointBasics joint) {
        this.jointsToComputeDesiredPositionFor.add(joint);
        ((JointAccelerationIntegrationParameters)this.jointParameters.add()).reset();
    }

    public void setJointParameters(int jointIndex, JointAccelerationIntegrationParametersReadOnly jointParameters) {
        ((JointAccelerationIntegrationParameters)this.jointParameters.get(jointIndex)).set(jointParameters);
    }

    public void setBreakFrequencies(int jointIndex, double positionBreakFrequency, double velocityBreakFrequency) {
        ((JointAccelerationIntegrationParameters)this.jointParameters.get(jointIndex)).setBreakFrequencies(positionBreakFrequency, velocityBreakFrequency);
    }

    public void setJointMaxima(int jointIndex, double maxPositionError, double maxVelocityError) {
        ((JointAccelerationIntegrationParameters)this.jointParameters.get(jointIndex)).setMaxima(maxPositionError, maxVelocityError);
    }

    public void set(JointAccelerationIntegrationCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJointsToComputeDesiredPositionFor(); ++i) {
            this.jointsToComputeDesiredPositionFor.add(other.jointsToComputeDesiredPositionFor.get(i));
            ((JointAccelerationIntegrationParameters)this.jointParameters.add()).set(other.getJointParameters(i));
        }
    }

    public OneDoFJointBasics getJointToComputeDesiredPositionFor(int jointIndex) {
        return this.jointsToComputeDesiredPositionFor.get(jointIndex);
    }

    public JointAccelerationIntegrationParametersReadOnly getJointParameters(int jointIndex) {
        return (JointAccelerationIntegrationParametersReadOnly)this.jointParameters.get(jointIndex);
    }

    public int getNumberOfJointsToComputeDesiredPositionFor() {
        return this.jointsToComputeDesiredPositionFor.size();
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINT_ACCELERATION_INTEGRATION;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointAccelerationIntegrationCommand) {
            JointAccelerationIntegrationCommand other = (JointAccelerationIntegrationCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJointsToComputeDesiredPositionFor() != other.getNumberOfJointsToComputeDesiredPositionFor()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJointsToComputeDesiredPositionFor(); ++jointIndex) {
                if (this.getJointToComputeDesiredPositionFor(jointIndex) != other.getJointToComputeDesiredPositionFor(jointIndex)) {
                    return false;
                }
                if (this.getJointParameters(jointIndex).equals(other.getJointParameters(jointIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ":";
        for (int jointIndex = 0; jointIndex < this.getNumberOfJointsToComputeDesiredPositionFor(); ++jointIndex) {
            ret = ret + "\nJoint: " + this.getJointToComputeDesiredPositionFor(jointIndex).getName() + ", " + this.getJointParameters(jointIndex).toString();
        }
        return ret;
    }
}

