/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public class ExternalWrenchCommand
implements InverseDynamicsCommand<ExternalWrenchCommand>,
VirtualModelControlCommand<ExternalWrenchCommand> {
    private int commandId;
    private RigidBodyBasics rigidBody;
    private final Wrench externalWrenchAppliedOnRigidBody = new Wrench();

    public void setRigidBody(RigidBodyBasics rigidBody) {
        this.rigidBody = rigidBody;
    }

    public void set(RigidBodyBasics rigidBody, WrenchReadOnly externalWrench) {
        this.setRigidBody(rigidBody);
        this.externalWrenchAppliedOnRigidBody.setIncludingFrame(externalWrench);
        this.externalWrenchAppliedOnRigidBody.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public WrenchBasics getExternalWrench() {
        return this.externalWrenchAppliedOnRigidBody;
    }

    public void set(ExternalWrenchCommand other) {
        this.commandId = other.commandId;
        this.rigidBody = other.rigidBody;
        this.externalWrenchAppliedOnRigidBody.setIncludingFrame((WrenchReadOnly)other.externalWrenchAppliedOnRigidBody);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.EXTERNAL_WRENCH;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ExternalWrenchCommand) {
            ExternalWrenchCommand other = (ExternalWrenchCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.rigidBody != other.rigidBody) {
                return false;
            }
            return this.externalWrenchAppliedOnRigidBody.equals((WrenchReadOnly)other.externalWrenchAppliedOnRigidBody);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": body: " + this.rigidBody + ", wrench: " + this.externalWrenchAppliedOnRigidBody;
    }
}

