/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ZeroablePID3DGains;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;

public class PointFeedbackControlCommand
implements FeedbackControlCommand<PointFeedbackControlCommand> {
    private final FramePoint3D bodyFixedPointInEndEffectorFrame = new FramePoint3D();
    private WholeBodyControllerCoreMode controlMode = null;
    private final FramePoint3D referencePosition = new FramePoint3D();
    private final FrameVector3D referenceLinearVelocity = new FrameVector3D();
    private final FrameVector3D referenceLinearAcceleration = new FrameVector3D();
    private final FrameVector3D referenceForce = new FrameVector3D();
    private final ZeroablePID3DGains gains = new ZeroablePID3DGains();
    private ReferenceFrame linearGainsFrame = null;
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private ReferenceFrame controlBaseFrame = null;

    public PointFeedbackControlCommand() {
        this.spatialAccelerationCommand.setSelectionMatrixForLinearControl();
    }

    public void set(PointFeedbackControlCommand other) {
        this.bodyFixedPointInEndEffectorFrame.setIncludingFrame((FrameTuple3DReadOnly)other.bodyFixedPointInEndEffectorFrame);
        this.controlMode = other.controlMode;
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)other.referencePosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearVelocity);
        this.referenceLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearAcceleration);
        this.referenceForce.setIncludingFrame((FrameTuple3DReadOnly)other.referenceForce);
        this.gains.set(other.gains);
        this.linearGainsFrame = other.linearGainsFrame;
        this.spatialAccelerationCommand.set(other.spatialAccelerationCommand);
        this.controlBaseFrame = other.controlBaseFrame;
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.spatialAccelerationCommand.set(base, endEffector);
        this.resetBodyFixedPoint();
    }

    public void setPrimaryBase(RigidBodyBasics primaryBase) {
        this.spatialAccelerationCommand.setPrimaryBase(primaryBase);
    }

    public void setControlBaseFrame(ReferenceFrame controlBaseFrame) {
        if (controlBaseFrame == this.getBase().getBodyFixedFrame()) {
            this.controlBaseFrame = null;
        } else if (controlBaseFrame.isAStationaryFrame() || controlBaseFrame instanceof MovingReferenceFrame) {
            this.controlBaseFrame = controlBaseFrame;
        } else {
            throw new IllegalArgumentException("The control base frame has to either be a stationary frame or a MovingReferenceFrame.");
        }
    }

    public void resetControlBaseFrame() {
        this.controlBaseFrame = null;
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains.set(gains);
    }

    public void setGainsFrame(ReferenceFrame linearGainsFrame) {
        this.linearGainsFrame = linearGainsFrame;
    }

    public void setControlMode(WholeBodyControllerCoreMode controlMode) {
        this.controlMode = controlMode;
    }

    public void setInverseKinematics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly feedForwardLinearVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setToZero(trajectoryFrame);
        this.referenceForce.setToZero(trajectoryFrame);
    }

    public void setInverseDynamics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardLinearAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearAcceleration);
        this.referenceLinearAcceleration.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceForce.setToZero(trajectoryFrame);
    }

    public void setVirtualModelControl(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardForce) {
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceForce.setIncludingFrame((FrameTuple3DReadOnly)feedForwardForce);
        this.referenceForce.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setToZero(trajectoryFrame);
    }

    public void resetBodyFixedPoint() {
        this.bodyFixedPointInEndEffectorFrame.setToZero((ReferenceFrame)this.getEndEffector().getBodyFixedFrame());
    }

    public void setBodyFixedPointToControl(FramePoint3DReadOnly bodyFixedPointInEndEffectorFrame) {
        bodyFixedPointInEndEffectorFrame.checkReferenceFrameMatch((ReferenceFrame)this.getEndEffector().getBodyFixedFrame());
        this.bodyFixedPointInEndEffectorFrame.set((FrameTuple3DReadOnly)bodyFixedPointInEndEffectorFrame);
    }

    public void setSelectionMatrixToIdentity() {
        this.spatialAccelerationCommand.setSelectionMatrixForLinearControl();
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.spatialAccelerationCommand.setSelectionMatrixForLinearControl(selectionMatrix);
    }

    public void setWeightForSolver(double weight) {
        this.spatialAccelerationCommand.setWeight(weight);
    }

    public void setWeightMatrix(WeightMatrix3D weightMatrix) {
        this.spatialAccelerationCommand.setLinearPartOfWeightMatrix(weightMatrix);
        this.spatialAccelerationCommand.setAngularWeightsToZero();
    }

    public void setWeightsForSolver(Vector3DReadOnly weight) {
        this.spatialAccelerationCommand.setLinearWeights((Tuple3DReadOnly)weight);
        this.spatialAccelerationCommand.setAngularWeightsToZero();
    }

    public void getBodyFixedPointIncludingFrame(FramePoint3D bodyFixedPointToControlToPack) {
        bodyFixedPointToControlToPack.setIncludingFrame((FrameTuple3DReadOnly)this.bodyFixedPointInEndEffectorFrame);
    }

    public FramePoint3DBasics getBodyFixedPointToControl() {
        return this.bodyFixedPointInEndEffectorFrame;
    }

    public WholeBodyControllerCoreMode getControlMode() {
        return this.controlMode;
    }

    public FramePoint3DBasics getReferencePosition() {
        return this.referencePosition;
    }

    public FrameVector3DBasics getReferenceLinearVelocity() {
        return this.referenceLinearVelocity;
    }

    public FrameVector3DBasics getReferenceLinearAcceleration() {
        return this.referenceLinearAcceleration;
    }

    public FrameVector3D getReferenceForce() {
        return this.referenceForce;
    }

    public RigidBodyBasics getBase() {
        return this.spatialAccelerationCommand.getBase();
    }

    public RigidBodyBasics getEndEffector() {
        return this.spatialAccelerationCommand.getEndEffector();
    }

    public ReferenceFrame getControlBaseFrame() {
        if (this.controlBaseFrame != null) {
            return this.controlBaseFrame;
        }
        return this.spatialAccelerationCommand.getBase().getBodyFixedFrame();
    }

    public SpatialAccelerationCommand getSpatialAccelerationCommand() {
        return this.spatialAccelerationCommand;
    }

    public PID3DGains getGains() {
        return this.gains;
    }

    public ReferenceFrame getLinearGainsFrame() {
        return this.linearGainsFrame;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.POINT;
    }

    @Override
    public void setCommandId(int id) {
        this.spatialAccelerationCommand.setCommandId(id);
    }

    @Override
    public int getCommandId() {
        return this.spatialAccelerationCommand.getCommandId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PointFeedbackControlCommand) {
            PointFeedbackControlCommand other = (PointFeedbackControlCommand)object;
            if (this.controlMode != other.controlMode) {
                return false;
            }
            if (!this.bodyFixedPointInEndEffectorFrame.equals((FrameTuple3DReadOnly)other.bodyFixedPointInEndEffectorFrame)) {
                return false;
            }
            if (!this.referencePosition.equals((FrameTuple3DReadOnly)other.referencePosition)) {
                return false;
            }
            if (!this.referenceLinearVelocity.equals((FrameTuple3DReadOnly)other.referenceLinearVelocity)) {
                return false;
            }
            if (!this.referenceLinearAcceleration.equals((FrameTuple3DReadOnly)other.referenceLinearAcceleration)) {
                return false;
            }
            if (!this.referenceForce.equals((FrameTuple3DReadOnly)other.referenceForce)) {
                return false;
            }
            if (!this.gains.equals((PID3DGainsReadOnly)other.gains)) {
                return false;
            }
            if (this.linearGainsFrame != other.linearGainsFrame) {
                return false;
            }
            if (!this.spatialAccelerationCommand.equals(other.spatialAccelerationCommand)) {
                return false;
            }
            return this.controlBaseFrame == other.controlBaseFrame;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        ret = ret + "base = " + this.spatialAccelerationCommand.getBase() + ", ";
        ret = ret + "endEffector = " + this.spatialAccelerationCommand.getEndEffector() + ", ";
        ret = ret + "position = " + this.referencePosition;
        return ret;
    }
}

