/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;

public class FeedbackControlCommandList
implements FeedbackControlCommand<FeedbackControlCommandList> {
    private int commandId;
    private final List<FeedbackControlCommand<?>> commandList = new ArrayList();

    public FeedbackControlCommandList() {
    }

    public FeedbackControlCommandList(FeedbackControlCommandList other) {
        this.addCommandList(other);
    }

    public void addCommand(FeedbackControlCommand<?> command) {
        if (command == null) {
            return;
        }
        if (command instanceof FeedbackControlCommandList) {
            this.addCommandList((FeedbackControlCommandList)command);
        } else {
            this.commandList.add(command);
        }
    }

    public void addCommandList(FeedbackControlCommandList commandList) {
        if (commandList == null) {
            return;
        }
        for (int i = 0; i < commandList.getNumberOfCommands(); ++i) {
            this.addCommand(commandList.getCommand(i));
        }
    }

    public void clear() {
        this.commandId = 0;
        this.commandList.clear();
    }

    public FeedbackControlCommand<?> getCommand(int commandIndex) {
        return this.commandList.get(commandIndex);
    }

    public int indexOf(FeedbackControlCommand<?> command) {
        return this.commandList.indexOf(command);
    }

    public void removeCommand(FeedbackControlCommand<?> command) {
        int indexOf = this.indexOf(command);
        if (indexOf == -1) {
            return;
        }
        this.removeCommand(indexOf);
    }

    public void removeCommand(int commandIndex) {
        this.commandList.remove(commandIndex);
    }

    public FeedbackControlCommand<?> pollCommand() {
        if (this.commandList.isEmpty()) {
            return null;
        }
        return this.commandList.remove(this.commandList.size() - 1);
    }

    public int getNumberOfCommands() {
        return this.commandList.size();
    }

    public boolean isCommandEmpty() {
        return this.commandList.isEmpty();
    }

    public void set(FeedbackControlCommandList other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        for (int i = 0; i < other.getNumberOfCommands(); ++i) {
            this.addCommand(other.getCommand(i));
        }
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.COMMAND_LIST;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FeedbackControlCommandList) {
            FeedbackControlCommandList other = (FeedbackControlCommandList)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfCommands() != other.getNumberOfCommands()) {
                return false;
            }
            for (int commandIndex = 0; commandIndex < this.getNumberOfCommands(); ++commandIndex) {
                if (this.getCommand(commandIndex).equals(other.getCommand(commandIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "Nb of commands: " + this.getNumberOfCommands() + "\n" + this.commandList;
    }
}

