/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointLimitEnforcementCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualForceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualWrenchCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.PlaneContactWrenchProcessor;
import us.ihmc.commonWalkingControlModules.momentumBasedController.WholeBodyControllerBoundCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointAccelerationIntegrationCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl.VirtualModelControlModuleException;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl.VirtualModelControlOptimizationControlModule;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl.VirtualModelMomentumController;
import us.ihmc.commonWalkingControlModules.virtualModelControl.VirtualModelControlSolution;
import us.ihmc.commonWalkingControlModules.visualizer.WrenchVisualizer;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WholeBodyVirtualModelControlSolver {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final VirtualModelControlOptimizationControlModule optimizationControlModule;
    private final VirtualModelMomentumController virtualModelController;
    private final PlaneContactWrenchProcessor planeContactWrenchProcessor;
    private final WrenchVisualizer wrenchVisualizer;
    private final JointAccelerationIntegrationCalculator jointAccelerationIntegrationCalculator;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private final FloatingJointBasics rootJoint;
    private final RootJointDesiredConfigurationData rootJointDesiredConfiguration = new RootJointDesiredConfigurationData();
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final PoseReferenceFrame controlFrame = new PoseReferenceFrame("controlFrame", worldFrame);
    private final RigidBodyBasics controlRootBody;
    private final Wrench tempWrench = new Wrench();
    private final FrameVector3D tempForce = new FrameVector3D();
    private final FrameVector3D tempTorque = new FrameVector3D();
    private final SelectionMatrix6D tempSelectionMatrix = new SelectionMatrix6D();
    private final YoFrameVector3D yoDesiredMomentumRateLinear;
    private final YoFrameVector3D yoAchievedMomentumRateLinear;
    private final YoFrameVector3D yoDesiredMomentumRateAngular;
    private final YoFrameVector3D yoAchievedMomentumRateAngular;
    private final FrameVector3D achievedMomentumRateLinear = new FrameVector3D();
    private final Wrench residualRootJointWrench = new Wrench();
    private final FrameVector3D residualRootJointForce = new FrameVector3D();
    private final FrameVector3D residualRootJointTorque = new FrameVector3D();
    private final YoFrameVector3D yoResidualRootJointForce;
    private final YoFrameVector3D yoResidualRootJointTorque;
    private final JointIndexHandler jointIndexHandler;
    private final WholeBodyControllerBoundCalculator boundCalculator;
    private final Vector3DReadOnly defaultLinearMomentumWeight = new ParameterVector3D("DefaultVMCRootLinearMomentumRateWeight", (Tuple3DReadOnly)new Vector3D(5.0, 5.0, 2.5), this.registry);
    private final Vector3DReadOnly defaultAngularMomentumWeight = new ParameterVector3D("DefaultVMCRootAngularMomentumRateWeight", (Tuple3DReadOnly)new Vector3D(2.5, 2.5, 1.0), this.registry);
    private final MomentumRateCommand rootBodyDefaultMomentumCommand = new MomentumRateCommand();
    private final OneDoFJointBasics[] controlledOneDoFJoints;

    public WholeBodyVirtualModelControlSolver(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this.rootJoint = toolbox.getRootJoint();
        this.optimizationControlModule = new VirtualModelControlOptimizationControlModule(toolbox, this.registry);
        if (this.rootJoint.subtreeStream().filter(JointReadOnly::isLoopClosure).findFirst().isPresent()) {
            throw new UnsupportedOperationException("The virtual model control does not support kinematic loops yet.");
        }
        this.jointIndexHandler = toolbox.getJointIndexHandler();
        this.controlledOneDoFJoints = this.jointIndexHandler.getIndexedOneDoFJoints();
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])this.controlledOneDoFJoints);
        this.lowLevelOneDoFJointDesiredDataHolder.setJointsControlMode((OneDoFJointReadOnly[])this.controlledOneDoFJoints, JointDesiredControlMode.EFFORT);
        this.boundCalculator = toolbox.getQPBoundCalculator();
        this.controlRootBody = toolbox.getVirtualModelControlMainBody();
        this.virtualModelController = new VirtualModelMomentumController(toolbox.getJointIndexHandler());
        this.yoDesiredMomentumRateLinear = toolbox.getYoDesiredMomentumRateLinear();
        this.yoAchievedMomentumRateLinear = toolbox.getYoAchievedMomentumRateLinear();
        this.yoDesiredMomentumRateAngular = toolbox.getYoDesiredMomentumRateAngular();
        this.yoAchievedMomentumRateAngular = toolbox.getYoAchievedMomentumRateAngular();
        this.planeContactWrenchProcessor = toolbox.getPlaneContactWrenchProcessor();
        this.wrenchVisualizer = toolbox.getWrenchVisualizer();
        this.jointAccelerationIntegrationCalculator = new JointAccelerationIntegrationCalculator(toolbox.getControlDT(), this.registry);
        this.forwardDynamicsCalculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)toolbox.getRootBody());
        this.forwardDynamicsCalculator.setGravitionalAcceleration(-Math.abs(toolbox.getGravityZ()));
        this.yoResidualRootJointForce = toolbox.getYoResidualRootJointForce();
        this.yoResidualRootJointTorque = toolbox.getYoResidualRootJointTorque();
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.optimizationControlModule.initialize();
        this.virtualModelController.reset();
        this.forwardDynamicsCalculator.setExternalWrenchesToZero();
        this.yoDesiredMomentumRateLinear.setToZero();
        this.yoDesiredMomentumRateAngular.setToZero();
    }

    public void initialize() {
        this.optimizationControlModule.initialize();
        this.virtualModelController.reset();
        this.planeContactWrenchProcessor.initialize();
        this.forwardDynamicsCalculator.compute();
    }

    public void compute() {
        VirtualModelControlSolution virtualModelControlSolution;
        try {
            virtualModelControlSolution = this.optimizationControlModule.compute();
        }
        catch (VirtualModelControlModuleException virtualModelControlModuleException) {
            virtualModelControlSolution = virtualModelControlModuleException.getVirtualModelControlSolution();
        }
        Map<RigidBodyBasics, Wrench> externalWrenchSolution = virtualModelControlSolution.getExternalWrenchSolution();
        List<RigidBodyBasics> rigidBodiesWithExternalWrench = virtualModelControlSolution.getRigidBodiesWithExternalWrench();
        SpatialForceReadOnly centroidalMomentumRateSolution = virtualModelControlSolution.getCentroidalMomentumRateSolution();
        this.yoAchievedMomentumRateLinear.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumRateSolution.getLinearPart());
        this.yoAchievedMomentumRateAngular.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumRateSolution.getAngularPart());
        this.achievedMomentumRateLinear.setIncludingFrame((FrameTuple3DReadOnly)this.yoAchievedMomentumRateLinear);
        for (int bodyIndex = 0; bodyIndex < rigidBodiesWithExternalWrench.size(); ++bodyIndex) {
            RigidBodyBasics rigidBody = rigidBodiesWithExternalWrench.get(bodyIndex);
            externalWrenchSolution.get(rigidBody).negate();
            this.virtualModelController.addExternalWrench(this.controlRootBody, rigidBody, externalWrenchSolution.get(rigidBody));
        }
        this.virtualModelController.populateTorqueSolution(virtualModelControlSolution);
        DMatrixRMaj jointTorquesSolution = virtualModelControlSolution.getJointTorques();
        for (int i = 0; i < rigidBodiesWithExternalWrench.size(); ++i) {
            RigidBodyBasics rigidBody = rigidBodiesWithExternalWrench.get(i);
            Wrench externalWrench = externalWrenchSolution.get(rigidBody);
            externalWrench.setBodyFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
            externalWrench.negate();
            this.forwardDynamicsCalculator.setExternalWrench((RigidBodyReadOnly)rigidBody, (WrenchReadOnly)externalWrench);
        }
        for (OneDoFJointBasics joint : this.controlledOneDoFJoints) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            JointDesiredOutputBasics jointDesiredOutput = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            jointDesiredOutput.setDesiredTorque(jointTorquesSolution.get(jointIndex, 0));
        }
        this.boundCalculator.enforceJointTorqueLimits(this.lowLevelOneDoFJointDesiredDataHolder);
        this.forwardDynamicsCalculator.compute((DMatrix)jointTorquesSolution);
        for (OneDoFJointBasics joint : this.controlledOneDoFJoints) {
            JointDesiredOutputBasics jointDesiredOutput = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            jointDesiredOutput.setDesiredAcceleration(this.forwardDynamicsCalculator.getComputedJointAcceleration((JointReadOnly)joint).get(0, 0));
        }
        if (this.rootJoint != null) {
            this.rootJointDesiredConfiguration.setDesiredAcceleration(this.forwardDynamicsCalculator.getComputedJointAcceleration((JointReadOnly)this.rootJoint));
        }
        this.jointAccelerationIntegrationCalculator.computeAndUpdateDataHolder(this.lowLevelOneDoFJointDesiredDataHolder);
        if (this.rootJoint != null) {
            this.residualRootJointWrench.setIncludingFrame((WrenchReadOnly)this.rootJoint.getJointWrench());
            this.residualRootJointTorque.setIncludingFrame((FrameTuple3DReadOnly)this.residualRootJointWrench.getAngularPart());
            this.residualRootJointForce.setIncludingFrame((FrameTuple3DReadOnly)this.residualRootJointWrench.getLinearPart());
            this.yoResidualRootJointForce.setMatchingFrame((FrameTuple3DReadOnly)this.residualRootJointForce);
            this.yoResidualRootJointTorque.setMatchingFrame((FrameTuple3DReadOnly)this.residualRootJointTorque);
        }
        this.planeContactWrenchProcessor.compute(externalWrenchSolution);
        this.wrenchVisualizer.visualize(externalWrenchSolution);
    }

    public void submitVirtualModelControlCommandList(VirtualModelControlCommandList virtualModelControlCommandList) {
        block15: while (virtualModelControlCommandList.getNumberOfCommands() > 0) {
            VirtualModelControlCommand<?> command = virtualModelControlCommandList.pollCommand();
            switch (command.getCommandType()) {
                case MOMENTUM: {
                    this.optimizationControlModule.submitMomentumRateCommand((MomentumRateCommand)command);
                    this.recordMomentumRate((MomentumRateCommand)command);
                    continue block15;
                }
                case EXTERNAL_WRENCH: {
                    this.handleExternalWrenchCommand((ExternalWrenchCommand)command);
                    continue block15;
                }
                case PLANE_CONTACT_STATE: {
                    this.optimizationControlModule.submitPlaneContactStateCommand((PlaneContactStateCommand)command);
                    continue block15;
                }
                case CONTACT_WRENCH: {
                    this.optimizationControlModule.submitContactWrenchCommand((ContactWrenchCommand)command);
                    continue block15;
                }
                case CENTER_OF_PRESSURE: {
                    this.optimizationControlModule.submitCenterOfPressureCommand((CenterOfPressureCommand)command);
                    continue block15;
                }
                case VIRTUAL_WRENCH: {
                    this.handleVirtualWrenchCommand((VirtualWrenchCommand)command);
                    continue block15;
                }
                case VIRTUAL_FORCE: {
                    this.handleVirtualForceCommand((VirtualForceCommand)command);
                    continue block15;
                }
                case VIRTUAL_TORQUE: {
                    this.handleVirtualTorqueCommand((VirtualTorqueCommand)command);
                    continue block15;
                }
                case JOINTSPACE: {
                    this.virtualModelController.addJointTorqueCommand((JointTorqueCommand)command);
                    continue block15;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.boundCalculator.submitJointLimitEnforcementCommand((JointLimitEnforcementCommand)command);
                    continue block15;
                }
                case JOINT_ACCELERATION_INTEGRATION: {
                    this.jointAccelerationIntegrationCalculator.submitJointAccelerationIntegrationCommand((JointAccelerationIntegrationCommand)command);
                    continue block15;
                }
                case COMMAND_LIST: {
                    this.submitVirtualModelControlCommandList((VirtualModelControlCommandList)command);
                    continue block15;
                }
                case OPTIMIZATION_SETTINGS: {
                    this.optimizationControlModule.submitOptimizationSettingsCommand((VirtualModelControlOptimizationSettingsCommand)command);
                    continue block15;
                }
            }
            throw new RuntimeException("The command type: " + (Object)((Object)command.getCommandType()) + " is not handled by the Virtual Model Control solver mode.");
        }
    }

    private void recordMomentumRate(MomentumRateCommand command) {
        DMatrixRMaj momentumRate = command.getMomentumRate();
        this.yoDesiredMomentumRateAngular.addX(momentumRate.get(0, 0));
        this.yoDesiredMomentumRateAngular.addY(momentumRate.get(1, 0));
        this.yoDesiredMomentumRateAngular.addZ(momentumRate.get(2, 0));
        this.yoDesiredMomentumRateLinear.addX(momentumRate.get(3, 0));
        this.yoDesiredMomentumRateLinear.addY(momentumRate.get(4, 0));
        this.yoDesiredMomentumRateLinear.addZ(momentumRate.get(5, 0));
    }

    private void handleVirtualWrenchCommand(VirtualWrenchCommand commandToSubmit) {
        if (commandToSubmit.getEndEffector() == this.controlRootBody) {
            commandToSubmit.getSelectionMatrix(this.tempSelectionMatrix);
            commandToSubmit.getDesiredWrench(this.controlFrame, this.tempWrench);
            this.tempTorque.set((FrameTuple3DReadOnly)this.tempWrench.getAngularPart());
            this.tempForce.set((FrameTuple3DReadOnly)this.tempWrench.getLinearPart());
            this.tempTorque.changeFrame(worldFrame);
            this.tempForce.changeFrame(worldFrame);
            this.rootBodyDefaultMomentumCommand.setSelectionMatrix(this.tempSelectionMatrix);
            this.rootBodyDefaultMomentumCommand.setWeights((Tuple3DReadOnly)this.defaultAngularMomentumWeight, (Tuple3DReadOnly)this.defaultLinearMomentumWeight);
            this.rootBodyDefaultMomentumCommand.setMomentumRate(this.tempTorque, this.tempForce);
            this.optimizationControlModule.submitMomentumRateCommand(this.rootBodyDefaultMomentumCommand);
            this.recordMomentumRate(this.rootBodyDefaultMomentumCommand);
            return;
        }
        this.virtualModelController.addVirtualEffortCommand(commandToSubmit);
    }

    private void handleVirtualForceCommand(VirtualForceCommand commandToSubmit) {
        if (commandToSubmit.getEndEffector() == this.controlRootBody) {
            commandToSubmit.getSelectionMatrix(this.tempSelectionMatrix);
            commandToSubmit.getDesiredLinearForce(this.controlFrame, this.tempForce);
            this.tempForce.changeFrame(worldFrame);
            this.rootBodyDefaultMomentumCommand.setSelectionMatrix(this.tempSelectionMatrix);
            this.rootBodyDefaultMomentumCommand.setLinearWeights((Tuple3DReadOnly)this.defaultLinearMomentumWeight);
            this.rootBodyDefaultMomentumCommand.setLinearMomentumRate(this.tempForce);
            this.optimizationControlModule.submitMomentumRateCommand(this.rootBodyDefaultMomentumCommand);
            this.recordMomentumRate(this.rootBodyDefaultMomentumCommand);
            return;
        }
        this.virtualModelController.addVirtualEffortCommand(commandToSubmit);
    }

    private void handleVirtualTorqueCommand(VirtualTorqueCommand commandToSubmit) {
        if (commandToSubmit.getEndEffector() == this.controlRootBody) {
            commandToSubmit.getSelectionMatrix(this.tempSelectionMatrix);
            commandToSubmit.getDesiredAngularTorque(this.controlFrame, this.tempTorque);
            this.tempTorque.changeFrame(worldFrame);
            this.rootBodyDefaultMomentumCommand.setSelectionMatrix(this.tempSelectionMatrix);
            this.rootBodyDefaultMomentumCommand.setAngularWeights((Tuple3DReadOnly)this.defaultLinearMomentumWeight);
            this.rootBodyDefaultMomentumCommand.setAngularMomentumRate(this.tempTorque);
            this.optimizationControlModule.submitMomentumRateCommand(this.rootBodyDefaultMomentumCommand);
            this.recordMomentumRate(this.rootBodyDefaultMomentumCommand);
            return;
        }
        this.virtualModelController.addVirtualEffortCommand(commandToSubmit);
    }

    private void handleExternalWrenchCommand(ExternalWrenchCommand command) {
        this.optimizationControlModule.submitExternalWrench(command.getRigidBody(), (WrenchReadOnly)command.getExternalWrench());
    }

    public LowLevelOneDoFJointDesiredDataHolder getOutput() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.rootJointDesiredConfiguration;
    }

    public FrameVector3DReadOnly getAchievedMomentumRateLinear() {
        return this.achievedMomentumRateLinear;
    }
}

