/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.LinearMomentumRateCostCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumModuleSolution;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.momentumBasedController.PlaneContactWrenchProcessor;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.DynamicsMatrixCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.InverseDynamicsOptimizationControlModule;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointAccelerationIntegrationCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.visualizer.WrenchVisualizer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WholeBodyInverseDynamicsSolver {
    private static final boolean USE_DYNAMIC_MATRIX_CALCULATOR = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final InverseDynamicsCalculator inverseDynamicsCalculator;
    private final InverseDynamicsOptimizationControlModule optimizationControlModule;
    private final DynamicsMatrixCalculator dynamicsMatrixCalculator;
    private final FloatingJointBasics rootJoint;
    private final RootJointDesiredConfigurationData rootJointDesiredConfiguration = new RootJointDesiredConfigurationData();
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final Map<OneDoFJointBasics, YoDouble> jointAccelerationsSolution = new HashMap<OneDoFJointBasics, YoDouble>();
    private final PlaneContactWrenchProcessor planeContactWrenchProcessor;
    private final WrenchVisualizer wrenchVisualizer;
    private final JointAccelerationIntegrationCalculator jointAccelerationIntegrationCalculator;
    private final OneDoFJointBasics[] controlledOneDoFJoints;
    private final JointBasics[] jointsToOptimizeFor;
    private final List<KinematicLoopFunction> kinematicLoopFunctions;
    private final YoFrameVector3D yoDesiredMomentumRateLinear;
    private final YoFrameVector3D yoDesiredMomentumRateAngular;
    private final YoFrameVector3D yoAchievedMomentumRateLinear;
    private final YoFrameVector3D yoAchievedMomentumRateAngular;
    private final FrameVector3D achievedMomentumRateLinear = new FrameVector3D();
    private final FrameVector3D achievedMomentumRateAngular = new FrameVector3D();
    private final Wrench residualRootJointWrench = new Wrench();
    private final FrameVector3D residualRootJointForce = new FrameVector3D();
    private final FrameVector3D residualRootJointTorque = new FrameVector3D();
    private final YoFrameVector3D yoResidualRootJointForce;
    private final YoFrameVector3D yoResidualRootJointTorque;
    private final YoBoolean minimizeJointTorques;
    private final YoBoolean areJointTorqueLimitsConsidered;
    private final double controlDT;
    private final DMatrixRMaj kinematicLoopJointTau = new DMatrixRMaj(4, 1);

    public WholeBodyInverseDynamicsSolver(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this.controlDT = toolbox.getControlDT();
        this.rootJoint = toolbox.getRootJoint();
        this.inverseDynamicsCalculator = toolbox.getInverseDynamicsCalculator();
        this.dynamicsMatrixCalculator = new DynamicsMatrixCalculator(toolbox);
        this.optimizationControlModule = new InverseDynamicsOptimizationControlModule(toolbox, this.dynamicsMatrixCalculator, this.registry);
        JointIndexHandler jointIndexHandler = toolbox.getJointIndexHandler();
        this.jointsToOptimizeFor = jointIndexHandler.getIndexedJoints();
        this.controlledOneDoFJoints = jointIndexHandler.getIndexedOneDoFJoints();
        this.kinematicLoopFunctions = toolbox.getKinematicLoopFunctions();
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])this.controlledOneDoFJoints);
        this.lowLevelOneDoFJointDesiredDataHolder.setJointsControlMode((OneDoFJointReadOnly[])this.controlledOneDoFJoints, JointDesiredControlMode.EFFORT);
        for (int i = 0; i < this.controlledOneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.controlledOneDoFJoints[i];
            YoDouble jointAccelerationSolution = new YoDouble("qdd_qp_" + joint.getName(), this.registry);
            this.jointAccelerationsSolution.put(joint, jointAccelerationSolution);
        }
        this.planeContactWrenchProcessor = toolbox.getPlaneContactWrenchProcessor();
        this.wrenchVisualizer = toolbox.getWrenchVisualizer();
        this.jointAccelerationIntegrationCalculator = new JointAccelerationIntegrationCalculator(this.controlDT, this.registry);
        this.yoDesiredMomentumRateLinear = toolbox.getYoDesiredMomentumRateLinear();
        this.yoAchievedMomentumRateLinear = toolbox.getYoAchievedMomentumRateLinear();
        this.yoDesiredMomentumRateAngular = toolbox.getYoDesiredMomentumRateAngular();
        this.yoAchievedMomentumRateAngular = toolbox.getYoAchievedMomentumRateAngular();
        this.yoResidualRootJointForce = toolbox.getYoResidualRootJointForce();
        this.yoResidualRootJointTorque = toolbox.getYoResidualRootJointTorque();
        this.minimizeJointTorques = new YoBoolean("minimizeJointTorques", this.registry);
        this.minimizeJointTorques.set(false);
        this.areJointTorqueLimitsConsidered = new YoBoolean("areJointTorqueLimitsConsidered", this.registry);
        this.areJointTorqueLimitsConsidered.set(toolbox.getOptimizationSettings().areJointTorqueLimitsConsidered());
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.optimizationControlModule.initialize();
        this.inverseDynamicsCalculator.setExternalWrenchesToZero();
        if (this.minimizeJointTorques.getValue()) {
            this.dynamicsMatrixCalculator.reset();
        }
    }

    public void initialize() {
        this.optimizationControlModule.initialize();
        this.planeContactWrenchProcessor.initialize();
        this.inverseDynamicsCalculator.compute();
        if (this.minimizeJointTorques.getValue()) {
            this.dynamicsMatrixCalculator.reset();
        }
        this.optimizationControlModule.resetRateRegularization();
        for (int i = 0; i < this.lowLevelOneDoFJointDesiredDataHolder.getNumberOfJointsWithDesiredOutput(); ++i) {
            this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput(i).clear();
        }
    }

    public void compute() {
        if (this.minimizeJointTorques.getValue()) {
            this.dynamicsMatrixCalculator.compute();
            this.optimizationControlModule.setupTorqueMinimizationCommand();
        }
        if (!this.optimizationControlModule.compute()) {
            // empty if block
        }
        MomentumModuleSolution momentumModuleSolution = this.optimizationControlModule.getMomentumModuleSolution();
        DMatrixRMaj jointAccelerations = momentumModuleSolution.getJointAccelerations();
        DMatrixRMaj rhoSolution = momentumModuleSolution.getRhoSolution();
        Map<RigidBodyBasics, Wrench> externalWrenchSolution = momentumModuleSolution.getExternalWrenchSolution();
        List<RigidBodyBasics> rigidBodiesWithExternalWrench = momentumModuleSolution.getRigidBodiesWithExternalWrench();
        SpatialForceReadOnly centroidalMomentumRateSolution = momentumModuleSolution.getCentroidalMomentumRateSolution();
        this.yoAchievedMomentumRateLinear.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumRateSolution.getLinearPart());
        this.achievedMomentumRateLinear.setIncludingFrame((FrameTuple3DReadOnly)this.yoAchievedMomentumRateLinear);
        this.yoAchievedMomentumRateAngular.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumRateSolution.getAngularPart());
        this.achievedMomentumRateAngular.setIncludingFrame((FrameTuple3DReadOnly)this.yoAchievedMomentumRateAngular);
        for (int i = 0; i < rigidBodiesWithExternalWrench.size(); ++i) {
            RigidBodyBasics rigidBody = rigidBodiesWithExternalWrench.get(i);
            this.inverseDynamicsCalculator.setExternalWrench((RigidBodyReadOnly)rigidBody, (WrenchReadOnly)externalWrenchSolution.get(rigidBody));
        }
        this.inverseDynamicsCalculator.compute((DMatrix)jointAccelerations);
        for (OneDoFJointBasics joint : this.controlledOneDoFJoints) {
            int jointIndex = this.inverseDynamicsCalculator.getInput().getJointMatrixIndexProvider().getJointDoFIndices((JointReadOnly)joint)[0];
            JointDesiredOutputBasics jointDesiredOutput = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            jointDesiredOutput.setDesiredAcceleration(jointAccelerations.get(jointIndex, 0));
            double tau = this.inverseDynamicsCalculator.getComputedJointTau((JointReadOnly)joint).get(0);
            if (this.areJointTorqueLimitsConsidered.getValue()) {
                jointDesiredOutput.setDesiredTorque(MathTools.clamp((double)tau, (double)joint.getEffortLimitLower(), (double)joint.getEffortLimitUpper()));
                continue;
            }
            jointDesiredOutput.setDesiredTorque(tau);
        }
        this.updateKinematicLoopJointEfforts();
        if (this.rootJoint != null) {
            this.rootJointDesiredConfiguration.setDesiredAcceleration(jointAccelerations, 0);
        }
        this.jointAccelerationIntegrationCalculator.computeAndUpdateDataHolder(this.lowLevelOneDoFJointDesiredDataHolder);
        if (this.rootJoint != null) {
            this.residualRootJointWrench.setIncludingFrame((WrenchReadOnly)this.rootJoint.getJointWrench());
            this.residualRootJointTorque.setIncludingFrame((FrameTuple3DReadOnly)this.residualRootJointWrench.getAngularPart());
            this.residualRootJointForce.setIncludingFrame((FrameTuple3DReadOnly)this.residualRootJointWrench.getLinearPart());
            this.yoResidualRootJointForce.setMatchingFrame((FrameTuple3DReadOnly)this.residualRootJointForce);
            this.yoResidualRootJointTorque.setMatchingFrame((FrameTuple3DReadOnly)this.residualRootJointTorque);
        }
        for (int jointIndex = 0; jointIndex < this.lowLevelOneDoFJointDesiredDataHolder.getNumberOfJointsWithDesiredOutput(); ++jointIndex) {
            OneDoFJointReadOnly joint = this.lowLevelOneDoFJointDesiredDataHolder.getOneDoFJoint(jointIndex);
            this.jointAccelerationsSolution.get(joint).set(this.lowLevelOneDoFJointDesiredDataHolder.getDesiredJointAcceleration(jointIndex));
        }
        this.planeContactWrenchProcessor.compute(externalWrenchSolution);
        if (this.wrenchVisualizer != null) {
            this.wrenchVisualizer.visualize(externalWrenchSolution);
        }
    }

    private void updateKinematicLoopJointEfforts() {
        for (int i = 0; i < this.kinematicLoopFunctions.size(); ++i) {
            OneDoFJointReadOnly loopJoint;
            int j;
            KinematicLoopFunction kinematicLoopFunction = this.kinematicLoopFunctions.get(i);
            List loopJoints = kinematicLoopFunction.getLoopJoints();
            this.kinematicLoopJointTau.reshape(loopJoints.size(), 1);
            for (j = 0; j < loopJoints.size(); ++j) {
                loopJoint = (OneDoFJointReadOnly)loopJoints.get(j);
                double tau = this.lowLevelOneDoFJointDesiredDataHolder.getDesiredJointTorque((OneDoFJointReadOnly)((OneDoFJointBasics)loopJoint));
                this.kinematicLoopJointTau.set(j, tau);
            }
            kinematicLoopFunction.adjustTau(this.kinematicLoopJointTau);
            for (j = 0; j < loopJoints.size(); ++j) {
                loopJoint = (OneDoFJointReadOnly)loopJoints.get(j);
                this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointTorque((OneDoFJointReadOnly)((OneDoFJointBasics)loopJoint), this.kinematicLoopJointTau.get(j));
            }
        }
    }

    public void submitResetIntegratorRequests(JointDesiredOutputListReadOnly jointDesiredOutputList) {
        for (int i = 0; i < this.lowLevelOneDoFJointDesiredDataHolder.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly joint = this.lowLevelOneDoFJointDesiredDataHolder.getOneDoFJoint(i);
            if (!jointDesiredOutputList.hasDataForJoint(joint)) continue;
            JointDesiredOutputReadOnly jointDesiredOutputOther = jointDesiredOutputList.getJointDesiredOutput(joint);
            this.lowLevelOneDoFJointDesiredDataHolder.setResetJointIntegrators(joint, jointDesiredOutputOther.peekResetIntegratorsRequest());
        }
    }

    public void submitInverseDynamicsCommandList(InverseDynamicsCommandList inverseDynamicsCommandList) {
        block17: for (int i = 0; i < inverseDynamicsCommandList.getNumberOfCommands(); ++i) {
            InverseDynamicsCommand<?> command = inverseDynamicsCommandList.getCommand(i);
            switch (command.getCommandType()) {
                case TASKSPACE: {
                    this.optimizationControlModule.submitSpatialAccelerationCommand((SpatialAccelerationCommand)command);
                    continue block17;
                }
                case JOINTSPACE: {
                    this.optimizationControlModule.submitJointspaceAccelerationCommand((JointspaceAccelerationCommand)command);
                    continue block17;
                }
                case MOMENTUM: {
                    this.optimizationControlModule.submitMomentumRateCommand((MomentumRateCommand)command);
                    this.recordMomentumRate((MomentumRateCommand)command);
                    continue block17;
                }
                case MOMENTUM_COST: {
                    this.optimizationControlModule.submitLinearMomentumRateCostCommand((LinearMomentumRateCostCommand)command);
                    continue block17;
                }
                case PRIVILEGED_CONFIGURATION: {
                    this.optimizationControlModule.submitPrivilegedConfigurationCommand((PrivilegedConfigurationCommand)command);
                    continue block17;
                }
                case PRIVILEGED_JOINTSPACE_COMMAND: {
                    this.optimizationControlModule.submitPrivilegedAccelerationCommand((PrivilegedJointSpaceCommand)command);
                    continue block17;
                }
                case LIMIT_REDUCTION: {
                    this.optimizationControlModule.submitJointLimitReductionCommand((JointLimitReductionCommand)command);
                    continue block17;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.optimizationControlModule.submitJointLimitEnforcementMethodCommand((JointLimitEnforcementMethodCommand)command);
                    continue block17;
                }
                case EXTERNAL_WRENCH: {
                    this.optimizationControlModule.submitExternalWrenchCommand((ExternalWrenchCommand)command);
                    continue block17;
                }
                case CONTACT_WRENCH: {
                    this.optimizationControlModule.submitContactWrenchCommand((ContactWrenchCommand)command);
                    continue block17;
                }
                case PLANE_CONTACT_STATE: {
                    this.optimizationControlModule.submitPlaneContactStateCommand((PlaneContactStateCommand)command);
                    continue block17;
                }
                case CENTER_OF_PRESSURE: {
                    this.optimizationControlModule.submitCenterOfPressureCommand((CenterOfPressureCommand)command);
                    continue block17;
                }
                case JOINT_ACCELERATION_INTEGRATION: {
                    this.jointAccelerationIntegrationCalculator.submitJointAccelerationIntegrationCommand((JointAccelerationIntegrationCommand)command);
                    continue block17;
                }
                case COMMAND_LIST: {
                    this.submitInverseDynamicsCommandList((InverseDynamicsCommandList)command);
                    continue block17;
                }
                case OPTIMIZATION_SETTINGS: {
                    this.submitOptimizationSettingsCommand((InverseDynamicsOptimizationSettingsCommand)command);
                    continue block17;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)command.getCommandType()) + " is not handled.");
                }
            }
        }
        inverseDynamicsCommandList.clear();
    }

    private void submitOptimizationSettingsCommand(InverseDynamicsOptimizationSettingsCommand command) {
        if (Double.isFinite(command.getJointTorqueWeight()) && !this.minimizeJointTorques.getValue()) {
            this.minimizeJointTorques.set(true);
        }
        this.optimizationControlModule.submitOptimizationSettingsCommand(command);
    }

    private void recordMomentumRate(MomentumRateCommand command) {
        DMatrixRMaj momentumRate = command.getMomentumRate();
        this.yoDesiredMomentumRateAngular.set(0, (DMatrix)momentumRate);
        this.yoDesiredMomentumRateLinear.set(3, (DMatrix)momentumRate);
    }

    public LowLevelOneDoFJointDesiredDataHolder getOutput() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.rootJointDesiredConfiguration;
    }

    public CenterOfPressureDataHolder getDesiredCenterOfPressureDataHolder() {
        return this.planeContactWrenchProcessor.getDesiredCenterOfPressureDataHolder();
    }

    public FrameVector3DReadOnly getAchievedMomentumRateLinear() {
        return this.achievedMomentumRateLinear;
    }

    public FrameVector3DReadOnly getAchievedMomentumRateAngular() {
        return this.achievedMomentumRateAngular;
    }

    public JointBasics[] getJointsToOptimizeFors() {
        return this.jointsToOptimizeFor;
    }
}

