/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerFactory;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.jointspace.OneDoFJointFeedbackController;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace.CenterOfMassFeedbackController;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace.OrientationFeedbackController;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace.PointFeedbackController;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace.SpatialFeedbackController;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class WholeBodyFeedbackController {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final InverseDynamicsCommandList inverseDynamicsOutput = new InverseDynamicsCommandList();
    private final InverseKinematicsCommandList inverseKinematicsOutput = new InverseKinematicsCommandList();
    private final VirtualModelControlCommandList virtualModelControlOutput = new VirtualModelControlCommandList();
    private final List<FeedbackControllerInterface> allControllers = new ArrayList<FeedbackControllerInterface>();
    private final YoBoolean dynamicControllerConstructionEnabled = new YoBoolean("dynamicControllerConstructionEnabled", this.registry);
    private CenterOfMassFeedbackController centerOfMassFeedbackController;
    private final Map<RigidBodyBasics, List<SpatialFeedbackController>> spatialFeedbackControllerMap = new HashMap<RigidBodyBasics, List<SpatialFeedbackController>>();
    private final Map<RigidBodyBasics, List<PointFeedbackController>> pointFeedbackControllerMap = new HashMap<RigidBodyBasics, List<PointFeedbackController>>();
    private final Map<RigidBodyBasics, List<OrientationFeedbackController>> orientationFeedbackControllerMap = new HashMap<RigidBodyBasics, List<OrientationFeedbackController>>();
    private final Map<OneDoFJointBasics, OneDoFJointFeedbackController> oneDoFJointFeedbackControllerMap = new HashMap<OneDoFJointBasics, OneDoFJointFeedbackController>();
    private final WholeBodyControlCoreToolbox coreToolbox;
    private final FeedbackControllerToolbox feedbackControllerToolbox;
    private final FeedbackControllerFactory feedbackControllerFactory;
    private final ExecutionTimer feedbackControllerTimer = new ExecutionTimer("wholeBodyFeedbackControllerTimer", 1.0, this.registry);
    private final ExecutionTimer achievedComputationTimer = new ExecutionTimer("achievedComputationTimer", 1.0, this.registry);

    public WholeBodyFeedbackController(WholeBodyControlCoreToolbox coreToolbox, FeedbackControllerTemplate feedbackControllerTemplate, YoRegistry parentRegistry) {
        this.coreToolbox = coreToolbox;
        this.feedbackControllerToolbox = new FeedbackControllerToolbox(coreToolbox.getFeedbackControllerSettings(), this.registry);
        if (feedbackControllerTemplate != null) {
            this.feedbackControllerFactory = feedbackControllerTemplate.getFeedbackControllerFactory();
            this.feedbackControllerFactory.configure(coreToolbox, this.feedbackControllerToolbox, this.registry);
            this.registerControllers(feedbackControllerTemplate);
            parentRegistry.addChild(this.registry);
        } else {
            this.feedbackControllerFactory = null;
        }
    }

    private void registerControllers(FeedbackControllerTemplate template) {
        this.dynamicControllerConstructionEnabled.set(template.isDynamicControllerConstructionAllowed());
        template.getSpatialFeedbackControllerTemplate().forEach(this::registerSpatialControllers);
        template.getPointFeedbackControllerTemplate().forEach(this::registerPointControllers);
        template.getOrientationFeedbackControllerTemplate().forEach(this::registerOrientationControllers);
        template.getOneDoFJointFeedbackControllerTemplate().forEach(this::registerOneDoFJointControllers);
        if (template.isCenterOfMassFeedbackControllerEnabled()) {
            this.registerCenterOfMassController();
        }
    }

    private void registerSpatialControllers(RigidBodyBasics endEffector, int numberOfControllers) {
        ArrayList<SpatialFeedbackController> endEffectorControllers = new ArrayList<SpatialFeedbackController>();
        this.spatialFeedbackControllerMap.put(endEffector, endEffectorControllers);
        for (int controllerIndex = 0; controllerIndex < numberOfControllers; ++controllerIndex) {
            SpatialFeedbackController controller = this.feedbackControllerFactory.buildSpatialFeedbackController(endEffector, controllerIndex);
            endEffectorControllers.add(controller);
            this.allControllers.add(controller);
        }
    }

    private void registerPointControllers(RigidBodyBasics endEffector, int numberOfControllers) {
        ArrayList<PointFeedbackController> endEffectorControllers = new ArrayList<PointFeedbackController>();
        this.pointFeedbackControllerMap.put(endEffector, endEffectorControllers);
        for (int controllerIndex = 0; controllerIndex < numberOfControllers; ++controllerIndex) {
            PointFeedbackController controller = this.feedbackControllerFactory.buildPointFeedbackController(endEffector, controllerIndex);
            endEffectorControllers.add(controller);
            this.allControllers.add(controller);
        }
    }

    private void registerOrientationControllers(RigidBodyBasics endEffector, int numberOfControllers) {
        ArrayList<OrientationFeedbackController> endEffectorControllers = new ArrayList<OrientationFeedbackController>();
        this.orientationFeedbackControllerMap.put(endEffector, endEffectorControllers);
        for (int controllerIndex = 0; controllerIndex < numberOfControllers; ++controllerIndex) {
            OrientationFeedbackController controller = this.feedbackControllerFactory.buildOrientationFeedbackController(endEffector, controllerIndex);
            endEffectorControllers.add(controller);
            this.allControllers.add(controller);
        }
    }

    private void registerOneDoFJointControllers(OneDoFJointBasics joint) {
        OneDoFJointFeedbackController controller = this.feedbackControllerFactory.buildOneDoFJointFeedbackController(joint);
        this.oneDoFJointFeedbackControllerMap.put(joint, controller);
        this.allControllers.add(controller);
    }

    private void registerCenterOfMassController() {
        this.centerOfMassFeedbackController = this.feedbackControllerFactory.buildCenterOfMassFeedbackController();
        this.allControllers.add(this.centerOfMassFeedbackController);
    }

    public void initialize() {
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            controller.initialize();
        }
    }

    public void reset() {
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            controller.setEnabled(false);
        }
    }

    public void computeInverseDynamics() {
        this.feedbackControllerTimer.startMeasurement();
        this.inverseDynamicsOutput.clear();
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            if (controller.isEnabled()) {
                controller.computeInverseDynamics();
                this.inverseDynamicsOutput.addCommand(controller.getInverseDynamicsOutput());
                continue;
            }
            controller.initialize();
        }
        this.feedbackControllerToolbox.registerFeedbackControllerOutput(this.inverseDynamicsOutput);
        this.feedbackControllerTimer.stopMeasurement();
    }

    public void computeInverseKinematics() {
        this.feedbackControllerTimer.startMeasurement();
        this.inverseKinematicsOutput.clear();
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            if (controller.isEnabled()) {
                controller.computeInverseKinematics();
                this.inverseKinematicsOutput.addCommand(controller.getInverseKinematicsOutput());
                continue;
            }
            controller.initialize();
        }
        this.feedbackControllerToolbox.clearUnusedData();
        this.feedbackControllerToolbox.registerFeedbackControllerOutput(this.inverseKinematicsOutput);
        this.feedbackControllerTimer.stopMeasurement();
    }

    public void computeVirtualModelControl() {
        this.feedbackControllerTimer.startMeasurement();
        this.virtualModelControlOutput.clear();
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            if (controller.isEnabled()) {
                controller.computeVirtualModelControl();
                this.virtualModelControlOutput.addCommand(controller.getVirtualModelControlOutput());
                continue;
            }
            controller.initialize();
        }
        this.feedbackControllerToolbox.clearUnusedData();
        this.feedbackControllerToolbox.registerFeedbackControllerOutput(this.virtualModelControlOutput);
        this.feedbackControllerTimer.stopMeasurement();
    }

    public void computeAchievedAccelerations() {
        this.achievedComputationTimer.startMeasurement();
        for (int i = 0; i < this.allControllers.size(); ++i) {
            FeedbackControllerInterface controller = this.allControllers.get(i);
            if (!controller.isEnabled()) continue;
            controller.computeAchievedAcceleration();
        }
        this.achievedComputationTimer.stopMeasurement();
    }

    public void submitFeedbackControlCommandList(WholeBodyControllerCoreMode activeControlMode, FeedbackControlCommandList feedbackControlCommandList) {
        block8: for (int commandIndex = 0; commandIndex < feedbackControlCommandList.getNumberOfCommands(); ++commandIndex) {
            FeedbackControlCommand<?> feedbackControlCommand = feedbackControlCommandList.getCommand(commandIndex);
            ControllerCoreCommandType commandType = feedbackControlCommand.getCommandType();
            switch (commandType) {
                case TASKSPACE: {
                    this.submitSpatialFeedbackControlCommand(activeControlMode, (SpatialFeedbackControlCommand)feedbackControlCommand);
                    continue block8;
                }
                case POINT: {
                    this.submitPointFeedbackControlCommand(activeControlMode, (PointFeedbackControlCommand)feedbackControlCommand);
                    continue block8;
                }
                case ORIENTATION: {
                    this.submitOrientationFeedbackControlCommand(activeControlMode, (OrientationFeedbackControlCommand)feedbackControlCommand);
                    continue block8;
                }
                case JOINTSPACE: {
                    this.submitOneDoFJointFeedbackControlCommand(activeControlMode, (OneDoFJointFeedbackControlCommand)feedbackControlCommand);
                    continue block8;
                }
                case MOMENTUM: {
                    this.submitCenterOfMassFeedbackControlCommand(activeControlMode, (CenterOfMassFeedbackControlCommand)feedbackControlCommand);
                    continue block8;
                }
                case COMMAND_LIST: {
                    this.submitFeedbackControlCommandList(activeControlMode, (FeedbackControlCommandList)feedbackControlCommand);
                    continue block8;
                }
                default: {
                    throw new FeedbackControllerException("The command type: " + (Object)((Object)commandType) + " is not handled.");
                }
            }
        }
    }

    private void submitSpatialFeedbackControlCommand(WholeBodyControllerCoreMode activeControlMode, SpatialFeedbackControlCommand feedbackControlCommand) {
        SpatialFeedbackController controller;
        int controllerIndex;
        WholeBodyFeedbackController.checkRequestedControlMode(activeControlMode, feedbackControlCommand.getControlMode());
        RigidBodyBasics endEffector = feedbackControlCommand.getEndEffector();
        List<SpatialFeedbackController> endEffectorControllers = this.spatialFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("No feedback controller was created for the end-effector " + endEffector.getName() + ".");
            }
            this.registerSpatialControllers(endEffector, 1);
            endEffectorControllers = this.spatialFeedbackControllerMap.get(endEffector);
        }
        SpatialFeedbackController nextControllerAvailable = null;
        for (controllerIndex = 0; controllerIndex < endEffectorControllers.size(); ++controllerIndex) {
            controller = endEffectorControllers.get(controllerIndex);
            if (controller.isEnabled() || this.isOrientationControllerCreatedAndEnabled(endEffector, controllerIndex) || this.isPointControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
            nextControllerAvailable = controller;
        }
        if (nextControllerAvailable == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("Could not find a controller available for the end-effector: " + endEffector.getName() + ", number of controllers: " + endEffectorControllers.size());
            }
            while (nextControllerAvailable == null) {
                controllerIndex = endEffectorControllers.size();
                controller = new SpatialFeedbackController(endEffector, controllerIndex, this.coreToolbox, this.feedbackControllerToolbox, this.registry);
                endEffectorControllers.add(controller);
                this.allControllers.add(controller);
                if (this.isOrientationControllerCreatedAndEnabled(endEffector, controllerIndex) || this.isPointControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
                nextControllerAvailable = controller;
            }
        }
        nextControllerAvailable.submitFeedbackControlCommand(feedbackControlCommand);
        nextControllerAvailable.setEnabled(true);
    }

    private void submitPointFeedbackControlCommand(WholeBodyControllerCoreMode activeControlMode, PointFeedbackControlCommand feedbackControlCommand) {
        PointFeedbackController controller;
        int controllerIndex;
        WholeBodyFeedbackController.checkRequestedControlMode(activeControlMode, feedbackControlCommand.getControlMode());
        RigidBodyBasics endEffector = feedbackControlCommand.getEndEffector();
        List<PointFeedbackController> endEffectorControllers = this.pointFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("No feedback controller was created for the end-effector " + endEffector.getName() + ".");
            }
            this.registerPointControllers(endEffector, 1);
            endEffectorControllers = this.pointFeedbackControllerMap.get(endEffector);
        }
        PointFeedbackController nextControllerAvailable = null;
        for (controllerIndex = 0; controllerIndex < endEffectorControllers.size(); ++controllerIndex) {
            controller = endEffectorControllers.get(controllerIndex);
            if (controller.isEnabled() || this.isSpatialControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
            nextControllerAvailable = controller;
        }
        if (nextControllerAvailable == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("Could not find a controller available for the end-effector: " + endEffector.getName() + ", number of controllers: " + endEffectorControllers.size());
            }
            while (nextControllerAvailable == null) {
                controllerIndex = endEffectorControllers.size();
                controller = new PointFeedbackController(endEffector, controllerIndex, this.coreToolbox, this.feedbackControllerToolbox, this.registry);
                endEffectorControllers.add(controller);
                this.allControllers.add(controller);
                if (this.isSpatialControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
                nextControllerAvailable = controller;
            }
        }
        nextControllerAvailable.submitFeedbackControlCommand(feedbackControlCommand);
        nextControllerAvailable.setEnabled(true);
    }

    private void submitOrientationFeedbackControlCommand(WholeBodyControllerCoreMode activeControlMode, OrientationFeedbackControlCommand feedbackControlCommand) {
        OrientationFeedbackController controller;
        int controllerIndex;
        WholeBodyFeedbackController.checkRequestedControlMode(activeControlMode, feedbackControlCommand.getControlMode());
        RigidBodyBasics endEffector = feedbackControlCommand.getEndEffector();
        List<OrientationFeedbackController> endEffectorControllers = this.orientationFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("No feedback controller was created for the end-effector " + endEffector.getName() + ".");
            }
            this.registerOrientationControllers(endEffector, 1);
            endEffectorControllers = this.orientationFeedbackControllerMap.get(endEffector);
        }
        OrientationFeedbackController nextControllerAvailable = null;
        for (controllerIndex = 0; controllerIndex < endEffectorControllers.size(); ++controllerIndex) {
            controller = endEffectorControllers.get(controllerIndex);
            if (controller.isEnabled() || this.isSpatialControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
            nextControllerAvailable = controller;
        }
        if (nextControllerAvailable == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("Could not find a controller available for the end-effector: " + endEffector.getName() + ", number of controllers: " + endEffectorControllers.size());
            }
            while (nextControllerAvailable == null) {
                controllerIndex = endEffectorControllers.size();
                controller = new OrientationFeedbackController(endEffector, controllerIndex, this.coreToolbox, this.feedbackControllerToolbox, this.registry);
                endEffectorControllers.add(controller);
                this.allControllers.add(controller);
                if (this.isSpatialControllerCreatedAndEnabled(endEffector, controllerIndex)) continue;
                nextControllerAvailable = controller;
            }
        }
        nextControllerAvailable.submitFeedbackControlCommand(feedbackControlCommand);
        nextControllerAvailable.setEnabled(true);
    }

    private boolean isSpatialControllerCreatedAndEnabled(RigidBodyBasics endEffector, int controllerIndex) {
        List<SpatialFeedbackController> endEffectorControllers = this.spatialFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            return false;
        }
        if (endEffectorControllers.size() <= controllerIndex) {
            return false;
        }
        return endEffectorControllers.get(controllerIndex).isEnabled();
    }

    private boolean isPointControllerCreatedAndEnabled(RigidBodyBasics endEffector, int controllerIndex) {
        List<PointFeedbackController> endEffectorControllers = this.pointFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            return false;
        }
        if (endEffectorControllers.size() <= controllerIndex) {
            return false;
        }
        return endEffectorControllers.get(controllerIndex).isEnabled();
    }

    private boolean isOrientationControllerCreatedAndEnabled(RigidBodyBasics endEffector, int controllerIndex) {
        List<OrientationFeedbackController> endEffectorControllers = this.orientationFeedbackControllerMap.get(endEffector);
        if (endEffectorControllers == null) {
            return false;
        }
        if (endEffectorControllers.size() <= controllerIndex) {
            return false;
        }
        return endEffectorControllers.get(controllerIndex).isEnabled();
    }

    private void submitOneDoFJointFeedbackControlCommand(WholeBodyControllerCoreMode activeControlMode, OneDoFJointFeedbackControlCommand feedbackControlCommand) {
        WholeBodyFeedbackController.checkRequestedControlMode(activeControlMode, feedbackControlCommand.getControlMode());
        OneDoFJointBasics joint = feedbackControlCommand.getJoint();
        OneDoFJointFeedbackController controller = this.oneDoFJointFeedbackControllerMap.get(joint);
        if (controller == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("No feedback controller was created for the joint " + joint.getName() + ".");
            }
            this.registerOneDoFJointControllers(joint);
            controller = this.oneDoFJointFeedbackControllerMap.get(joint);
        }
        if (controller.isEnabled()) {
            throw new FeedbackControllerException("Cannot submit more than one feedback control command to the same controller. Controller joint: " + joint.getName());
        }
        controller.submitFeedbackControlCommand(feedbackControlCommand);
        controller.setEnabled(true);
    }

    private void submitCenterOfMassFeedbackControlCommand(WholeBodyControllerCoreMode activeControlMode, CenterOfMassFeedbackControlCommand feedbackControlCommand) {
        WholeBodyFeedbackController.checkRequestedControlMode(activeControlMode, feedbackControlCommand.getControlMode());
        if (this.centerOfMassFeedbackController == null) {
            if (!this.dynamicControllerConstructionEnabled.getValue()) {
                throw new FeedbackControllerException("No feedback controller was created for the center of mass.");
            }
            this.registerCenterOfMassController();
        }
        this.centerOfMassFeedbackController.submitFeedbackControlCommand(feedbackControlCommand);
        this.centerOfMassFeedbackController.setEnabled(true);
    }

    private static void checkRequestedControlMode(WholeBodyControllerCoreMode activeControlMode, WholeBodyControllerCoreMode requestedControlMode) {
        if (activeControlMode != requestedControlMode) {
            throw new FeedbackControllerException("Incompatible feedback control command: command requires: " + (Object)((Object)requestedControlMode) + ", current mode: " + (Object)((Object)activeControlMode));
        }
    }

    public InverseDynamicsCommandList getInverseDynamicsOutput() {
        return this.inverseDynamicsOutput;
    }

    public InverseKinematicsCommandList getInverseKinematicsOutput() {
        return this.inverseKinematicsOutput;
    }

    public VirtualModelControlCommandList getVirtualModelControlOutput() {
        return this.virtualModelControlOutput;
    }

    public FeedbackControllerDataHolderReadOnly getWholeBodyFeedbackControllerDataHolder() {
        return this.feedbackControllerToolbox;
    }
}

