/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyFeedbackController;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyInverseDynamicsSolver;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyInverseKinematicsSolver;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyVirtualModelControlSolver;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.DesiredExternalWrenchHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataBasics;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class WholeBodyControllerCore {
    private static final boolean DEBUG = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoEnum<WholeBodyControllerCoreMode> currentMode = new YoEnum("currentControllerCoreMode", this.registry, WholeBodyControllerCoreMode.class);
    private final YoInteger numberOfFBControllerEnabled = new YoInteger("numberOfFBControllerEnabled", this.registry);
    private final WholeBodyFeedbackController feedbackController;
    private final WholeBodyInverseDynamicsSolver inverseDynamicsSolver;
    private final WholeBodyInverseKinematicsSolver inverseKinematicsSolver;
    private final WholeBodyVirtualModelControlSolver virtualModelControlSolver;
    private final ControllerCoreOutput controllerCoreOutput;
    private final RootJointDesiredConfigurationDataBasics rootJointDesiredConfigurationData;
    private final JointDesiredOutputListBasics jointDesiredOutputList;
    private OneDoFJointBasics[] controlledOneDoFJoints;
    private final ExecutionTimer controllerCoreComputeTimer = new ExecutionTimer("controllerCoreComputeTimer", 1.0, this.registry);
    private final ExecutionTimer controllerCoreSubmitTimer = new ExecutionTimer("controllerCoreSubmitTimer", 1.0, this.registry);

    @Deprecated
    public WholeBodyControllerCore(WholeBodyControlCoreToolbox toolbox, FeedbackControlCommandList allPossibleCommands, YoRegistry parentRegistry) {
        this(toolbox, allPossibleCommands, null, parentRegistry);
    }

    @Deprecated
    public WholeBodyControllerCore(WholeBodyControlCoreToolbox toolbox, FeedbackControlCommandList allPossibleCommands, JointDesiredOutputList lowLevelControllerOutput, YoRegistry parentRegistry) {
        this(toolbox, new FeedbackControllerTemplate(allPossibleCommands), lowLevelControllerOutput, parentRegistry);
    }

    public WholeBodyControllerCore(WholeBodyControlCoreToolbox toolbox, FeedbackControllerTemplate feedbackControllerTemplate, YoRegistry parentRegistry) {
        this(toolbox, feedbackControllerTemplate, null, parentRegistry);
    }

    public WholeBodyControllerCore(WholeBodyControlCoreToolbox toolbox, FeedbackControllerTemplate feedbackControllerTemplate, JointDesiredOutputList lowLevelControllerOutput, YoRegistry parentRegistry) {
        DesiredExternalWrenchHolder desiredExternalWrenchHolder;
        CenterOfPressureDataHolder desiredCenterOfPressureDataHolder;
        this.feedbackController = new WholeBodyFeedbackController(toolbox, feedbackControllerTemplate, this.registry);
        this.inverseDynamicsSolver = toolbox.isEnableInverseDynamicsModule() ? new WholeBodyInverseDynamicsSolver(toolbox, this.registry) : null;
        this.inverseKinematicsSolver = toolbox.isEnableInverseKinematicsModule() ? new WholeBodyInverseKinematicsSolver(toolbox, this.registry) : null;
        this.virtualModelControlSolver = toolbox.isEnableVirtualModelControlModule() ? new WholeBodyVirtualModelControlSolver(toolbox, this.registry) : null;
        if (this.inverseDynamicsSolver == null && this.inverseKinematicsSolver == null && this.virtualModelControlSolver == null) {
            throw new RuntimeException("Controller core is not properly setup, none of the control modes is enabled.");
        }
        JointIndexHandler jointIndexHandler = toolbox.getJointIndexHandler();
        this.controlledOneDoFJoints = jointIndexHandler.getIndexedOneDoFJoints();
        FloatingJointBasics rootJoint = toolbox.getRootJoint();
        this.rootJointDesiredConfigurationData = rootJoint != null ? new RootJointDesiredConfigurationData() : null;
        this.jointDesiredOutputList = new LowLevelOneDoFJointDesiredDataHolder();
        if (this.inverseDynamicsSolver != null || this.virtualModelControlSolver != null) {
            desiredCenterOfPressureDataHolder = toolbox.getDesiredCenterOfPressureDataHolder();
            desiredExternalWrenchHolder = toolbox.getDesiredExternalWrenchHolder();
        } else {
            desiredCenterOfPressureDataHolder = null;
            desiredExternalWrenchHolder = null;
        }
        this.controllerCoreOutput = new ControllerCoreOutput(desiredCenterOfPressureDataHolder, desiredExternalWrenchHolder, this.controlledOneDoFJoints, lowLevelControllerOutput);
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        this.feedbackController.initialize();
        if (this.inverseDynamicsSolver != null) {
            this.inverseDynamicsSolver.initialize();
        }
        if (this.inverseKinematicsSolver != null) {
            this.inverseKinematicsSolver.reset();
        }
        if (this.virtualModelControlSolver != null) {
            this.virtualModelControlSolver.initialize();
        }
        this.jointDesiredOutputList.clear();
    }

    public void reset() {
        this.feedbackController.reset();
        switch ((WholeBodyControllerCoreMode)this.currentMode.getEnumValue()) {
            case INVERSE_DYNAMICS: {
                if (this.inverseDynamicsSolver != null) {
                    this.inverseDynamicsSolver.reset();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + "is not handled.");
            }
            case INVERSE_KINEMATICS: {
                if (this.inverseKinematicsSolver != null) {
                    this.inverseKinematicsSolver.reset();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + "is not handled.");
            }
            case VIRTUAL_MODEL: {
                if (this.virtualModelControlSolver != null) {
                    this.virtualModelControlSolver.reset();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + "is not handled.");
            }
            case OFF: {
                break;
            }
            default: {
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
        }
        this.jointDesiredOutputList.clear();
    }

    public void submitControllerCoreCommand(ControllerCoreCommandInterface controllerCoreCommand) {
        this.controllerCoreSubmitTimer.startMeasurement();
        this.reset();
        boolean reinitializationRequested = controllerCoreCommand.isReinitializationRequested();
        this.currentMode.set((Enum)controllerCoreCommand.getControllerCoreMode());
        switch ((WholeBodyControllerCoreMode)this.currentMode.getEnumValue()) {
            case INVERSE_DYNAMICS: {
                if (this.inverseDynamicsSolver != null) {
                    if (reinitializationRequested) {
                        this.inverseDynamicsSolver.initialize();
                    }
                    this.feedbackController.submitFeedbackControlCommandList((WholeBodyControllerCoreMode)this.currentMode.getValue(), controllerCoreCommand.getFeedbackControlCommandList());
                    this.inverseDynamicsSolver.submitInverseDynamicsCommandList(controllerCoreCommand.getInverseDynamicsCommandList());
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case INVERSE_KINEMATICS: {
                if (this.inverseKinematicsSolver != null) {
                    this.feedbackController.submitFeedbackControlCommandList((WholeBodyControllerCoreMode)this.currentMode.getValue(), controllerCoreCommand.getFeedbackControlCommandList());
                    this.inverseKinematicsSolver.submitInverseKinematicsCommandList(controllerCoreCommand.getInverseKinematicsCommandList());
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case VIRTUAL_MODEL: {
                if (this.virtualModelControlSolver != null) {
                    this.feedbackController.submitFeedbackControlCommandList((WholeBodyControllerCoreMode)this.currentMode.getValue(), controllerCoreCommand.getFeedbackControlCommandList());
                    this.virtualModelControlSolver.submitVirtualModelControlCommandList(controllerCoreCommand.getVirtualModelControlCommandList());
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case OFF: {
                break;
            }
            default: {
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
        }
        this.jointDesiredOutputList.overwriteWith(controllerCoreCommand.getLowLevelOneDoFJointDesiredDataHolder());
        if (this.rootJointDesiredConfigurationData != null) {
            this.rootJointDesiredConfigurationData.clear();
        }
        controllerCoreCommand.clear();
        this.controllerCoreSubmitTimer.stopMeasurement();
    }

    public void compute() {
        this.controllerCoreComputeTimer.startMeasurement();
        switch ((WholeBodyControllerCoreMode)this.currentMode.getEnumValue()) {
            case INVERSE_DYNAMICS: {
                if (this.inverseDynamicsSolver != null) {
                    this.doInverseDynamics();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case INVERSE_KINEMATICS: {
                if (this.inverseKinematicsSolver != null) {
                    this.doInverseKinematics();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case VIRTUAL_MODEL: {
                if (this.virtualModelControlSolver != null) {
                    this.doVirtualModelControl();
                    break;
                }
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
            case OFF: {
                this.doNothing();
                break;
            }
            default: {
                throw new RuntimeException("The controller core mode: " + this.currentMode.getEnumValue() + " is not handled.");
            }
        }
        if (this.rootJointDesiredConfigurationData != null) {
            this.controllerCoreOutput.setRootJointDesiredConfigurationData(this.rootJointDesiredConfigurationData);
        }
        this.controllerCoreOutput.setLowLevelOneDoFJointDesiredDataHolder((JointDesiredOutputListReadOnly)this.jointDesiredOutputList);
        this.controllerCoreComputeTimer.stopMeasurement();
    }

    private void doInverseDynamics() {
        this.feedbackController.computeInverseDynamics();
        InverseDynamicsCommandList feedbackControllerOutput = this.feedbackController.getInverseDynamicsOutput();
        this.numberOfFBControllerEnabled.set(feedbackControllerOutput.getNumberOfCommands());
        this.inverseDynamicsSolver.submitInverseDynamicsCommandList(feedbackControllerOutput);
        this.inverseDynamicsSolver.submitResetIntegratorRequests((JointDesiredOutputListReadOnly)this.jointDesiredOutputList);
        this.inverseDynamicsSolver.compute();
        this.feedbackController.computeAchievedAccelerations();
        LowLevelOneDoFJointDesiredDataHolder inverseDynamicsOutput = this.inverseDynamicsSolver.getOutput();
        RootJointDesiredConfigurationDataReadOnly inverseDynamicsOutputForRootJoint = this.inverseDynamicsSolver.getOutputForRootJoint();
        this.jointDesiredOutputList.completeWith((JointDesiredOutputListReadOnly)inverseDynamicsOutput);
        if (this.rootJointDesiredConfigurationData != null) {
            this.rootJointDesiredConfigurationData.completeWith(inverseDynamicsOutputForRootJoint);
        }
        this.controllerCoreOutput.setLinearMomentumRate(this.inverseDynamicsSolver.getAchievedMomentumRateLinear());
    }

    private void doInverseKinematics() {
        this.feedbackController.computeInverseKinematics();
        InverseKinematicsCommandList feedbackControllerOutput = this.feedbackController.getInverseKinematicsOutput();
        this.numberOfFBControllerEnabled.set(feedbackControllerOutput.getNumberOfCommands());
        this.inverseKinematicsSolver.submitInverseKinematicsCommandList(feedbackControllerOutput);
        this.inverseKinematicsSolver.compute();
        LowLevelOneDoFJointDesiredDataHolder inverseKinematicsOutput = this.inverseKinematicsSolver.getOutput();
        RootJointDesiredConfigurationDataReadOnly inverseKinematicsOutputForRootJoint = this.inverseKinematicsSolver.getOutputForRootJoint();
        this.jointDesiredOutputList.completeWith((JointDesiredOutputListReadOnly)inverseKinematicsOutput);
        if (this.rootJointDesiredConfigurationData != null) {
            this.rootJointDesiredConfigurationData.completeWith(inverseKinematicsOutputForRootJoint);
        }
    }

    private void doVirtualModelControl() {
        this.feedbackController.computeVirtualModelControl();
        VirtualModelControlCommandList feedbackControllerOutput = this.feedbackController.getVirtualModelControlOutput();
        this.numberOfFBControllerEnabled.set(feedbackControllerOutput.getNumberOfCommands());
        this.virtualModelControlSolver.submitVirtualModelControlCommandList(feedbackControllerOutput);
        this.virtualModelControlSolver.compute();
        LowLevelOneDoFJointDesiredDataHolder virtualModelControlOutput = this.virtualModelControlSolver.getOutput();
        RootJointDesiredConfigurationDataReadOnly virtualModelControlOutputForRootJoint = this.virtualModelControlSolver.getOutputForRootJoint();
        this.jointDesiredOutputList.completeWith((JointDesiredOutputListReadOnly)virtualModelControlOutput);
        if (this.rootJointDesiredConfigurationData != null) {
            this.rootJointDesiredConfigurationData.completeWith(virtualModelControlOutputForRootJoint);
        }
        this.controllerCoreOutput.setLinearMomentumRate(this.virtualModelControlSolver.getAchievedMomentumRateLinear());
    }

    private void doNothing() {
        this.numberOfFBControllerEnabled.set(0);
        this.jointDesiredOutputList.insertDesiredTorquesIntoOneDoFJoints(this.controlledOneDoFJoints);
    }

    public ControllerCoreOutput getControllerCoreOutput() {
        return this.controllerCoreOutput;
    }

    public ControllerCoreOutputReadOnly getOutputForHighLevelController() {
        return this.controllerCoreOutput;
    }

    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.jointDesiredOutputList;
    }

    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.rootJointDesiredConfigurationData;
    }

    public FeedbackControllerDataHolderReadOnly getWholeBodyFeedbackControllerDataHolder() {
        return this.feedbackController.getWholeBodyFeedbackControllerDataHolder();
    }
}

