/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.configurations.GroupParameter;
import us.ihmc.commonWalkingControlModules.controlModules.YoSE3OffsetFrame;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerDataHolderReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBAlphaFilteredVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBAlphaFilteredVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPoint3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPose3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBQuaternion3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FeedbackControllerData;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.implementations.DefaultYoPIDSE3Gains;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FeedbackControllerToolbox
implements FeedbackControllerDataHolderReadOnly {
    public static final String centerOfMassName = "centerOfMass";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private SingleFeedbackControllerDataPool centerOfMassDataPool;
    private final Map<RigidBodyBasics, List<SingleFeedbackControllerDataPool>> endEffectorDataPoolMap = new HashMap<RigidBodyBasics, List<SingleFeedbackControllerDataPool>>();
    private final List<SingleFeedbackControllerDataPool> singleFeedbackControllerDataPoolList = new ArrayList<SingleFeedbackControllerDataPool>();
    private final Map<String, DoubleProvider> errorVelocityFilterBreakFrequencies;
    private final InverseDynamicsCommandList lastFeedbackControllerInverseDynamicsOutput = new InverseDynamicsCommandList();
    private final InverseKinematicsCommandList lastFeedbackControllerInverseKinematicsOutput = new InverseKinematicsCommandList();
    private final VirtualModelControlCommandList lastFeedbackControllerVirtualModelControlOutput = new VirtualModelControlCommandList();

    public FeedbackControllerToolbox(YoRegistry parentRegistry) {
        this(FeedbackControllerSettings.getDefault(), parentRegistry);
    }

    public FeedbackControllerToolbox(FeedbackControllerSettings settings, YoRegistry parentRegistry) {
        this.errorVelocityFilterBreakFrequencies = new HashMap<String, DoubleProvider>();
        List<GroupParameter<Double>> parameters = settings.getErrorVelocityFilterBreakFrequencies();
        if (parameters != null) {
            for (GroupParameter<Double> groupParameter : parameters) {
                String parameterName = groupParameter.getGroupName() + "ErrorVelocityBreakFrequency";
                DoubleParameter groupBreakFrequency = new DoubleParameter(parameterName, this.registry, groupParameter.getParameter().doubleValue());
                groupParameter.getMemberNames().forEach(name -> this.errorVelocityFilterBreakFrequencies.put((String)name, (DoubleProvider)groupBreakFrequency));
            }
        }
        parentRegistry.addChild(this.registry);
    }

    public void registerFeedbackControllerOutput(InverseDynamicsCommandList output) {
        this.lastFeedbackControllerInverseDynamicsOutput.set(output);
        this.lastFeedbackControllerInverseKinematicsOutput.clear();
        this.lastFeedbackControllerVirtualModelControlOutput.clear();
    }

    public void registerFeedbackControllerOutput(InverseKinematicsCommandList output) {
        this.lastFeedbackControllerInverseDynamicsOutput.clear();
        this.lastFeedbackControllerInverseKinematicsOutput.set(output);
        this.lastFeedbackControllerVirtualModelControlOutput.clear();
    }

    public void registerFeedbackControllerOutput(VirtualModelControlCommandList output) {
        this.lastFeedbackControllerInverseDynamicsOutput.clear();
        this.lastFeedbackControllerInverseKinematicsOutput.clear();
        this.lastFeedbackControllerVirtualModelControlOutput.set(output);
    }

    private SingleFeedbackControllerDataPool getOrCreateCenterOfMassDataPool() {
        if (this.centerOfMassDataPool == null) {
            this.centerOfMassDataPool = new SingleFeedbackControllerDataPool(centerOfMassName, 0, this.registry);
            this.singleFeedbackControllerDataPoolList.add(this.centerOfMassDataPool);
        }
        return this.centerOfMassDataPool;
    }

    public FBPoint3D getOrCreateCenterOfMassPositionData(Type type, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateCenterOfMassDataPool();
        FBPoint3D positionData = dataPool.getOrCreatePositionData(type);
        positionData.addActiveFlag(activeFlag);
        return positionData;
    }

    public FBVector3D getOrCreateCenterOfMassVectorData(Type type, SpaceData3D space, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateCenterOfMassDataPool();
        FBVector3D vectorData = dataPool.getOrCreateVectorData3D(type, space);
        vectorData.addActiveFlag(activeFlag);
        return vectorData;
    }

    public FBAlphaFilteredVector3D getOrCreateCenterOfMassAlphaFilteredVectorData(Type rawDataType, SpaceData3D space, double dt, DoubleProvider breakFrequencyProvider, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateCenterOfMassDataPool();
        FBAlphaFilteredVector3D filteredVectorData = dataPool.getOrCreateAlphaFilteredVectorData(rawDataType, space, breakFrequencyProvider, dt);
        filteredVectorData.addActiveFlag(activeFlag);
        return filteredVectorData;
    }

    public FBRateLimitedVector3D getOrCreateCenterOfMassRateLimitedVectorData(Type rawDataType, SpaceData3D space, double dt, YoDouble maximumRate, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateCenterOfMassDataPool();
        FBRateLimitedVector3D rateLimitedVectorData = dataPool.getOrCreateRateLimitedVectorData(rawDataType, space, (DoubleProvider)maximumRate, dt);
        rateLimitedVectorData.addActiveFlag(activeFlag);
        return rateLimitedVectorData;
    }

    public YoPID3DGains getOrCreateCenterOfMassGains(boolean useIntegrator) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateCenterOfMassDataPool();
        return dataPool.getOrCreatePositionGains(useIntegrator);
    }

    private SingleFeedbackControllerDataPool getOrCreateEndEffectorDataPool(RigidBodyBasics endEffector, int controllerIndex) {
        List<SingleFeedbackControllerDataPool> endEffectorDataPoolList = this.endEffectorDataPoolMap.get(endEffector);
        if (endEffectorDataPoolList == null) {
            endEffectorDataPoolList = new ArrayList<SingleFeedbackControllerDataPool>();
            this.endEffectorDataPoolMap.put(endEffector, endEffectorDataPoolList);
        }
        while (endEffectorDataPoolList.size() <= controllerIndex) {
            SingleFeedbackControllerDataPool newPool = new SingleFeedbackControllerDataPool(endEffector.getName(), controllerIndex, this.registry);
            endEffectorDataPoolList.add(newPool);
            this.singleFeedbackControllerDataPoolList.add(newPool);
        }
        return endEffectorDataPoolList.get(controllerIndex);
    }

    public FBPoint3D getOrCreatePositionData(RigidBodyBasics endEffector, int controllerIndex, Type type, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex);
        FBPoint3D positionData = dataPool.getOrCreatePositionData(type);
        positionData.addActiveFlag(activeFlag);
        return positionData;
    }

    public FBQuaternion3D getOrCreateOrientationData(RigidBodyBasics endEffector, int controllerIndex, Type type, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex);
        FBQuaternion3D orientationData = dataPool.getOrCreateOrientationData(type);
        orientationData.addActiveFlag(activeFlag);
        return orientationData;
    }

    public FBVector3D getOrCreateVectorData3D(RigidBodyBasics endEffector, int controllerIndex, Type type, SpaceData3D space, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex);
        FBVector3D vectorData = dataPool.getOrCreateVectorData3D(type, space);
        vectorData.addActiveFlag(activeFlag);
        return vectorData;
    }

    public FBRateLimitedVector3D getOrCreateRateLimitedVectorData3D(RigidBodyBasics endEffector, int controllerIndex, Type rawDataType, SpaceData3D space, double dt, YoDouble maximumRate, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex);
        FBRateLimitedVector3D rateLimitedVectorData = dataPool.getOrCreateRateLimitedVectorData(rawDataType, space, (DoubleProvider)maximumRate, dt);
        rateLimitedVectorData.addActiveFlag(activeFlag);
        return rateLimitedVectorData;
    }

    public FBAlphaFilteredVector3D getOrCreateAlphaFilteredVectorData3D(RigidBodyBasics endEffector, int controllerIndex, Type rawDataType, SpaceData3D space, double dt, DoubleProvider breakFrequencyProvider, BooleanProvider activeFlag) {
        SingleFeedbackControllerDataPool dataPool = this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex);
        FBAlphaFilteredVector3D alphaFilteredVectorData = dataPool.getOrCreateAlphaFilteredVectorData(rawDataType, space, breakFrequencyProvider, dt);
        alphaFilteredVectorData.addActiveFlag(activeFlag);
        return alphaFilteredVectorData;
    }

    public FBPose3D getOrCreatePoseData(RigidBodyBasics endEffector, int controllerIndex, Type type, BooleanProvider activeFlag) {
        return new FBPose3D(this.getOrCreatePositionData(endEffector, controllerIndex, type, activeFlag), this.getOrCreateOrientationData(endEffector, controllerIndex, type, activeFlag));
    }

    public FBVector6D getOrCreateVectorData6D(RigidBodyBasics endEffector, int controllerIndex, Type type, SpaceData6D space, BooleanProvider activeFlag) {
        SpaceData3D angularSpace = space == SpaceData6D.POSE ? SpaceData3D.ROTATION_VECTOR : space.getAngular();
        SpaceData3D linearSpace = space.getLinear();
        return new FBVector6D(this.getOrCreateVectorData3D(endEffector, controllerIndex, type, angularSpace, activeFlag), this.getOrCreateVectorData3D(endEffector, controllerIndex, type, linearSpace, activeFlag));
    }

    public FBAlphaFilteredVector6D getOrCreateAlphaFilteredVectorData6D(RigidBodyBasics endEffector, int controllerIndex, Type rawDataType, SpaceData6D space, double dt, DoubleProvider breakFrequencyAngularPart, DoubleProvider breakFrequencyLinearPart, BooleanProvider activeFlag) {
        SpaceData3D angularSpace = space == SpaceData6D.POSE ? SpaceData3D.ROTATION_VECTOR : space.getAngular();
        SpaceData3D linearSpace = space.getLinear();
        return new FBAlphaFilteredVector6D(this.getOrCreateAlphaFilteredVectorData3D(endEffector, controllerIndex, rawDataType, angularSpace, dt, breakFrequencyAngularPart, activeFlag), this.getOrCreateAlphaFilteredVectorData3D(endEffector, controllerIndex, rawDataType, linearSpace, dt, breakFrequencyLinearPart, activeFlag));
    }

    public FBRateLimitedVector6D getOrCreateRateLimitedVectorData6D(RigidBodyBasics endEffector, int controllerIndex, Type rawDataType, SpaceData6D space, double dt, YoDouble maximumAngularRate, YoDouble maximumLinearRate, BooleanProvider activeFlag) {
        SpaceData3D angularSpace = space == SpaceData6D.POSE ? SpaceData3D.ROTATION_VECTOR : space.getAngular();
        SpaceData3D linearSpace = space.getLinear();
        return new FBRateLimitedVector6D(this.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, rawDataType, angularSpace, dt, maximumAngularRate, activeFlag), this.getOrCreateRateLimitedVectorData3D(endEffector, controllerIndex, rawDataType, linearSpace, dt, maximumLinearRate, activeFlag));
    }

    public YoPID3DGains getOrCreateOrientationGains(RigidBodyBasics endEffector, int controllerIndex, boolean useIntegrator) {
        return this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex).getOrCreateOrientationGains(useIntegrator);
    }

    public YoPID3DGains getOrCreatePositionGains(RigidBodyBasics endEffector, int controllerIndex, boolean useIntegrator) {
        return this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex).getOrCreatePositionGains(useIntegrator);
    }

    public YoPIDSE3Gains getOrCreateSE3PIDGains(RigidBodyBasics endEffector, int controllerIndex, boolean useIntegrator) {
        YoPID3DGains positionGains = this.getOrCreatePositionGains(endEffector, controllerIndex, useIntegrator);
        YoPID3DGains orientationGains = this.getOrCreateOrientationGains(endEffector, controllerIndex, useIntegrator);
        return new DefaultYoPIDSE3Gains(positionGains, orientationGains);
    }

    public YoSE3OffsetFrame getOrCreateControlFrame(RigidBodyBasics endEffector, int controllerIndex) {
        return this.getOrCreateEndEffectorDataPool(endEffector, controllerIndex).getOrCreateControlFrame((ReferenceFrame)endEffector.getBodyFixedFrame());
    }

    public void clearUnusedData() {
        for (int i = 0; i < this.singleFeedbackControllerDataPoolList.size(); ++i) {
            this.singleFeedbackControllerDataPoolList.get(i).clearIfInactive();
        }
    }

    public DoubleProvider getErrorVelocityFilterBreakFrequency(String endEffectorOrJointName) {
        return this.errorVelocityFilterBreakFrequencies.get(endEffectorOrJointName);
    }

    @Override
    public void getCenterOfMassPositionData(List<FBPoint3D> positionDataListToPack, Type type) {
        positionDataListToPack.clear();
        FBPoint3D positionData = (FBPoint3D)this.getOrCreateCenterOfMassDataPool().positionDataMap.get((Object)type);
        if (positionData == null || !positionData.isActive()) {
            return;
        }
        positionDataListToPack.add(positionData);
    }

    @Override
    public void getCenterOfMassVectorData(List<FBVector3D> vectorDataListToPack, Type type, SpaceData3D space) {
        vectorDataListToPack.clear();
        EnumMap endEffectorDataTyped = (EnumMap)this.getOrCreateCenterOfMassDataPool().vectorDataMap.get((Object)type);
        if (endEffectorDataTyped == null) {
            return;
        }
        FBVector3D vectorData = (FBVector3D)endEffectorDataTyped.get((Object)space);
        if (vectorData == null || !vectorData.isActive()) {
            return;
        }
        vectorDataListToPack.add(vectorData);
    }

    @Override
    public void getPositionData(RigidBodyBasics endEffector, List<FBPoint3D> positionDataListToPack, Type type) {
        positionDataListToPack.clear();
        List<SingleFeedbackControllerDataPool> dataPoolList = this.endEffectorDataPoolMap.get(endEffector);
        if (dataPoolList == null) {
            return;
        }
        for (int i = 0; i < dataPoolList.size(); ++i) {
            EnumMap positionDataMap = dataPoolList.get(i).positionDataMap;
            FBPoint3D positionData = (FBPoint3D)positionDataMap.get((Object)type);
            if (positionData == null || !positionData.isActive()) continue;
            positionDataListToPack.add(positionData);
        }
    }

    @Override
    public void getOrientationData(RigidBodyBasics endEffector, List<FBQuaternion3D> orientationDataListToPack, Type type) {
        orientationDataListToPack.clear();
        List<SingleFeedbackControllerDataPool> dataPoolList = this.endEffectorDataPoolMap.get(endEffector);
        if (dataPoolList == null) {
            return;
        }
        for (int i = 0; i < dataPoolList.size(); ++i) {
            EnumMap orientationDataMap = dataPoolList.get(i).orientationDataMap;
            FBQuaternion3D orientationData = (FBQuaternion3D)orientationDataMap.get((Object)type);
            if (orientationData == null || !orientationData.isActive()) continue;
            orientationDataListToPack.add(orientationData);
        }
    }

    @Override
    public void getVectorData(RigidBodyBasics endEffector, List<FBVector3D> vectorDataListToPack, Type type, SpaceData3D space) {
        vectorDataListToPack.clear();
        List<SingleFeedbackControllerDataPool> dataPoolList = this.endEffectorDataPoolMap.get(endEffector);
        if (dataPoolList == null) {
            return;
        }
        for (int i = 0; i < dataPoolList.size(); ++i) {
            FBVector3D vectorData;
            EnumMap vectorDataMap = dataPoolList.get(i).vectorDataMap;
            EnumMap vectorDataSubMap = (EnumMap)vectorDataMap.get((Object)type);
            if (vectorDataSubMap == null || (vectorData = (FBVector3D)vectorDataSubMap.get((Object)space)) == null || !vectorData.isActive()) continue;
            vectorDataListToPack.add(vectorData);
        }
    }

    @Override
    public InverseDynamicsCommandList getLastFeedbackControllerInverseDynamicsOutput() {
        return this.lastFeedbackControllerInverseDynamicsOutput;
    }

    @Override
    public InverseKinematicsCommandList getLastFeedbackControllerInverseKinematicsOutput() {
        return this.lastFeedbackControllerInverseKinematicsOutput;
    }

    @Override
    public VirtualModelControlCommandList getLastFeedbackControllerVirtualModelControlOutput() {
        return this.lastFeedbackControllerVirtualModelControlOutput;
    }

    public static String appendIndex(String input, int index) {
        if (index == 0) {
            return input;
        }
        return input + Integer.toString(index);
    }

    private static class SingleFeedbackControllerDataPool {
        private final YoRegistry registry;
        private final String namePrefix;
        private final EnumMap<Type, FBPoint3D> positionDataMap = new EnumMap(Type.class);
        private final EnumMap<Type, FBQuaternion3D> orientationDataMap = new EnumMap(Type.class);
        private final EnumMap<Type, EnumMap<SpaceData3D, FBVector3D>> vectorDataMap = new EnumMap(Type.class);
        private final EnumMap<Type, EnumMap<SpaceData3D, FBRateLimitedVector3D>> rateLimitedVectorDataMap = new EnumMap(Type.class);
        private final EnumMap<Type, EnumMap<SpaceData3D, FBAlphaFilteredVector3D>> filteredVectorDataMap = new EnumMap(Type.class);
        private YoPID3DGains orientationGains;
        private YoPID3DGains positionGains;
        private YoSE3OffsetFrame controlFrame;
        private final List<FeedbackControllerData> clearableData = new ArrayList<FeedbackControllerData>();

        public SingleFeedbackControllerDataPool(String namePrefix, int controllerIndex, YoRegistry registry) {
            this.namePrefix = FeedbackControllerToolbox.appendIndex(namePrefix, controllerIndex);
            this.registry = registry;
        }

        public void clearIfInactive() {
            for (int i = 0; i < this.clearableData.size(); ++i) {
                this.clearableData.get(i).clearIfInactive();
            }
        }

        public FBPoint3D getOrCreatePositionData(Type type) {
            FBPoint3D positionData = this.positionDataMap.get((Object)type);
            if (positionData == null) {
                positionData = new FBPoint3D(this.namePrefix, type, this.registry);
                this.positionDataMap.put(type, positionData);
                this.clearableData.add(positionData);
            }
            return positionData;
        }

        public FBQuaternion3D getOrCreateOrientationData(Type type) {
            FBQuaternion3D orientationData = this.orientationDataMap.get((Object)type);
            if (orientationData == null) {
                orientationData = new FBQuaternion3D(this.namePrefix, type, this.registry);
                this.orientationDataMap.put(type, orientationData);
                this.clearableData.add(orientationData);
            }
            return orientationData;
        }

        public FBVector3D getOrCreateVectorData3D(Type type, SpaceData3D space) {
            EnumMap<SpaceData3D, FBVector3D> vectorDataSubMap = SingleFeedbackControllerDataPool.getSubEnumMap(this.vectorDataMap, type, SpaceData3D.class);
            FBVector3D vectorData = vectorDataSubMap.get((Object)space);
            if (vectorData == null) {
                vectorData = new FBVector3D(this.namePrefix, type, space, this.registry);
                vectorDataSubMap.put(space, vectorData);
                this.clearableData.add(vectorData);
            }
            return vectorData;
        }

        public FBAlphaFilteredVector3D getOrCreateAlphaFilteredVectorData(Type type, SpaceData3D space, DoubleProvider breakFrequency, double dt) {
            EnumMap<SpaceData3D, FBAlphaFilteredVector3D> filteredVectorDataSubMap = SingleFeedbackControllerDataPool.getSubEnumMap(this.filteredVectorDataMap, type, SpaceData3D.class);
            FBAlphaFilteredVector3D filteredVectorData = filteredVectorDataSubMap.get((Object)space);
            if (filteredVectorData == null) {
                FBVector3D rawVectorData = this.getOrCreateVectorData3D(type, space);
                filteredVectorData = new FBAlphaFilteredVector3D(this.namePrefix, type, space, breakFrequency, dt, (FrameVector3DReadOnly)rawVectorData, this.registry);
                filteredVectorDataSubMap.put(space, filteredVectorData);
                this.clearableData.add(filteredVectorData);
            }
            return filteredVectorData;
        }

        public FBRateLimitedVector3D getOrCreateRateLimitedVectorData(Type type, SpaceData3D space, DoubleProvider maximumRate, double dt) {
            EnumMap<SpaceData3D, FBRateLimitedVector3D> rateLimitedVectorDataSubMap = SingleFeedbackControllerDataPool.getSubEnumMap(this.rateLimitedVectorDataMap, type, SpaceData3D.class);
            FBRateLimitedVector3D rateLimitedVectorData = rateLimitedVectorDataSubMap.get((Object)space);
            if (rateLimitedVectorData == null) {
                FBVector3D rawVectorData = this.getOrCreateVectorData3D(type, space);
                rateLimitedVectorData = new FBRateLimitedVector3D(this.namePrefix, type, space, maximumRate, dt, (FrameVector3DReadOnly)rawVectorData, this.registry);
                rateLimitedVectorDataSubMap.put(space, rateLimitedVectorData);
                this.clearableData.add(rateLimitedVectorData);
            }
            return rateLimitedVectorData;
        }

        public YoPID3DGains getOrCreateOrientationGains(boolean useIntegrator) {
            if (this.orientationGains == null) {
                this.orientationGains = new DefaultYoPID3DGains(this.namePrefix + "Orientation", GainCoupling.NONE, useIntegrator, this.registry);
            }
            return this.orientationGains;
        }

        public YoPID3DGains getOrCreatePositionGains(boolean useIntegrator) {
            if (this.positionGains == null) {
                this.positionGains = new DefaultYoPID3DGains(this.namePrefix + "Position", GainCoupling.NONE, useIntegrator, this.registry);
            }
            return this.positionGains;
        }

        public YoSE3OffsetFrame getOrCreateControlFrame(ReferenceFrame parentFrame) {
            if (this.controlFrame == null) {
                this.controlFrame = new YoSE3OffsetFrame(this.namePrefix + "BodyFixedControlFrame", parentFrame, this.registry);
            }
            return this.controlFrame;
        }

        private static <K, E extends Enum<E>, V> EnumMap<E, V> getSubEnumMap(Map<K, EnumMap<E, V>> enclosingMap, K key, Class<E> subMapEnumType) {
            EnumMap<E, V> subMap = enclosingMap.get(key);
            if (subMap == null) {
                subMap = new EnumMap(subMapEnumType);
                enclosingMap.put(key, subMap);
            }
            return subMap;
        }
    }
}

