/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisOrientationTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class UserDesiredPelvisPoseControllerCommandGenerator {
    private static final boolean DEBUG = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean userDoPelvisPose = new YoBoolean("userDoPelvisPose", this.registry);
    private final YoBoolean userStreamPelvisPose = new YoBoolean("userStreamPelvisPose", this.registry);
    private final YoBoolean userStreamPelvisOrientation = new YoBoolean("userStreamPelvisOrientation", this.registry);
    private final YoBoolean userUpdateDesiredPelvisPose = new YoBoolean("userUpdateDesiredPelvisPose", this.registry);
    private final YoDouble userDesiredPelvisPoseTrajectoryTime = new YoDouble("userDesiredPelvisPoseTrajectoryTime", this.registry);
    private final YoFramePoseUsingYawPitchRoll userDesiredPelvisPose;
    private final ReferenceFrame midFeetZUpFrame;
    private final ReferenceFrame pelvisFrame;
    private final FramePose3D framePose = new FramePose3D(worldFrame);
    private final CommandInputManager controllerCommandInputManager;
    private final PelvisTrajectoryCommand poseCommand = new PelvisTrajectoryCommand();
    private final PelvisOrientationTrajectoryCommand orientationCommand = new PelvisOrientationTrajectoryCommand();
    private final Point3D position = new Point3D();
    private final Quaternion orientation = new Quaternion();
    private final Vector3D zeroVelocity = new Vector3D();

    public UserDesiredPelvisPoseControllerCommandGenerator(CommandInputManager controllerCommandInputManager, FullHumanoidRobotModel fullRobotModel, CommonHumanoidReferenceFrames commonHumanoidReferenceFrames, double defaultTrajectoryTime, YoRegistry parentRegistry) {
        this.controllerCommandInputManager = controllerCommandInputManager;
        this.midFeetZUpFrame = commonHumanoidReferenceFrames.getMidFeetZUpFrame();
        this.pelvisFrame = commonHumanoidReferenceFrames.getPelvisFrame();
        this.userDesiredPelvisPose = new YoFramePoseUsingYawPitchRoll("userDesiredPelvisPose", this.midFeetZUpFrame, this.registry);
        this.userUpdateDesiredPelvisPose.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userUpdateDesiredPelvisPose.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.framePose.setToZero(UserDesiredPelvisPoseControllerCommandGenerator.this.pelvisFrame);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.framePose.changeFrame(UserDesiredPelvisPoseControllerCommandGenerator.this.midFeetZUpFrame);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userDesiredPelvisPose.set((FramePose3DReadOnly)UserDesiredPelvisPoseControllerCommandGenerator.this.framePose);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userUpdateDesiredPelvisPose.set(false);
                }
            }
        });
        this.userDoPelvisPose.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userDoPelvisPose.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.sendPelvisTrajectoryCommand();
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userDoPelvisPose.set(false);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisPose.set(false);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisOrientation.set(false);
                }
            }
        });
        this.userStreamPelvisPose.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisPose.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userDoPelvisPose.set(false);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisOrientation.set(false);
                }
            }
        });
        this.userStreamPelvisOrientation.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisOrientation.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userDoPelvisPose.set(false);
                    UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisPose.set(false);
                }
            }
        });
        this.userDesiredPelvisPose.attachVariableChangedListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisPose.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.sendPelvisTrajectoryCommand();
                }
            }
        });
        this.userDesiredPelvisPose.getYawPitchRoll().attachVariableChangedListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredPelvisPoseControllerCommandGenerator.this.userStreamPelvisOrientation.getBooleanValue()) {
                    UserDesiredPelvisPoseControllerCommandGenerator.this.sendPelvisOrientationTrajectoryCommand();
                }
            }
        });
        this.userDesiredPelvisPoseTrajectoryTime.set(defaultTrajectoryTime);
        parentRegistry.addChild(this.registry);
    }

    private void sendPelvisTrajectoryCommand() {
        this.framePose.setIncludingFrame((FramePose3DReadOnly)this.userDesiredPelvisPose);
        this.framePose.changeFrame(worldFrame);
        double time = this.userDesiredPelvisPoseTrajectoryTime.getDoubleValue();
        this.framePose.get((Tuple3DBasics)this.position, (Orientation3DBasics)this.orientation);
        this.poseCommand.getSE3Trajectory().clear(worldFrame);
        this.poseCommand.getSE3Trajectory().setTrajectoryFrame(worldFrame);
        this.poseCommand.getSE3Trajectory().addTrajectoryPoint(time, (Point3DReadOnly)this.position, (QuaternionReadOnly)this.orientation, (Vector3DReadOnly)this.zeroVelocity, (Vector3DReadOnly)this.zeroVelocity);
        this.poseCommand.getSE3Trajectory().setExecutionMode(ExecutionMode.OVERRIDE);
        this.poseCommand.getSE3Trajectory().setCommandId(-1L);
        this.controllerCommandInputManager.submitCommand((Command)this.poseCommand);
    }

    private void sendPelvisOrientationTrajectoryCommand() {
        this.framePose.setIncludingFrame((FramePose3DReadOnly)this.userDesiredPelvisPose);
        this.framePose.changeFrame(worldFrame);
        double time = this.userDesiredPelvisPoseTrajectoryTime.getDoubleValue();
        this.orientation.set((QuaternionReadOnly)this.framePose.getOrientation());
        this.orientationCommand.getSO3Trajectory().clear(worldFrame);
        this.orientationCommand.getSO3Trajectory().setTrajectoryFrame(worldFrame);
        this.orientationCommand.getSO3Trajectory().addTrajectoryPoint(time, (QuaternionReadOnly)this.orientation, (Vector3DReadOnly)this.zeroVelocity);
        this.orientationCommand.getSO3Trajectory().setExecutionMode(ExecutionMode.OVERRIDE);
        this.orientationCommand.getSO3Trajectory().setCommandId(-1L);
        this.controllerCommandInputManager.submitCommand((Command)this.orientationCommand);
    }
}

