/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import java.util.List;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class UserDesiredFootstepDataMessageGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final String namePrefix = "userDesiredStep";
    private final YoInteger stepsToTake = new YoInteger("userDesiredStepsToTake", this.registry);
    private final YoEnum<RobotSide> firstStepSide = new YoEnum("userDesiredStepFirstSide", this.registry, RobotSide.class);
    private final YoDouble minimumWidth = new YoDouble("userDesiredStepMinWidth", this.registry);
    private final YoBoolean stepSquareUp = new YoBoolean("userDesiredStepSquareUp", this.registry);
    private final YoDouble swingTime = new YoDouble("userDesiredStepSwingTime", this.registry);
    private final YoDouble transferTime = new YoDouble("userDesiredStepTransferTime", this.registry);
    private final YoDouble swingHeight = new YoDouble("userDesiredStepSwingHeight", this.registry);
    private final YoDouble stepHeelPercentage = new YoDouble("userDesiredStepHeelPercentage", this.registry);
    private final YoDouble stepToePercentage = new YoDouble("userDesiredStepToePercentage", this.registry);
    private final YoDouble stepLength = new YoDouble("userDesiredStepLength", this.registry);
    private final YoDouble stepWidth = new YoDouble("userDesiredStepWidth", this.registry);
    private final YoDouble stepHeight = new YoDouble("userDesiredStepHeight", this.registry);
    private final YoDouble stepSideways = new YoDouble("userDesiredStepSideways", this.registry);
    private final YoDouble stepYaw = new YoDouble("userDesiredStepYaw", this.registry);
    private final YoDouble stepPitch = new YoDouble("userDesiredStepPitch", this.registry);
    private final YoDouble stepRoll = new YoDouble("userDesiredStepRoll", this.registry);
    private final YoBoolean sendSteps = new YoBoolean("userDesiredStepSend", this.registry);
    private List<FramePoint2D> contactFramePoints;
    private RecyclingArrayList<Point2D> contactPoints = new RecyclingArrayList(4, Point2D.class);
    private Point2D contactPoint;
    private final SideDependentList<ContactableFoot> bipedFeet;
    private ContactableFoot swingFoot;
    private RobotSide swingSide = RobotSide.LEFT;
    private RobotSide supportSide = this.swingSide.getOppositeSide();
    private final CommandInputManager commandInputManager;
    private final PoseReferenceFrame footstepPoseFrame = new PoseReferenceFrame("footstepPoseFrame", (FramePose3DReadOnly)new FramePose3D());
    private ReferenceFrame newStepReferenceFrame;
    private PoseReferenceFrame previousPoseFrame;
    private FrameVector3D desiredOffset;
    private FramePoint3D desiredPosition;
    private FrameQuaternion desiredOrientation;
    private final FootstepDataCommand desiredFootstepCommand = new FootstepDataCommand();
    private final FootstepDataListCommand footstepCommandList = new FootstepDataListCommand();

    public UserDesiredFootstepDataMessageGenerator(CommandInputManager commandInputManager, SideDependentList<ContactableFoot> bipedFeet, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this.bipedFeet = bipedFeet;
        this.commandInputManager = commandInputManager;
        this.swingFoot = (ContactableFoot)bipedFeet.get((Enum)this.swingSide);
        ReferenceFrame stanceFootFrame = ((ContactableFoot)bipedFeet.get((Enum)this.swingSide.getOppositeSide())).getSoleFrame();
        this.desiredOffset = new FrameVector3D(stanceFootFrame);
        this.desiredPosition = new FramePoint3D(stanceFootFrame);
        this.desiredOrientation = new FrameQuaternion(stanceFootFrame);
        this.firstStepSide.set((Enum)this.supportSide);
        this.minimumWidth.set(walkingControllerParameters.getSteppingParameters().getMinStepWidth());
        this.stepWidth.set((walkingControllerParameters.getSteppingParameters().getMaxStepWidth() + walkingControllerParameters.getSteppingParameters().getMinStepWidth()) / 2.0);
        this.swingHeight.set(0.0);
        this.swingTime.set(walkingControllerParameters.getDefaultSwingTime());
        this.transferTime.set(walkingControllerParameters.getDefaultTransferTime());
        this.stepHeelPercentage.set(1.0);
        this.stepToePercentage.set(1.0);
        this.sendSteps.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredFootstepDataMessageGenerator.this.sendSteps.getBooleanValue()) {
                    UserDesiredFootstepDataMessageGenerator.this.createStepPlan();
                }
            }
        });
        parentRegistry.addChild(this.registry);
    }

    public void createStepPlan() {
        this.desiredFootstepCommand.clear();
        this.footstepCommandList.clear();
        this.sendSteps.set(false);
        this.swingSide = (RobotSide)this.firstStepSide.getEnumValue();
        if (this.swingSide == null) {
            this.swingSide = RobotSide.LEFT;
        }
        this.supportSide = this.swingSide.getOppositeSide();
        this.previousPoseFrame = null;
        for (int i = 0; i < this.stepsToTake.getIntegerValue(); ++i) {
            this.swingFoot = (ContactableFoot)this.bipedFeet.get((Enum)this.swingSide);
            this.desiredFootstepCommand.clear();
            this.desiredFootstepCommand.setRobotSide(this.swingSide);
            this.desiredFootstepCommand.setSwingHeight(this.swingHeight.getDoubleValue());
            if (i == this.stepsToTake.getIntegerValue() - 1 && this.stepSquareUp.getBooleanValue()) {
                this.squareUp();
            } else {
                this.createNextFootstep();
            }
            this.footstepCommandList.addFootstep(this.desiredFootstepCommand);
            this.previousPoseFrame = this.footstepPoseFrame;
            this.swingSide = this.swingSide.getOppositeSide();
            this.supportSide = this.swingSide.getOppositeSide();
        }
        this.footstepCommandList.setExecutionMode(ExecutionMode.OVERRIDE);
        this.footstepCommandList.setDefaultSwingDuration(this.swingTime.getDoubleValue());
        this.footstepCommandList.setDefaultTransferDuration(this.transferTime.getDoubleValue());
        this.footstepCommandList.setOffsetFootstepsHeightWithExecutionError(true);
        this.commandInputManager.submitCommand((Command)this.footstepCommandList);
    }

    private void createNextFootstep() {
        this.createFootstep();
    }

    private void squareUp() {
        this.createFootstep(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    private void createFootstep() {
        this.createFootstep(this.stepLength.getDoubleValue(), this.stepSideways.getDoubleValue(), this.stepHeight.getDoubleValue(), this.stepYaw.getDoubleValue(), this.stepPitch.getDoubleValue(), this.stepRoll.getDoubleValue());
    }

    private void createFootstep(double stepLength, double stepSideways, double stepHeight, double stepYaw, double stepPitch, double stepRoll) {
        this.newStepReferenceFrame = this.previousPoseFrame != null ? this.previousPoseFrame : ((ContactableFoot)this.bipedFeet.get((Enum)this.supportSide)).getSoleFrame();
        this.desiredPosition.setToZero(this.newStepReferenceFrame);
        this.desiredOffset.setToZero(this.newStepReferenceFrame);
        double stepYOffset = this.supportSide.negateIfLeftSide(this.stepWidth.getDoubleValue()) + stepSideways;
        if (this.supportSide == RobotSide.LEFT && stepYOffset > -this.minimumWidth.getDoubleValue()) {
            stepYOffset = -this.minimumWidth.getDoubleValue();
        }
        if (this.supportSide == RobotSide.RIGHT && stepYOffset < this.minimumWidth.getDoubleValue()) {
            stepYOffset = this.minimumWidth.getDoubleValue();
        }
        this.desiredOffset.set(stepLength, stepYOffset, stepHeight);
        this.desiredPosition.add((FrameTuple3DReadOnly)this.desiredOffset);
        this.desiredPosition.changeFrame(worldFrame);
        this.desiredOrientation.setToZero(this.newStepReferenceFrame);
        this.desiredOrientation.setYawPitchRoll(stepYaw, 0.0, 0.0);
        this.desiredOrientation.changeFrame(worldFrame);
        this.desiredOrientation.setYawPitchRoll(this.desiredOrientation.getYaw(), stepPitch, stepRoll);
        this.footstepPoseFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
        this.desiredFootstepCommand.setPose((Point3DReadOnly)this.desiredPosition, (QuaternionReadOnly)this.desiredOrientation);
        this.contactFramePoints = this.swingFoot.getContactPoints2d();
        this.contactPoints.clear();
        for (FramePoint2D contactFramePoint : this.contactFramePoints) {
            this.contactPoint = new Point2D((Tuple2DReadOnly)contactFramePoint);
            if (contactFramePoint.getX() > 0.0) {
                this.contactPoint.setX(this.contactPoint.getX() * this.stepToePercentage.getDoubleValue());
            } else {
                this.contactPoint.setX(this.contactPoint.getX() * this.stepHeelPercentage.getDoubleValue());
            }
            ((Point2D)this.contactPoints.add()).set(this.contactPoint);
        }
        this.desiredFootstepCommand.setPredictedContactPoints(this.contactPoints);
    }
}

