/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class UserDesiredFootPoseControllerCommandGenerator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean userDoFootPose = new YoBoolean("userDoFootPose", this.registry);
    private final YoDouble userDesiredFootPoseTrajectoryTime = new YoDouble("userDesiredFootPoseTrajectoryTime", this.registry);
    private final YoEnum<RobotSide> userFootPoseSide = new YoEnum("userFootPoseSide", this.registry, RobotSide.class);
    private final YoFramePoseUsingYawPitchRoll userDesiredFootPose;
    private final SideDependentList<ReferenceFrame> ankleZUpFrames = new SideDependentList();
    private final FramePose3D framePose = new FramePose3D(ReferenceFrame.getWorldFrame());

    public UserDesiredFootPoseControllerCommandGenerator(final CommandInputManager controllerCommandInputManager, FullHumanoidRobotModel fullRobotModel, double defaultTrajectoryTime, YoRegistry parentRegistry) {
        this.userDesiredFootPose = new YoFramePoseUsingYawPitchRoll("userDesiredFootPose", ReferenceFrame.getWorldFrame(), this.registry);
        for (RobotSide robotSide : RobotSide.values()) {
            ReferenceFrame ankleFrame = fullRobotModel.getSoleFrame((Enum)robotSide).getParent();
            ZUpFrame zUpFrame = new ZUpFrame(ReferenceFrame.getWorldFrame(), ankleFrame, robotSide.getCamelCaseNameForStartOfExpression() + "ZUpFrame");
            this.ankleZUpFrames.set((Enum)robotSide, (Object)zUpFrame);
        }
        this.userDoFootPose.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (UserDesiredFootPoseControllerCommandGenerator.this.userDoFootPose.getBooleanValue()) {
                    UserDesiredFootPoseControllerCommandGenerator.this.framePose.setIncludingFrame((FramePose3DReadOnly)UserDesiredFootPoseControllerCommandGenerator.this.userDesiredFootPose);
                    ReferenceFrame soleZUpFrame = (ReferenceFrame)UserDesiredFootPoseControllerCommandGenerator.this.ankleZUpFrames.get((Enum)((RobotSide)UserDesiredFootPoseControllerCommandGenerator.this.userFootPoseSide.getEnumValue()));
                    soleZUpFrame.update();
                    UserDesiredFootPoseControllerCommandGenerator.this.framePose.setIncludingFrame(soleZUpFrame, (Pose3DReadOnly)UserDesiredFootPoseControllerCommandGenerator.this.framePose);
                    UserDesiredFootPoseControllerCommandGenerator.this.framePose.changeFrame(ReferenceFrame.getWorldFrame());
                    System.out.println("framePose " + UserDesiredFootPoseControllerCommandGenerator.this.framePose);
                    FootTrajectoryCommand footTrajectoryControllerCommand = new FootTrajectoryCommand();
                    FrameSE3TrajectoryPoint trajectoryPoint = new FrameSE3TrajectoryPoint(ReferenceFrame.getWorldFrame());
                    trajectoryPoint.setTime(UserDesiredFootPoseControllerCommandGenerator.this.userDesiredFootPoseTrajectoryTime.getDoubleValue());
                    trajectoryPoint.setPosition((FramePoint3DReadOnly)UserDesiredFootPoseControllerCommandGenerator.this.framePose.getPosition());
                    trajectoryPoint.setOrientation((FrameQuaternionReadOnly)UserDesiredFootPoseControllerCommandGenerator.this.framePose.getOrientation());
                    trajectoryPoint.setLinearVelocity((Vector3DReadOnly)new Vector3D());
                    trajectoryPoint.setAngularVelocity((Vector3DReadOnly)new Vector3D());
                    footTrajectoryControllerCommand.getSE3Trajectory().addTrajectoryPoint(trajectoryPoint);
                    footTrajectoryControllerCommand.setRobotSide((RobotSide)UserDesiredFootPoseControllerCommandGenerator.this.userFootPoseSide.getEnumValue());
                    System.out.println("Submitting " + footTrajectoryControllerCommand);
                    controllerCommandInputManager.submitCommand((Command)footTrajectoryControllerCommand);
                    UserDesiredFootPoseControllerCommandGenerator.this.userDoFootPose.set(false);
                }
            }
        });
        this.userDesiredFootPoseTrajectoryTime.set(defaultTrajectoryTime);
        this.userFootPoseSide.set((Enum)RobotSide.LEFT);
        parentRegistry.addChild(this.registry);
    }
}

