/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired;

import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredChestOrientationControllerCommandGenerator;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredFootPoseControllerCommandGenerator;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredFootstepDataMessageGenerator;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredHandPoseControllerCommandGenerator;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredPelvisHeightControllerCommandGenerators;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredPelvisPoseControllerCommandGenerator;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;

public class UserDesiredControllerCommandGenerators {
    public UserDesiredControllerCommandGenerators(CommandInputManager controllerCommandInputManager, FullHumanoidRobotModel fullRobotModel, CommonHumanoidReferenceFrames commonHumanoidReferenceFrames, SideDependentList<ContactableFoot> bipedFeet, WalkingControllerParameters walkingControllerParameters, double defaultTrajectoryTime, YoRegistry parentRegistry) {
        new UserDesiredFootPoseControllerCommandGenerator(controllerCommandInputManager, fullRobotModel, defaultTrajectoryTime, parentRegistry);
        new UserDesiredPelvisHeightControllerCommandGenerators(controllerCommandInputManager, fullRobotModel, defaultTrajectoryTime, parentRegistry);
        new UserDesiredFootstepDataMessageGenerator(controllerCommandInputManager, bipedFeet, walkingControllerParameters, parentRegistry);
        new UserDesiredPelvisPoseControllerCommandGenerator(controllerCommandInputManager, fullRobotModel, commonHumanoidReferenceFrames, defaultTrajectoryTime, parentRegistry);
        if (fullRobotModel.getChest() != null) {
            new UserDesiredChestOrientationControllerCommandGenerator(controllerCommandInputManager, defaultTrajectoryTime, parentRegistry);
        }
        if (fullRobotModel.getHand(RobotSide.LEFT) != null || fullRobotModel.getHand(RobotSide.RIGHT) != null) {
            new UserDesiredHandPoseControllerCommandGenerator(controllerCommandInputManager, fullRobotModel, defaultTrajectoryTime, parentRegistry);
        }
    }
}

