/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input;

import controller_msgs.msg.dds.MessageCollection;
import controller_msgs.msg.dds.MessageCollectionNotification;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.MessagePool;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;

public class MessageCollector {
    private boolean isCollecting = false;
    private final TLongHashSet expectedMessageIDs;
    private final List<Settable<?>> interceptedMessages;
    private final List<Settable<?>> interceptedMessagesView;
    private final MessagePool messagePool;
    private final MessageIDExtractor messageIDExtractor;
    private final MessageCollectionNotification notification;

    public static MessageCollector createDummyCollector() {
        return new MessageCollector();
    }

    private MessageCollector() {
        this.messageIDExtractor = null;
        this.messagePool = null;
        this.expectedMessageIDs = null;
        this.interceptedMessages = null;
        this.interceptedMessagesView = Collections.emptyList();
        this.notification = null;
    }

    public MessageCollector(MessageIDExtractor messageIDExtractor, List<Class<? extends Settable<?>>> supportedMessages) {
        this.messageIDExtractor = messageIDExtractor;
        this.messagePool = new MessagePool(supportedMessages);
        this.expectedMessageIDs = new TLongHashSet();
        this.interceptedMessages = new ArrayList();
        this.interceptedMessagesView = Collections.unmodifiableList(this.interceptedMessages);
        this.notification = new MessageCollectionNotification();
    }

    public void reset() {
        if (this.messagePool == null) {
            return;
        }
        this.isCollecting = false;
        this.expectedMessageIDs.clear();
        this.interceptedMessages.clear();
        this.messagePool.reset();
    }

    public MessageCollectionNotification startCollecting(MessageCollection collection) {
        if (this.messagePool == null) {
            PrintTools.error((String)"This is a dummy collector, it cannot collect messages.");
            return null;
        }
        this.reset();
        this.isCollecting = true;
        this.notification.setMessageCollectionSequenceId(collection.getSequenceId());
        IDLSequence.Long sequences = collection.getSequences();
        for (int i = 0; i < sequences.size(); ++i) {
            this.expectedMessageIDs.add(sequences.get(i));
        }
        return this.notification;
    }

    public boolean interceptMessage(Settable<?> message) {
        if (this.messagePool == null) {
            return false;
        }
        long messageID = this.messageIDExtractor.getMessageID(message);
        if (messageID == 0L) {
            return false;
        }
        boolean intercept = this.expectedMessageIDs.remove(messageID);
        if (intercept) {
            Object copy = this.messagePool.requestMessage(message.getClass());
            copy.set(message);
            this.interceptedMessages.add((Settable<?>)copy);
        }
        if (this.expectedMessageIDs.isEmpty()) {
            this.isCollecting = false;
        }
        return intercept;
    }

    public boolean isCollecting() {
        if (this.messagePool == null) {
            return true;
        }
        return this.isCollecting;
    }

    public List<Settable<?>> getCollectedMessages() {
        return this.interceptedMessagesView;
    }

    public static interface MessageIDExtractor {
        public static final long NO_ID = 0L;

        public long getMessageID(Object var1);
    }
}

