/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input;

import controller_msgs.msg.dds.MessageCollection;
import controller_msgs.msg.dds.MessageCollectionNotification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.commons.PrintTools;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;

public class MessageCollectionMessenger {
    private static final int NOTIFICATION_TIMEOUT = 5000;
    private long sequenceID;
    private PublishingTask publishingTask = null;
    private MessageCollection collection = new MessageCollection();
    private List<Packet<?>> packets = new ArrayList();
    private final Map<Class, Method> sequenceIDSetterMap = new HashMap<Class, Method>();

    public MessageCollectionMessenger() {
        this(500L);
    }

    public MessageCollectionMessenger(long startSequenceID) {
        this.sequenceID = startSequenceID;
        this.collection.setSequenceId(this.sequenceID);
        this.incrementSequenceID();
    }

    public void addMessages(Iterable<Packet<?>> messages) {
        messages.forEach(this::addMessage);
    }

    public void addMessages(Packet<?> ... messages) {
        for (Packet<?> message : messages) {
            this.addMessage(message);
        }
    }

    public boolean addMessage(Packet<?> message) {
        Class<?> messageType = message.getClass();
        Method sequenceIDSetter = this.sequenceIDSetterMap.get(messageType);
        if (sequenceIDSetter == null) {
            try {
                sequenceIDSetter = messageType.getMethod("setSequenceId", Long.TYPE);
                this.sequenceIDSetterMap.put(messageType, sequenceIDSetter);
            }
            catch (NoSuchMethodException | SecurityException e) {
                PrintTools.error((String)("The message type: " + messageType.getSimpleName() + " cannot be sent with a MessageCollection, it needs to declare a sequenceID field."));
                return false;
            }
        }
        try {
            sequenceIDSetter.invoke(message, this.sequenceID);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Something went wrong when setting the sequenceID for the message " + messageType.getSimpleName(), e);
        }
        this.packets.add(message);
        this.collection.getSequences().add(this.sequenceID);
        this.incrementSequenceID();
        return true;
    }

    private void incrementSequenceID() {
        ++this.sequenceID;
        if (this.sequenceID == 0L) {
            ++this.sequenceID;
        }
    }

    public void sendMessageCollectionSafe(PacketCommunicator packetCommunicator, boolean runOnThread) {
        PacketConsumer listener = this::receivedNotification;
        packetCommunicator.attachListener(MessageCollectionNotification.class, listener);
        this.sendMessageCollectionSafe(arg_0 -> ((PacketCommunicator)packetCommunicator).send(arg_0), runOnThread, () -> packetCommunicator.detachListener(MessageCollectionNotification.class, listener));
    }

    public void sendMessageCollectionSafe(Messenger messenger, boolean runOnThread) {
        this.sendMessageCollectionSafe(messenger, runOnThread, null);
    }

    private void sendMessageCollectionSafe(Messenger messenger, boolean runOnThread, Runnable postProcess) {
        this.publishingTask = new PublishingTask(messenger, this.collection, this.packets, postProcess);
        if (runOnThread) {
            Thread thread = new Thread((Runnable)this.publishingTask, this.getClass().getSimpleName());
            thread.setDaemon(true);
            thread.start();
        } else {
            this.publishingTask.run();
        }
    }

    public void sendMessageCollectionUnsafe(Messenger messenger) {
        messenger.sendMessage((Packet<?>)this.collection);
        for (int i = 0; i < this.packets.size(); ++i) {
            messenger.sendMessage(this.packets.get(i));
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNotification(MessageCollectionNotification notification) {
        if (this.collection == null) {
            return;
        }
        if (notification.getMessageCollectionSequenceId() == this.collection.getSequenceId() && this.publishingTask != null) {
            Object object = this.publishingTask.notificationSync;
            synchronized (object) {
                this.publishingTask.hasReceivedNotification = true;
                this.publishingTask.notificationSync.notify();
            }
        }
    }

    private void reset() {
        this.collection.getSequences().reset();
        this.incrementSequenceID();
        this.collection.setSequenceId(this.sequenceID);
        this.incrementSequenceID();
        this.packets.clear();
    }

    private class PublishingTask
    implements Runnable {
        private volatile boolean hasReceivedNotification = false;
        private final Object notificationSync = new Object();
        private final Messenger messenger;
        private final MessageCollection collection;
        private final List<Packet<?>> packets;
        private final Runnable postProcess;

        public PublishingTask(Messenger messenger, MessageCollection collection, List<Packet<?>> packets, Runnable postProcess) {
            this.messenger = messenger;
            this.collection = collection;
            this.packets = packets;
            this.postProcess = postProcess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.notificationSync;
            synchronized (object) {
                this.messenger.sendMessage((Packet<?>)this.collection);
                try {
                    this.notificationSync.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.collection.getSequences().reset();
                    this.packets.clear();
                    return;
                }
                if (this.hasReceivedNotification) {
                    for (int i = 0; i < this.packets.size(); ++i) {
                        this.messenger.sendMessage(this.packets.get(i));
                    }
                } else {
                    PrintTools.error((String)(this.getClass().getSimpleName() + " did not receive " + MessageCollectionNotification.class.getSimpleName() + ". Clearing the internal messages."));
                }
                this.hasReceivedNotification = false;
                MessageCollectionMessenger.this.reset();
                if (this.postProcess != null) {
                    this.postProcess.run();
                }
            }
        }
    }

    public static interface Messenger {
        public void sendMessage(Packet<?> var1);
    }
}

