/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerAPI.input;

import controller_msgs.msg.dds.InvalidPacketNotificationPacket;
import controller_msgs.msg.dds.MessageCollection;
import controller_msgs.msg.dds.MessageCollectionNotification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.MessageCollector;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.ros2.RealtimeROS2Node;

public class ControllerNetworkSubscriber {
    private static final boolean DEBUG = false;
    private final CommandInputManager controllerCommandInputManager;
    private final StatusMessageOutputManager controllerStatusOutputManager;
    private final AtomicReference<MessageFilter> messageFilter;
    private final AtomicReference<MessageValidator> messageValidator;
    private final List<MessageCollector> messageCollectors = new ArrayList<MessageCollector>();
    private final List<Class<? extends Settable<?>>> listOfSupportedStatusMessages;
    private final List<Class<? extends Settable<?>>> listOfSupportedControlMessages;
    private final Map<Class<? extends Settable<?>>, IHMCRealtimeROS2Publisher<?>> statusMessagePublisherMap = new HashMap();
    private final RealtimeROS2Node realtimeROS2Node;
    private final ROS2Topic<?> inputTopic;
    private final ROS2Topic<?> outputTopic;

    public ControllerNetworkSubscriber(ROS2Topic<?> inputTopic, CommandInputManager controllerCommandInputManager, ROS2Topic<?> outputTopic, StatusMessageOutputManager controllerStatusOutputManager, RealtimeROS2Node realtimeROS2Node) {
        this.inputTopic = inputTopic;
        this.controllerCommandInputManager = controllerCommandInputManager;
        this.outputTopic = outputTopic;
        this.controllerStatusOutputManager = controllerStatusOutputManager;
        this.realtimeROS2Node = realtimeROS2Node;
        this.listOfSupportedStatusMessages = controllerStatusOutputManager.getListOfSupportedMessages();
        this.listOfSupportedControlMessages = controllerCommandInputManager.getListOfSupportedMessages();
        this.messageFilter = new AtomicReference<MessageFilter>(message -> true);
        this.messageValidator = new AtomicReference<MessageValidator>(message -> null);
        if (realtimeROS2Node == null) {
            LogTools.error((String)"No ROS2 node, {} cannot be created.", (Object)this.getClass().getSimpleName());
        }
        this.listOfSupportedStatusMessages.add(InvalidPacketNotificationPacket.class);
        this.createPublishersSubscribersForSupportedMessages();
        this.createGlobalStatusMessageListener();
    }

    public <T extends Settable<T>> void registerSubcriberWithMessageUnpacker(Class<T> multipleMessageType, int expectedMessageSize, MessageUnpackingTools.MessageUnpacker<T> messageUnpacker) {
        this.registerSubcriberWithMessageUnpacker(multipleMessageType, this.inputTopic, expectedMessageSize, messageUnpacker);
    }

    public <T extends Settable<T>> void registerSubcriberWithMessageUnpacker(Class<T> multipleMessageType, ROS2Topic<?> inputTopic, int expectedMessageSize, MessageUnpackingTools.MessageUnpacker<T> messageUnpacker) {
        this.registerSubcriberWithMessageUnpacker(multipleMessageType, inputTopic, null, expectedMessageSize, messageUnpacker);
    }

    public <T extends Settable<T>> void registerSubcriberWithMessageUnpacker(Class<T> multipleMessageType, ROS2Topic<?> inputTopic, ROS2QosProfile qosProfile, int expectedMessageSize, MessageUnpackingTools.MessageUnpacker<T> messageUnpacker) {
        ArrayList unpackedMessages = new ArrayList(expectedMessageSize);
        ROS2Topic topicName = inputTopic.withTypeName(multipleMessageType);
        try {
            Settable localInstance = (Settable)multipleMessageType.newInstance();
            NewMessageListener messageListener = s -> {
                s.takeNextData((Object)localInstance, null);
                this.unpackMultiMessage(multipleMessageType, messageUnpacker, unpackedMessages, localInstance);
            };
            if (qosProfile == null) {
                ROS2Tools.createCallbackSubscription((RealtimeROS2Node)this.realtimeROS2Node, multipleMessageType, (ROS2Topic)topicName, (NewMessageListener)messageListener);
            } else {
                ROS2Tools.createCallbackSubscription((RealtimeROS2Node)this.realtimeROS2Node, multipleMessageType, (String)topicName.toString(), (NewMessageListener)messageListener, (ROS2QosProfile)qosProfile, (ExceptionHandler)ROS2Tools.RUNTIME_EXCEPTION);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends Settable<T>> void unpackMultiMessage(Class<T> multipleMessageHolderClass, MessageUnpackingTools.MessageUnpacker<T> messageUnpacker, List<Settable<?>> unpackedMessages, T multipleMessageHolder) {
        String errorMessage = this.messageValidator.get().validate(multipleMessageHolder);
        if (errorMessage != null) {
            this.reportInvalidMessage(multipleMessageHolderClass, errorMessage);
            return;
        }
        if (this.testMessageWithMessageFilter(multipleMessageHolder)) {
            messageUnpacker.unpackMessage(multipleMessageHolder, unpackedMessages);
            for (int i = 0; i < unpackedMessages.size(); ++i) {
                this.receivedMessage(unpackedMessages.get(i));
            }
            unpackedMessages.clear();
        }
    }

    public void addMessageCollector(MessageCollector.MessageIDExtractor messageIDExtractor) {
        this.addMessageCollectors(messageIDExtractor, 1);
    }

    public void addMessageCollectors(MessageCollector.MessageIDExtractor messageIDExtractor, int numberOfSimultaneousCollectionsToSupport) {
        IHMCRealtimeROS2Publisher<MessageCollectionNotification> publisher = this.createPublisher(MessageCollectionNotification.class);
        this.listOfSupportedStatusMessages.add(MessageCollectionNotification.class);
        for (int i = 0; i < numberOfSimultaneousCollectionsToSupport; ++i) {
            this.messageCollectors.add(new MessageCollector(messageIDExtractor, this.listOfSupportedControlMessages));
        }
        MessageCollection messageCollection = new MessageCollection();
        ROS2Topic topicName = this.inputTopic.withTypeName(MessageCollection.class);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.realtimeROS2Node, MessageCollection.class, (ROS2Topic)topicName, s -> {
            s.takeNextData((Object)messageCollection, null);
            for (int i = 0; i < numberOfSimultaneousCollectionsToSupport; ++i) {
                MessageCollector collector = this.messageCollectors.get(i);
                if (collector.isCollecting()) continue;
                publisher.publish((Object)collector.startCollecting(messageCollection));
                return;
            }
            LogTools.warn((String)"No collector available to process the MessageCollection with ID: {}", (Object)messageCollection.getSequenceId());
        });
    }

    public void addMessageFilter(MessageFilter newFilter) {
        this.messageFilter.set(newFilter);
    }

    public void removeMessageFilter() {
        this.messageFilter.set(null);
    }

    public void addMessageValidator(MessageValidator newValidator) {
        this.messageValidator.set(newValidator);
    }

    public void removeMessageValidator() {
        this.messageValidator.set(null);
    }

    private <T extends Settable<T>> void createPublishersSubscribersForSupportedMessages() {
        Class<? extends Settable<?>> messageClass;
        int i;
        for (i = 0; i < this.listOfSupportedStatusMessages.size(); ++i) {
            messageClass = this.listOfSupportedStatusMessages.get(i);
            this.statusMessagePublisherMap.put(messageClass, this.createPublisher(messageClass));
        }
        for (i = 0; i < this.listOfSupportedControlMessages.size(); ++i) {
            messageClass = this.listOfSupportedControlMessages.get(i);
            Settable messageLocalInstance = (Settable)ROS2TopicNameTools.newMessageInstance(messageClass);
            ROS2Topic topicName = this.inputTopic.withTypeName(messageClass);
            ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)this.realtimeROS2Node, messageClass, (ROS2Topic)topicName, s -> {
                s.takeNextData((Object)messageLocalInstance, null);
                this.receivedMessage(messageLocalInstance);
            });
        }
    }

    private <T extends Settable<T>> IHMCRealtimeROS2Publisher<T> createPublisher(Class<T> messageClass) {
        ROS2Topic topicName = this.outputTopic.withTypeName(messageClass);
        IHMCRealtimeROS2Publisher publisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)this.realtimeROS2Node, messageClass, (ROS2Topic)topicName);
        return publisher;
    }

    private <T extends Settable<T>> void receivedMessage(Settable<?> message) {
        for (int collectorIndex = 0; collectorIndex < this.messageCollectors.size(); ++collectorIndex) {
            MessageCollector messageCollector = this.messageCollectors.get(collectorIndex);
            if (!messageCollector.isCollecting() || !messageCollector.interceptMessage(message)) continue;
            if (!messageCollector.isCollecting()) {
                List<Settable<?>> collectedMessages = messageCollector.getCollectedMessages();
                for (int i = 0; i < collectedMessages.size(); ++i) {
                    this.receivedMessage(collectedMessages.get(i));
                }
                messageCollector.reset();
            }
            return;
        }
        String errorMessage = this.messageValidator.get().validate(message);
        if (errorMessage != null) {
            this.reportInvalidMessage(message.getClass(), errorMessage);
            return;
        }
        if (this.testMessageWithMessageFilter(message)) {
            this.controllerCommandInputManager.submitMessage(message);
        }
    }

    private boolean testMessageWithMessageFilter(Settable<?> messageToTest) {
        return this.messageFilter.get().isMessageValid(messageToTest);
    }

    private void reportInvalidMessage(Class<?> messageClass, String errorMessage) {
        this.publishStatusMessage(MessageTools.createInvalidPacketNotificationPacket(messageClass, (String)errorMessage));
        LogTools.error((String)"Packet failed to validate: {}", (Object)messageClass.getSimpleName());
        LogTools.error((String)errorMessage);
    }

    private void createGlobalStatusMessageListener() {
        this.controllerStatusOutputManager.attachGlobalStatusMessageListener(statusMessage -> this.publishStatusMessage(statusMessage));
    }

    private <T> void publishStatusMessage(T message) {
        IHMCRealtimeROS2Publisher<?> publisher = this.statusMessagePublisherMap.get(message.getClass());
        publisher.publish(message);
    }

    public static interface MessageFilter {
        public boolean isMessageValid(Object var1);
    }

    public static interface MessageValidator {
        public String validate(Object var1);
    }
}

