/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyPositionControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyTaskspaceControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class RigidBodyPositionController
extends RigidBodyTaskspaceControlState {
    private final YoBoolean usingWeightFromMessage;
    private final YoInteger numberOfPointsInQueue;
    private final YoInteger numberOfPointsInGenerator;
    private final YoInteger numberOfPoints;
    private final ReferenceFrame bodyFrame;
    private final FrameQuaternion currentOrientation = new FrameQuaternion();
    private final RigidBodyPositionControlHelper positionHelper;
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper;

    public RigidBodyPositionController(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, ReferenceFrame controlFrame, ReferenceFrame baseFrame, YoDouble yoTime, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        super(RigidBodyControlMode.TASKSPACE, bodyToControl.getName(), yoTime, parentRegistry);
        String bodyName = bodyToControl.getName();
        String prefix = bodyName + "PositionTaskspace";
        this.numberOfPointsInQueue = new YoInteger(prefix + "NumberOfPointsInQueue", this.registry);
        this.numberOfPointsInGenerator = new YoInteger(prefix + "NumberOfPointsInGenerator", this.registry);
        this.numberOfPoints = new YoInteger(prefix + "NumberOfPoints", this.registry);
        this.bodyFrame = bodyToControl.getBodyFixedFrame();
        if (!controlFrame.getTransformToDesiredFrame(this.bodyFrame).getRotation().isIdentity()) {
            throw new RuntimeException("The control frame orientation of a position controlled body must be identity!");
        }
        this.usingWeightFromMessage = new YoBoolean(prefix + "UsingWeightFromMessage", this.registry);
        BooleanParameter useBaseFrameForControl = new BooleanParameter(prefix + "UseBaseFrameForControl", this.registry, false);
        this.positionHelper = new RigidBodyPositionControlHelper(prefix, bodyToControl, baseBody, elevator, controlFrame, baseFrame, (BooleanProvider)useBaseFrameForControl, (BooleanProvider)this.usingWeightFromMessage, (DoubleProvider)yoTime, this.registry, graphicsListRegistry);
        this.graphics.addAll(this.positionHelper.getGraphics());
        this.hideGraphics();
        this.statusHelper = new TaskspaceTrajectoryStatusMessageHelper((RigidBodyReadOnly)bodyToControl);
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.positionHelper.setGains(gains);
    }

    public void setWeights(Vector3DReadOnly weights) {
        this.positionHelper.setWeights(weights);
    }

    @Override
    public void holdCurrent() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.positionHelper.holdCurrent();
    }

    @Override
    public void holdCurrentDesired() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.currentOrientation.setToZero(this.bodyFrame);
        this.positionHelper.holdCurrentDesired((FrameQuaternionBasics)this.currentOrientation);
    }

    @Override
    public void goToPoseFromCurrent(FramePose3DReadOnly pose, double trajectoryTime) {
        this.goToPositionFromCurrent(pose.getPosition(), trajectoryTime);
    }

    @Override
    public void goToPose(FramePose3DReadOnly pose, double trajectoryTime) {
        this.goToPosition(pose.getPosition(), trajectoryTime);
    }

    public void goToPositionFromCurrent(FramePoint3DReadOnly position, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.positionHelper.goToPositionFromCurrent(position, trajectoryTime);
    }

    public void goToPosition(FramePoint3DReadOnly position, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.currentOrientation.setToZero(this.bodyFrame);
        this.positionHelper.goToPosition(position, (FrameQuaternionBasics)this.currentOrientation, trajectoryTime);
    }

    public void onEntry() {
    }

    public void doAction(double timeInState) {
        double timeInTrajectory = this.getTimeInTrajectory();
        this.trajectoryDone.set(this.positionHelper.doAction(timeInTrajectory));
        this.numberOfPointsInQueue.set(this.positionHelper.getNumberOfPointsInQueue());
        this.numberOfPointsInGenerator.set(this.positionHelper.getNumberOfPointsInGenerator());
        this.numberOfPoints.set(this.numberOfPointsInQueue.getIntegerValue() + this.numberOfPointsInGenerator.getIntegerValue());
        this.statusHelper.updateWithTimeInTrajectory(timeInTrajectory);
        this.updateGraphics();
    }

    @Override
    public boolean handleTrajectoryCommand(EuclideanTrajectoryControllerCommand command) {
        if (command.useCustomControlFrame() && !command.getControlFramePose().getRotation().isIdentity()) {
            LogTools.warn((String)"Specifying a control frame orientation for a body position controller is not supported!");
            this.clear();
            this.positionHelper.clear();
            return false;
        }
        this.currentOrientation.setToZero(this.bodyFrame);
        if (this.handleCommandInternal((Command<?, ?>)command) && this.positionHelper.handleTrajectoryCommand(command, (FrameQuaternionBasics)this.currentOrientation)) {
            this.usingWeightFromMessage.set(this.positionHelper.isMessageWeightValid());
            if (command.getExecutionMode() != ExecutionMode.STREAM) {
                this.statusHelper.registerNewTrajectory(command);
            }
            return true;
        }
        this.clear();
        this.positionHelper.clear();
        return false;
    }

    public PointFeedbackControlCommand getFeedbackControlCommand() {
        return this.positionHelper.getFeedbackControlCommand();
    }

    public void onExit() {
        this.positionHelper.onExit();
        this.hideGraphics();
        this.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.positionHelper.isEmpty();
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return this.positionHelper.getLastTrajectoryPointTime();
    }

    private void clear() {
        this.numberOfPointsInQueue.set(0);
        this.numberOfPointsInGenerator.set(0);
        this.numberOfPoints.set(0);
        this.usingWeightFromMessage.set(false);
        this.trajectoryDone.set(true);
        this.resetLastCommandId();
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.statusHelper.pollStatusMessage(this.positionHelper.getFeedbackControlCommand());
    }
}

