/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import us.ihmc.commonWalkingControlModules.controlModules.TaskspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyOrientationControlHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyTaskspaceControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SO3TrajectoryControllerCommand;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class RigidBodyOrientationController
extends RigidBodyTaskspaceControlState {
    private final FeedbackControlCommandList feedbackControlCommandList = new FeedbackControlCommandList();
    private final YoBoolean usingWeightFromMessage;
    private final YoInteger numberOfPointsInQueue;
    private final YoInteger numberOfPointsInGenerator;
    private final YoInteger numberOfPoints;
    private final RigidBodyOrientationControlHelper orientationHelper;
    private final YoBoolean hybridModeActive;
    private final RigidBodyJointControlHelper jointControlHelper;
    private final TaskspaceTrajectoryStatusMessageHelper statusHelper;

    public RigidBodyOrientationController(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, RigidBodyBasics elevator, ReferenceFrame baseFrame, YoDouble yoTime, RigidBodyJointControlHelper jointControlHelper, YoRegistry parentRegistry) {
        super(RigidBodyControlMode.TASKSPACE, bodyToControl.getName(), yoTime, parentRegistry);
        String bodyName = bodyToControl.getName();
        String prefix = bodyName + "OrientationTaskspace";
        this.numberOfPointsInQueue = new YoInteger(prefix + "NumberOfPointsInQueue", this.registry);
        this.numberOfPointsInGenerator = new YoInteger(prefix + "NumberOfPointsInGenerator", this.registry);
        this.numberOfPoints = new YoInteger(prefix + "NumberOfPoints", this.registry);
        this.usingWeightFromMessage = new YoBoolean(prefix + "UsingWeightFromMessage", this.registry);
        BooleanParameter useBaseFrameForControl = new BooleanParameter(prefix + "UseBaseFrameForControl", this.registry, false);
        MovingReferenceFrame controlFrame = bodyToControl.getBodyFixedFrame();
        this.orientationHelper = new RigidBodyOrientationControlHelper(prefix, bodyToControl, baseBody, elevator, (ReferenceFrame)controlFrame, baseFrame, (BooleanProvider)useBaseFrameForControl, (BooleanProvider)this.usingWeightFromMessage, (DoubleProvider)yoTime, this.registry);
        this.jointControlHelper = jointControlHelper;
        this.hybridModeActive = new YoBoolean(prefix + "HybridModeActive", this.registry);
        this.statusHelper = new TaskspaceTrajectoryStatusMessageHelper((RigidBodyReadOnly)bodyToControl);
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.orientationHelper.setGains(gains);
    }

    public void setWeights(Vector3DReadOnly weights) {
        this.orientationHelper.setWeights(weights);
    }

    @Override
    public void holdCurrent() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orientationHelper.holdCurrent();
    }

    @Override
    public void holdCurrentDesired() {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orientationHelper.holdCurrentDesired();
    }

    @Override
    public void goToPoseFromCurrent(FramePose3DReadOnly pose, double trajectoryTime) {
        this.goToOrientationFromCurrent(pose.getOrientation(), trajectoryTime);
    }

    @Override
    public void goToPose(FramePose3DReadOnly pose, double trajectoryTime) {
        this.goToOrientation(pose.getOrientation(), trajectoryTime);
    }

    public void goToOrientationFromCurrent(FrameQuaternionReadOnly orientation, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orientationHelper.goToOrientationFromCurrent(orientation, trajectoryTime);
    }

    public void goToOrientation(FrameQuaternionReadOnly orientation, double trajectoryTime) {
        this.clear();
        this.setTrajectoryStartTimeToCurrentTime();
        this.orientationHelper.goToOrientation(orientation, trajectoryTime);
    }

    public void onEntry() {
    }

    public void doAction(double timeInState) {
        double timeInTrajectory = this.getTimeInTrajectory();
        this.trajectoryDone.set(this.orientationHelper.doAction(timeInTrajectory));
        this.numberOfPointsInQueue.set(this.orientationHelper.getNumberOfPointsInQueue());
        this.numberOfPointsInGenerator.set(this.orientationHelper.getNumberOfPointsInGenerator());
        this.numberOfPoints.set(this.numberOfPointsInQueue.getIntegerValue() + this.numberOfPointsInGenerator.getIntegerValue());
        if (this.hybridModeActive.getBooleanValue()) {
            this.jointControlHelper.doAction(timeInTrajectory);
        }
        this.statusHelper.updateWithTimeInTrajectory(timeInTrajectory);
        this.updateGraphics();
    }

    @Override
    public boolean handleTrajectoryCommand(SO3TrajectoryControllerCommand command) {
        if (this.handleCommandInternal((Command<?, ?>)command) && this.orientationHelper.handleTrajectoryCommand(command)) {
            this.usingWeightFromMessage.set(this.orientationHelper.isMessageWeightValid());
            if (command.getExecutionMode() != ExecutionMode.STREAM) {
                this.statusHelper.registerNewTrajectory(command);
            }
            return true;
        }
        this.clear();
        this.orientationHelper.clear();
        return false;
    }

    @Override
    public boolean handleHybridTrajectoryCommand(SO3TrajectoryControllerCommand command, JointspaceTrajectoryCommand jointspaceCommand, double[] initialJointPositions) {
        if (this.handleTrajectoryCommand(command) && this.jointControlHelper.handleTrajectoryCommand(jointspaceCommand, initialJointPositions)) {
            this.hybridModeActive.set(true);
            this.statusHelper.registerNewTrajectory(command);
            return true;
        }
        this.clear();
        this.orientationHelper.clear();
        return false;
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        if (Math.abs(this.orientationHelper.getFeedbackControlCommand().getBodyFixedOrientationToControl().getS()) < 0.99999) {
            throw new RuntimeException("Control frame orientations for orientation control only are not supported!");
        }
        if (this.hybridModeActive.getBooleanValue()) {
            this.feedbackControlCommandList.clear();
            this.feedbackControlCommandList.addCommand(this.orientationHelper.getFeedbackControlCommand());
            this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
            return this.feedbackControlCommandList;
        }
        return this.orientationHelper.getFeedbackControlCommand();
    }

    public FrameQuaternionReadOnly getDesiredOrientation() {
        return this.orientationHelper.getFeedbackControlCommand().getReferenceOrientation();
    }

    @Override
    public FeedbackControlCommand<?> createFeedbackControlTemplate() {
        this.feedbackControlCommandList.clear();
        this.feedbackControlCommandList.addCommand(this.orientationHelper.getFeedbackControlCommand());
        if (this.jointControlHelper != null) {
            this.feedbackControlCommandList.addCommand(this.jointControlHelper.getJointspaceCommand());
        }
        return this.feedbackControlCommandList;
    }

    public void onExit() {
        this.orientationHelper.onExit();
        this.hideGraphics();
        this.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.orientationHelper.isEmpty();
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return this.orientationHelper.getLastTrajectoryPointTime();
    }

    private void clear() {
        this.numberOfPointsInQueue.set(0);
        this.numberOfPointsInGenerator.set(0);
        this.numberOfPoints.set(0);
        this.usingWeightFromMessage.set(false);
        this.trajectoryDone.set(true);
        this.resetLastCommandId();
    }

    public TaskspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.statusHelper.pollStatusMessage(this.orientationHelper.getFeedbackControlCommand());
    }
}

