/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import controller_msgs.msg.dds.JointspaceTrajectoryStatusMessage;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.controlModules.JointspaceTrajectoryStatusMessageHelper;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlState;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyJointControlHelper;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.JointspaceTrajectoryCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RigidBodyJointspaceControlState
extends RigidBodyControlState {
    public static final int maxPoints = 10000;
    public static final int maxPointsInGenerator = 5;
    private final RigidBodyJointControlHelper jointControlHelper;
    private final JointspaceTrajectoryStatusMessageHelper statusHelper;
    private final int numberOfJoints;
    private final double[] jointsHomeConfiguration;

    public RigidBodyJointspaceControlState(String bodyName, OneDoFJointBasics[] jointsToControl, TObjectDoubleHashMap<String> homeConfiguration, YoDouble yoTime, RigidBodyJointControlHelper jointControlHelper, YoRegistry parentRegistry) {
        super(RigidBodyControlMode.JOINTSPACE, bodyName, yoTime, parentRegistry);
        this.jointControlHelper = jointControlHelper;
        this.numberOfJoints = jointsToControl.length;
        this.jointsHomeConfiguration = new double[this.numberOfJoints];
        this.statusHelper = new JointspaceTrajectoryStatusMessageHelper((OneDoFJointReadOnly[])jointsToControl);
        for (int jointIdx = 0; jointIdx < this.numberOfJoints; ++jointIdx) {
            OneDoFJointBasics joint = jointsToControl[jointIdx];
            String jointName = joint.getName();
            if (!homeConfiguration.contains((Object)jointName)) {
                throw new RuntimeException(this.warningPrefix + "Can not create control manager since joint home configuration is not defined.");
            }
            this.jointsHomeConfiguration[jointIdx] = homeConfiguration.get((Object)jointName);
        }
    }

    public void setDefaultWeights(Map<String, DoubleProvider> weights) {
        this.jointControlHelper.setDefaultWeights(weights);
    }

    public void setDefaultWeight(DoubleProvider weight) {
        this.jointControlHelper.setDefaultWeight(weight);
    }

    public void setGains(Map<String, PIDGainsReadOnly> gains) {
        this.jointControlHelper.setGains(gains);
    }

    public void setGains(YoPIDGains gains) {
        this.jointControlHelper.setGains(gains);
    }

    public void holdCurrent() {
        this.jointControlHelper.overrideTrajectory();
        this.jointControlHelper.setWeightsToDefaults();
        this.resetLastCommandId();
        this.setTrajectoryStartTimeToCurrentTime();
        this.jointControlHelper.queueInitialPointsAtCurrent();
        this.jointControlHelper.startTrajectoryExecution();
        this.trajectoryDone.set(false);
    }

    public void holdCurrentDesired() {
        this.jointControlHelper.overrideTrajectory();
        this.jointControlHelper.setWeightsToDefaults();
        this.resetLastCommandId();
        this.setTrajectoryStartTimeToCurrentTime();
        this.jointControlHelper.queueInitialPointsAtCurrentDesired();
        this.jointControlHelper.startTrajectoryExecution();
        this.trajectoryDone.set(false);
    }

    public void goHome(double trajectoryTime, double[] initialJointPositions) {
        this.jointControlHelper.overrideTrajectory();
        this.jointControlHelper.setWeightsToDefaults();
        this.resetLastCommandId();
        this.setTrajectoryStartTimeToCurrentTime();
        this.jointControlHelper.queuePointsAtTimeWithZeroVelocity(0.0, initialJointPositions);
        this.jointControlHelper.queuePointsAtTimeWithZeroVelocity(trajectoryTime, this.jointsHomeConfiguration);
        this.jointControlHelper.startTrajectoryExecution();
        this.trajectoryDone.set(false);
    }

    public void goHomeFromCurrent(double trajectoryTime) {
        this.jointControlHelper.overrideTrajectory();
        this.jointControlHelper.setWeightsToDefaults();
        this.resetLastCommandId();
        this.setTrajectoryStartTimeToCurrentTime();
        this.jointControlHelper.queueInitialPointsAtCurrent();
        this.jointControlHelper.queuePointsAtTimeWithZeroVelocity(trajectoryTime, this.jointsHomeConfiguration);
        this.jointControlHelper.startTrajectoryExecution();
        this.trajectoryDone.set(false);
    }

    public void doAction(double timeInState) {
        double timeInTrajectory = this.getTimeInTrajectory();
        this.statusHelper.updateWithTimeInTrajectory(timeInTrajectory);
        this.trajectoryDone.set(this.jointControlHelper.doAction(timeInTrajectory));
    }

    public boolean handleTrajectoryCommand(JointspaceTrajectoryCommand command, double[] initialJointPositions) {
        if (!this.handleCommandInternal((Command<?, ?>)command)) {
            return false;
        }
        if (this.jointControlHelper.handleTrajectoryCommand(command, initialJointPositions)) {
            this.statusHelper.registerNewTrajectory(command);
            return true;
        }
        return false;
    }

    @Override
    public double getLastTrajectoryPointTime() {
        return this.jointControlHelper.getLastTrajectoryPointTime();
    }

    @Override
    public boolean isEmpty() {
        return this.jointControlHelper.isEmpty();
    }

    public double getJointDesiredPosition(int jointIdx) {
        return this.jointControlHelper.getJointDesiredPosition(jointIdx);
    }

    public double getJointDesiredVelocity(int jointIdx) {
        return this.jointControlHelper.getJointDesiredVelocity(jointIdx);
    }

    public void onEntry() {
    }

    public void onExit() {
    }

    @Override
    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return this.jointControlHelper.getJointspaceCommand();
    }

    public JointspaceTrajectoryStatusMessage pollStatusToReport() {
        return this.statusHelper.pollStatusMessage(this.jointControlHelper.getJointspaceCommand());
    }
}

