/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controlModules.rigidBody;

import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.WrenchTrajectoryControllerCommand;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.math.trajectories.LinearSpatialVectorTrajectoryGenerator;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class RigidBodyExternalWrenchManager
extends RigidBodyControlState {
    private final ExternalWrenchCommand externalWrenchCommand = new ExternalWrenchCommand();
    private final YoInteger numberOfPointsInQueue;
    private final YoInteger numberOfPointsInGenerator;
    private final YoInteger numberOfPoints;
    private final SpatialVector spatialVector = new SpatialVector();
    private final Wrench desiredWrench = new Wrench();
    private final LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint lastPointAdded = new LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint();
    private final RecyclingArrayDeque<LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint> pointQueue = new RecyclingArrayDeque(10000, LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint.class, LinearSpatialVectorTrajectoryGenerator.SpatialWaypointBasics::set);
    private final LinearSpatialVectorTrajectoryGenerator trajectoryGenerator;
    private final RigidBodyBasics bodyToControl;
    private final MovingReferenceFrame bodyFrame;
    private final MovingReferenceFrame baseFrame;
    private final FramePose3DReadOnly defaultControlFramePose;
    private final PoseReferenceFrame activeControlFrame;

    public RigidBodyExternalWrenchManager(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, ReferenceFrame controlFrame, YoDouble yoTime, YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        super(null, bodyToControl.getName() + "Wrench", yoTime, parentRegistry);
        this.bodyToControl = bodyToControl;
        this.bodyFrame = bodyToControl.getBodyFixedFrame();
        this.baseFrame = baseBody.getBodyFixedFrame();
        this.defaultControlFramePose = new FramePose3D((ReferenceFrame)this.bodyFrame, (RigidBodyTransformReadOnly)controlFrame.getTransformToDesiredFrame((ReferenceFrame)this.bodyFrame));
        this.activeControlFrame = new PoseReferenceFrame("activeControlFrame", (ReferenceFrame)bodyToControl.getBodyFixedFrame());
        String prefix = bodyToControl.getName() + "Wrench";
        this.numberOfPointsInQueue = new YoInteger(prefix + "NumberOfPointsInQueue", this.registry);
        this.numberOfPointsInGenerator = new YoInteger(prefix + "NumberOfPointsInGenerator", this.registry);
        this.numberOfPoints = new YoInteger(prefix + "NumberOfPoints", this.registry);
        this.trajectoryGenerator = new LinearSpatialVectorTrajectoryGenerator(prefix, 5, ReferenceFrame.getWorldFrame(), this.registry);
        this.trajectoryGenerator.clear((ReferenceFrame)this.baseFrame);
    }

    private void setDefaultControlFrame() {
        this.activeControlFrame.setPoseAndUpdate(this.defaultControlFramePose);
    }

    private void setControlFramePose(RigidBodyTransform controlFramePoseInBody) {
        this.activeControlFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)controlFramePoseInBody);
    }

    public void getDesiredWrench(WrenchBasics wrenchToPack) {
        if (this.trajectoryGenerator.isEmpty()) {
            wrenchToPack.setToZero((ReferenceFrame)this.bodyFrame, (ReferenceFrame)this.bodyFrame);
        } else {
            this.spatialVector.setIncludingFrame(this.trajectoryGenerator.getCurrentValue());
            this.spatialVector.changeFrame((ReferenceFrame)this.activeControlFrame);
            wrenchToPack.setIncludingFrame((ReferenceFrame)this.bodyFrame, (SpatialVectorReadOnly)this.spatialVector);
            wrenchToPack.changeFrame((ReferenceFrame)this.bodyFrame);
        }
    }

    public void onEntry() {
        this.clear();
    }

    public void onExit() {
    }

    public void doAction(double timeInState) {
        double timeInTrajectory = this.getTimeInTrajectory();
        boolean done = false;
        if (this.trajectoryGenerator.isDone() || this.trajectoryGenerator.getLastWaypointTime() <= timeInTrajectory) {
            done = this.fillAndReinitializeTrajectories();
        }
        if (!done) {
            this.trajectoryGenerator.compute(timeInTrajectory);
            this.getDesiredWrench((WrenchBasics)this.desiredWrench);
            this.desiredWrench.negate();
            this.externalWrenchCommand.set(this.bodyToControl, (WrenchReadOnly)this.desiredWrench);
        }
        this.trajectoryDone.set(done);
        this.numberOfPointsInQueue.set(this.getNumberOfPointsInQueue());
        this.numberOfPointsInGenerator.set(this.getNumberOfPointsInGenerator());
        this.numberOfPoints.set(this.numberOfPointsInQueue.getIntegerValue() + this.numberOfPointsInGenerator.getIntegerValue());
        this.updateGraphics();
    }

    private boolean fillAndReinitializeTrajectories() {
        if (this.pointQueue.isEmpty()) {
            return true;
        }
        if (!this.trajectoryGenerator.isEmpty()) {
            this.trajectoryGenerator.clear();
            this.lastPointAdded.changeFrame(this.trajectoryGenerator.getCurrentTrajectoryFrame());
            this.trajectoryGenerator.appendWaypoint((LinearSpatialVectorTrajectoryGenerator.SpatialWaypointBasics)this.lastPointAdded);
        }
        int currentNumberOfWaypoints = this.trajectoryGenerator.getCurrentNumberOfWaypoints();
        int pointsToAdd = 5 - currentNumberOfWaypoints;
        for (int pointIdx = 0; pointIdx < pointsToAdd && !this.pointQueue.isEmpty(); ++pointIdx) {
            LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint pointToAdd = (LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint)this.pointQueue.pollFirst();
            this.lastPointAdded.setIncludingFrame((LinearSpatialVectorTrajectoryGenerator.SpatialWaypointBasics)pointToAdd);
            this.trajectoryGenerator.appendWaypoint((LinearSpatialVectorTrajectoryGenerator.SpatialWaypointBasics)pointToAdd);
        }
        this.trajectoryGenerator.initialize();
        return false;
    }

    public boolean handleWrenchTrajectoryCommand(WrenchTrajectoryControllerCommand command) {
        if (!this.handleCommandInternal((Command<?, ?>)command) || command.getNumberOfTrajectoryPoints() == 0) {
            this.clear();
            return false;
        }
        if (command.getExecutionMode() == ExecutionMode.OVERRIDE || this.isEmpty()) {
            this.getDesiredWrench((WrenchBasics)this.desiredWrench);
            this.clear();
            if (command.useCustomControlFrame()) {
                this.setControlFramePose(command.getControlFramePose());
            }
            this.trajectoryGenerator.changeFrame(command.getTrajectoryFrame());
            if (command.getTrajectoryPointTime(0) > 0.05) {
                this.desiredWrench.changeFrame((ReferenceFrame)this.activeControlFrame);
                this.queueInitialPoint((WrenchReadOnly)this.desiredWrench);
            }
        } else if (command.getTrajectoryFrame() != this.trajectoryGenerator.getCurrentTrajectoryFrame()) {
            LogTools.warn((String)(this.warningPrefix + "Was executing in " + this.trajectoryGenerator.getCurrentTrajectoryFrame() + " can not switch to " + command.getTrajectoryFrame() + " without override."));
            return false;
        }
        for (int i = 0; i < command.getNumberOfTrajectoryPoints(); ++i) {
            double trajectoryPointTime = command.getTrajectoryPointTime(i);
            if (!this.checkTime(trajectoryPointTime)) {
                return false;
            }
            SpatialVector trajectoryPoint = command.getTrajectoryPoint(i);
            trajectoryPoint.changeFrame(this.trajectoryGenerator.getCurrentTrajectoryFrame());
            if (this.queuePoint(trajectoryPointTime, (SpatialVectorReadOnly)trajectoryPoint)) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfPointsInQueue() {
        return this.pointQueue.size();
    }

    public int getNumberOfPointsInGenerator() {
        return this.trajectoryGenerator.getCurrentNumberOfWaypoints();
    }

    private void queueInitialPoint(WrenchReadOnly initialWrench) {
        LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint initialPoint = (LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint)this.pointQueue.addLast();
        initialPoint.setIncludingFrame((SpatialVectorReadOnly)initialWrench);
        initialPoint.changeFrame(this.trajectoryGenerator.getCurrentTrajectoryFrame());
        initialPoint.setTime(0.0);
    }

    private boolean queuePoint(double time, SpatialVectorReadOnly trajectoryPoint) {
        if (this.pointQueue.size() >= 10000) {
            LogTools.warn((String)(this.warningPrefix + "Reached maximum capacity of " + 10000 + " can not execute trajectory."));
            return false;
        }
        ((LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint)this.pointQueue.addLast()).setIncludingFrame(time, trajectoryPoint);
        return true;
    }

    private boolean checkTime(double time) {
        if (time <= this.getLastTrajectoryPointTime()) {
            LogTools.warn((String)(this.warningPrefix + "Time in trajectory must be strictly increasing."));
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (!this.pointQueue.isEmpty()) {
            return false;
        }
        return this.trajectoryGenerator.isDone();
    }

    @Override
    public double getLastTrajectoryPointTime() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.pointQueue.isEmpty()) {
            return this.trajectoryGenerator.getLastWaypointTime();
        }
        return ((LinearSpatialVectorTrajectoryGenerator.SpatialWaypoint)this.pointQueue.peekLast()).getTime();
    }

    public void clear() {
        this.numberOfPointsInQueue.set(0);
        this.numberOfPointsInGenerator.set(0);
        this.numberOfPoints.set(0);
        this.trajectoryDone.set(true);
        this.resetLastCommandId();
        this.trajectoryGenerator.clear((ReferenceFrame)this.baseFrame);
        this.setDefaultControlFrame();
        this.pointQueue.clear();
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        if (this.trajectoryDone.getValue()) {
            return null;
        }
        return this.externalWrenchCommand;
    }
}

